/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.wsdl.util.internal;

import com.ibm.appscan.frameworks.FileLocations;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSDLReportingUtil {
    public static final String SERVICE = "service";
    public static final String TNS = "tns";
    public static final String SERVICE_NAME = "serviceName";
    public static final String METHOD_SIGNATURE = "methodSignature";
    public static final String SERVICES_ROOT = "services";
    public static final String WSDL_BOOLEAN = "boolean";
    public static final String WSDL_BYTE = "byte";
    public static final String WSDL_DOUBLE = "double";
    public static final String WSDL_FLOAT = "float";
    public static final String WSDL_INTEGER = "integer";
    public static final String WSDL_LONG = "long";
    public static final String WSDL_SHORT = "short";
    public static final String WSDL_STRING = "string";
    public static final String WSDL_DATE_TIME = "dateTime";
    public static final String WSDL_DATE = "date";
    public static final String WSDL_BIG_DECIMAL = "decimal";
    public static final String WSDL_INT = "int";
    public static final String WSDL_URI = "anyURI";
    public static final String WSDL_QNAME = "QName";
    private static Document xmlDocument;
    private static String outputFilePath;
    private static Element servicesElement;

    public static void reportService(String targetNameSpace, String serviceName, String methodSignature) {
        Element elem;
        if (xmlDocument != null && servicesElement != null && outputFilePath != null && (elem = xmlDocument.createElement(SERVICE)) != null) {
            servicesElement.appendChild(elem);
            if (targetNameSpace != null) {
                elem.setAttribute(TNS, targetNameSpace.toLowerCase());
            }
            if (serviceName != null) {
                elem.setAttribute(SERVICE_NAME, serviceName.toLowerCase());
            }
            if (methodSignature != null) {
                elem.setAttribute(METHOD_SIGNATURE, methodSignature.toLowerCase());
            }
        }
    }

    public static void reportService(String targetNamespace, String serviceName, String operationName, ArrayList<String> wsdlParams) {
        String signature = operationName + "(";
        for (int i = 0; i < wsdlParams.size(); ++i) {
            if (i != 0) {
                signature = signature + ",";
            }
            signature = signature + wsdlParams.get(i);
        }
        signature = signature + ")";
        WSDLReportingUtil.reportService(targetNamespace, serviceName, signature);
    }

    public static Map<String, Map<String, Set<String>>> readXML(String xml) {
        HashMap<String, Map<String, Set<String>>> reportedServices = new HashMap<String, Map<String, Set<String>>>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            Node root;
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(xml);
            NodeList childNodes = document.getChildNodes();
            if (childNodes.getLength() == 1 && (root = childNodes.item(0)).getNodeName().equals(SERVICES_ROOT)) {
                childNodes = root.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    HashSet<String> methodsSet;
                    Element service;
                    if (!(childNodes.item(i) instanceof Element) || !(service = (Element)childNodes.item(i)).getNodeName().equals(SERVICE)) continue;
                    String tns = service.getAttribute(TNS);
                    String serviceName = service.getAttribute(SERVICE_NAME);
                    String methodSignature = service.getAttribute(METHOD_SIGNATURE);
                    if (tns == null || service == null || methodSignature == null) continue;
                    HashMap<String, HashSet<String>> servicesMap = (HashMap<String, HashSet<String>>)reportedServices.get(tns);
                    if (servicesMap == null) {
                        servicesMap = new HashMap<String, HashSet<String>>();
                        reportedServices.put(tns, servicesMap);
                    }
                    if ((methodsSet = (HashSet<String>)servicesMap.get(serviceName)) == null) {
                        methodsSet = new HashSet<String>();
                        servicesMap.put(serviceName, methodsSet);
                    }
                    methodsSet.add(methodSignature);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return reportedServices;
    }

    public static void initXmlDocument(String filePath) {
        if (filePath != null) {
            outputFilePath = filePath;
            File file = new File(filePath);
            if (file.exists() && xmlDocument != null) {
                return;
            }
            try {
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                xmlDocument = docBuilder.newDocument();
                servicesElement = xmlDocument.createElement(SERVICES_ROOT);
                xmlDocument.appendChild(servicesElement);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveXmlDocument() {
        if (xmlDocument != null && outputFilePath != null) {
            try {
                Transformer tr = TransformerFactory.newInstance().newTransformer();
                tr.setOutputProperty("indent", "yes");
                tr.setOutputProperty("method", "xml");
                tr.setOutputProperty("encoding", "UTF-8");
                tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                tr.transform(new DOMSource(xmlDocument), new StreamResult(new FileOutputStream(outputFilePath)));
            }
            catch (TransformerException te) {
                System.out.println(te.getMessage());
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
            }
        }
        WSDLReportingUtil.readXML(outputFilePath);
    }

    public static String getServicesFilePath(FileLocations fileLocations) {
        String filePath = fileLocations.getProjectFile();
        if (filePath != null && filePath.lastIndexOf(".") != -1) {
            filePath = filePath.substring(0, filePath.lastIndexOf("."));
            filePath = filePath + "_services.xml";
            return filePath;
        }
        return null;
    }
}

