/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.discovery.containers.docker;

import com.hcl.appscan.discovery.containers.docker.IDockerHandler;
import com.hcl.appscan.discovery.containers.utils.ContainerUtils;
import com.hcl.appscan.discovery.containers.utils.TarUtils;
import com.hcl.appscan.internal.discovery.containers.docker.ContainerArchiveHandler;
import com.hcl.appscan.internal.discovery.containers.docker.ContainerHandler;
import com.hcl.appscan.internal.discovery.containers.docker.ImageArchiveHandler;
import com.hcl.appscan.internal.discovery.containers.docker.ImageHandler;
import com.ibm.appscan.common.IProgress;
import java.io.File;

public class DockerHandlerFactory {
    public static IDockerHandler getHandler(String name, IProgress progress) {
        return DockerHandlerFactory.getHandler(name, progress, false);
    }

    public static IDockerHandler getHandler(String name, IProgress progress, boolean isContainer) {
        IDockerHandler handler = null;
        if (TarUtils.isTarArchive(name)) {
            File archive = new File(name);
            if (ContainerUtils.isImageArchive(archive)) {
                handler = new ImageArchiveHandler(name, progress);
            } else if (ContainerUtils.isContainerArchive(archive)) {
                handler = new ContainerArchiveHandler(name);
            }
        } else {
            if (isContainer && ContainerUtils.isValidContainerName(name)) {
                return new ContainerHandler(name, progress);
            }
            if (!isContainer && name != null && ContainerUtils.isValidImageName(name)) {
                return new ImageHandler(name, progress);
            }
        }
        return handler;
    }
}

