/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.jstaint.util;

import com.ibm.wala.jstaint.util.Cache;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Pair;
import java.util.LinkedList;
import java.util.Map;

public class FixedSizeCache<K, V>
implements Cache<K, V> {
    private static final double FRACTION_TO_REMOVE = 0.1;
    private final Map<K, Pair<Long, V>> cache;
    private final LinkedList<K> uses;
    private final int MAX_SIZE;
    private long clock;

    public FixedSizeCache(int size) {
        this.MAX_SIZE = size;
        this.clock = 0L;
        this.cache = HashMapFactory.make();
        this.uses = new LinkedList();
    }

    private void use(K k) {
        this.uses.remove(k);
        this.uses.addFirst(k);
    }

    private void reduceCache() {
        int toRemove = (int)((double)this.MAX_SIZE * 0.1);
        for (int i = 0; i < toRemove && !this.uses.isEmpty(); ++i) {
            this.cache.remove(this.uses.removeLast());
        }
    }

    @Override
    public void put(K key, V value) {
        this.use(key);
        if (this.cache.size() > this.MAX_SIZE) {
            this.reduceCache();
        }
        this.cache.put(key, Pair.make((Object)(++this.clock), value));
    }

    @Override
    public V get(K key) {
        this.use(key);
        Pair<Long, V> p = this.cache.get(key);
        if (p == null) {
            return null;
        }
        return (V)p.snd;
    }

    @Override
    public boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }
}

