/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.highlevelapi;

import com.ibm.appscan.frameworks.highlevelapi.Global;
import com.ibm.appscan.frameworks.highlevelapi.TaintedParam;
import com.ibm.appscan.frameworks.highlevelapi.processing.F4FActionProcessor;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.HighLevelSyntheticMethod;
import com.ibm.appscan.frameworks.specinfo.IFrameworkInfo;
import com.ibm.appscan.frameworks.specinfo.SyntheticExpr;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public class F4FActions {
    private final Map<String, Collection<TaintedParam>> callback2TaintedParams = HashMapFactory.make();
    private final Map<String, Map<String, Map<Integer, Pattern>>> callReplacementOldSig2NewSigAndPatterns = HashMapFactory.make();
    private final Map<String, SyntheticExpr> callReplacementSig2Expr = HashMapFactory.make();
    private final List<Pair<HighLevelSyntheticMethod, Boolean>> highLevelSyntheticMethods = new ArrayList<Pair<HighLevelSyntheticMethod, Boolean>>();
    private final List<Global> globals = new ArrayList<Global>();
    private final Collection<IFrameworkInfo> additionalFrameworkInfo = HashSetFactory.make();

    public void addTaintedCallback(IMethod method, int numParams) {
        this.addTaintedCallback(F4FActionProcessor.getVDBSig(method), numParams);
    }

    public void addTaintedCallback(String vdbMethodSig, int numParams) {
        ArrayList<TaintedParam> taintedParams = new ArrayList<TaintedParam>(numParams);
        for (int i = 0; i < numParams; ++i) {
            taintedParams.add(new TaintedParam(i, ""));
        }
        this.callback2TaintedParams.put(vdbMethodSig, taintedParams);
    }

    public void replaceCalls(String oldVDBSig, String newVDBSig) {
        this.replaceCallsWithParamPattern(oldVDBSig, Collections.singletonMap(newVDBSig, null));
    }

    public void replaceCallsWithSyntheticExpr(String vdbSig, SyntheticExpr expr) {
        if (this.callReplacementOldSig2NewSigAndPatterns.containsKey(vdbSig = StringEscapeUtils.escapeXml((String)vdbSig)) || this.callReplacementSig2Expr.containsKey(vdbSig)) {
            throw new IllegalArgumentException("already have a replacement for calls to " + vdbSig);
        }
        this.callReplacementSig2Expr.put(vdbSig, expr);
    }

    public void replaceCallsWithParamPattern(String oldVDBSig, Map<String, Map<Integer, Pattern>> newSig2Pattern) {
        if (this.callReplacementOldSig2NewSigAndPatterns.containsKey(oldVDBSig = StringEscapeUtils.escapeXml((String)oldVDBSig)) || this.callReplacementSig2Expr.containsKey(oldVDBSig)) {
            throw new IllegalArgumentException("already have a replacement for calls to " + oldVDBSig);
        }
        HashMap realSig2Pattern = HashMapFactory.make();
        for (String newVDBSig : newSig2Pattern.keySet()) {
            String escaped = StringEscapeUtils.escapeXml((String)newVDBSig);
            if (!this.sameDescriptors(oldVDBSig, escaped)) {
                throw new IllegalArgumentException("descriptors for old method " + oldVDBSig + " and new method " + newVDBSig + " must be identical");
            }
            realSig2Pattern.put(escaped, newSig2Pattern.get(newVDBSig));
        }
        this.callReplacementOldSig2NewSigAndPatterns.put(oldVDBSig, realSig2Pattern);
    }

    private boolean sameDescriptors(String oldVDBSig, String newVDBSig) {
        String oldDescriptor = oldVDBSig.substring(oldVDBSig.indexOf(40));
        String newDescriptor = newVDBSig.substring(newVDBSig.indexOf(40));
        return oldDescriptor.equals(newDescriptor);
    }

    public void addFrameworkInfo(IFrameworkInfo info) {
        this.additionalFrameworkInfo.add(info);
    }

    public void addTaintedCallback(String vdbMethodSig, Collection<TaintedParam> taintedParams) {
        if (this.callback2TaintedParams.containsKey(vdbMethodSig)) {
            throw new IllegalArgumentException(vdbMethodSig + " is already a tainted callback");
        }
        this.callback2TaintedParams.put(vdbMethodSig, taintedParams);
    }

    public void addHighLevelSyntheticMethod(HighLevelSyntheticMethod m) {
        this.addHighLevelSyntheticMethod(m, true);
    }

    public void addHighLevelSyntheticMethod(HighLevelSyntheticMethod m, boolean isEntrypoint) {
        this.highLevelSyntheticMethods.add((Pair<HighLevelSyntheticMethod, Boolean>)Pair.make((Object)m, (Object)isEntrypoint));
    }

    public Global createGlobal(String name, String declaredVDBType, boolean isEntrypointScoped) {
        Global result = Global.make(name, declaredVDBType, isEntrypointScoped);
        this.globals.add(result);
        return result;
    }

    public Global createGlobal(String name, IClass declaredClass, boolean isEntrypointScoped) {
        return this.createGlobal(name, F4FActionProcessor.getVDBTypeName(declaredClass), isEntrypointScoped);
    }

    public Collection<Global> getGlobals() {
        return this.globals;
    }

    public Collection<IFrameworkInfo> getAdditionalFrameworkInfo() {
        return this.additionalFrameworkInfo;
    }

    public Map<String, Map<String, Map<Integer, Pattern>>> getCallReplacement2SigsInfo() {
        return this.callReplacementOldSig2NewSigAndPatterns;
    }

    public Map<String, SyntheticExpr> getCallReplacement2ExprInfo() {
        return this.callReplacementSig2Expr;
    }

    public Map<String, Collection<TaintedParam>> getCallback2TaintedParams() {
        return this.callback2TaintedParams;
    }

    public List<Pair<HighLevelSyntheticMethod, Boolean>> getHighLevelSyntheticMethods() {
        return this.highLevelSyntheticMethods;
    }

    public String toString() {
        return "F4FActions [callback2TaintedParams=" + this.callback2TaintedParams + ", callReplacementOldSig2NewSigAndPatterns=" + this.callReplacementOldSig2NewSigAndPatterns + ", highLevelSyntheticMethods=" + this.highLevelSyntheticMethods + ", additionalFrameworkInfo=" + this.additionalFrameworkInfo + "]";
    }
}

