/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.jee;

import com.hcl.appscan.discovery.java.utils.IClasspathContributor;
import com.hcl.appscan.discovery.java.utils.IJavaStrategy;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.utils.ArchiveUtil;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.dir.CrawlingStrategy;
import com.ibm.appscan.discovery.jsp.compilers.JSPCompilerClasspathContributor;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;

public class EARStrategy
extends CrawlingStrategy {
    private File m_crawlRoot;

    public EARStrategy() {
    }

    EARStrategy(File file, IStrategyFactoryRegistry registry) {
        this.init(file, registry);
    }

    public String getType() {
        return "bytecode";
    }

    public String getStrategyClass() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getLanguageType() {
        return "Java";
    }

    protected boolean stageScanTarget(IScanTargetMinProxy proxy, IProgress progress) {
        proxy.inheritedSetBuildInfo("jsp_compiler", "Default Tomcat JSP Compiler");
        File target = this.getRoot(proxy);
        if (target.isFile()) {
            this.m_crawlRoot = this.getStagingDirectory(true, target.getName());
            try {
                Iterator iterator = ArchiveUtil.unzip((File)target, (File)this.m_crawlRoot, (String[])new String[0]).iterator();
                while (iterator.hasNext()) {
                    Message message;
                    Message message2 = message = (Message)iterator.next();
                    message2.getClass();
                    message.setMessageSource(new Message.MessageSource(message2, proxy.getPath(), null));
                    proxy.getLogManager().log(message);
                }
            }
            catch (AppScanException | IOException e) {
                proxy.getErrorManager().reportError(e.getMessage(), e);
                return false;
            }
        } else {
            this.m_crawlRoot = target;
        }
        return true;
    }

    protected File getCrawlRoot(IScanTargetMinProxy proxy) {
        return this.m_crawlRoot;
    }

    protected void createScanTarget(IScanTargetProxy proxy, ScanTargetStrategy strategy) {
        String jspCompiler;
        if (strategy instanceof IJavaStrategy && (jspCompiler = proxy.getBuildInfo().getProperty("jsp_compiler")) != null && !"NONE".equals(jspCompiler)) {
            ((IJavaStrategy)strategy).addClasspathContributor((IClasspathContributor)new JSPCompilerClasspathContributor(jspCompiler));
        }
        super.createScanTarget(proxy, strategy);
    }
}

