/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common;

import com.ibm.security.annotation.SuppressSecurityTrace;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;

public final class MessagesBundle {
    private ResourceBundle m_bundle;

    public MessagesBundle(String name, Locale locale, ClassLoader cl) {
        this.m_bundle = ResourceBundle.getBundle(name, locale, cl);
    }

    public MessagesBundle(String name, ClassLoader cl) {
        this(name, Locale.getDefault(), cl);
    }

    @SuppressSecurityTrace
    public static String bind(String message, Object ... args) {
        if (message.contains("{0}") && args.length > 0) {
            try {
                return MessageFormat.format(message, args);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return message;
    }

    @SuppressSecurityTrace
    public String getMessage(String key, Object ... args) {
        return MessagesBundle.bind(this.m_bundle.getString(key), args);
    }

    public Set<String> keySet() {
        return this.m_bundle.keySet();
    }
}

