/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common;

import com.ibm.appscan.common.utils.IOUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class VersionInfo {
    public static final String VERSION_FILE = "version.info";
    private File m_file;
    private String m_version;
    private String m_os;
    private String m_keyID;
    private String m_arch;

    public VersionInfo(InputStream is) throws IOException {
        this.reload(new InputStreamReader(is));
    }

    VersionInfo(String path) {
        this.m_file = new File(path, VERSION_FILE);
        try {
            this.reload();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void reload(Reader reader) throws IOException {
        BufferedReader br = new BufferedReader(reader);
        try {
            this.m_version = br.readLine();
            this.m_os = br.readLine();
            this.m_keyID = br.readLine();
            this.m_arch = br.readLine();
        }
        finally {
            IOUtil.close(br);
        }
    }

    public void reload() throws IOException {
        if (this.m_file != null && this.m_file.isFile()) {
            this.reload(new FileReader(this.m_file));
        }
    }

    public String getVersion() {
        return this.m_version;
    }

    public String getOS() {
        return this.m_os;
    }

    public String getKeyID() {
        return this.m_keyID;
    }

    public String getArchitecture() {
        return this.m_arch;
    }
}

