/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.model;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class StringPattern {
    private static final String NAME_ANY = "[^!/]*";
    private static final String PATH_ANY = "([^!].*).*$";
    private static final String SLASH = "/";
    private static final String BEGIN = "^.*";
    private static final String END = "$";
    private String m_str;
    private Pattern m_pattern;
    private static final Map<String, String> substitutionMap = new HashMap<String, String>();

    private static void initSubMap() {
        substitutionMap.put("\\.", "\\\\.");
        substitutionMap.put("\\$", "\\\\\\$");
        substitutionMap.put("\\(", "\\\\(");
        substitutionMap.put("\\)", "\\\\)");
        substitutionMap.put("\\\\", SLASH);
        substitutionMap.put("\\+", "\\\\+");
        substitutionMap.put("\\{", "\\\\{");
        substitutionMap.put("\\}", "\\\\}");
        substitutionMap.put("\\[", "\\\\[");
        substitutionMap.put("\\]", "\\\\]");
        substitutionMap.put("\\?", "\\\\?");
        substitutionMap.put("\\^", "\\\\^");
    }

    public StringPattern(String str) {
        this.m_str = str;
        for (Map.Entry<String, String> entry : substitutionMap.entrySet()) {
            str = str.replaceAll(entry.getKey(), entry.getValue());
        }
        if ((str = str.replaceAll("\\*", NAME_ANY)).endsWith(SLASH)) {
            str = str + PATH_ANY;
        }
        this.m_pattern = Pattern.compile(BEGIN + str + END);
    }

    private String replaceSeparators(String str) {
        return str.replaceAll("\\\\", SLASH);
    }

    public boolean matches(String str) {
        return this.m_pattern.matcher(this.replaceSeparators(str)).matches();
    }

    public String toString() {
        return this.m_str;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof StringPattern) {
            return this.m_str.equals(((StringPattern)o).m_str);
        }
        return false;
    }

    public int hashCode() {
        return this.m_str.hashCode();
    }

    static {
        StringPattern.initSubMap();
    }
}

