/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.model.xml;

import com.ibm.appscan.common.utils.FileUtil;
import com.ibm.appscan.common.utils.PathUtil;
import com.ibm.appscan.common.xml.DOMWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;

public class IrsWriter {
    public void write(File dir) throws IOException, ParserConfigurationException, TransformerException {
        List<File> ipvaFiles;
        File irsFile = new File(dir, ".irs");
        if (irsFile.isFile()) {
            irsFile.delete();
        }
        if ((ipvaFiles = this.getIpvaFiles(dir)).size() > 0) {
            DocumentBuilder builder = this.getDocumentBuilder();
            Transformer transformer = this.getTransformer();
            DOMWriter out = new DOMWriter(irsFile, builder);
            out.beginElement("IRFiles");
            for (File ipvaFile : ipvaFiles) {
                File relativeFile = PathUtil.makeRelative(dir, dir, ipvaFile);
                out.beginElement("IRFile");
                out.setAttribute("format_type", "xml");
                out.setAttribute("ipva_file", relativeFile.getPath());
                out.setAttribute("metrics_file", ".\\" + FileUtil.getBaseName(new File(FileUtil.getBaseName(ipvaFile))) + ".stats");
                out.endElement();
            }
            out.endElement();
            out.write(transformer);
        }
    }

    private List<File> getIpvaFiles(File directory) throws IOException {
        final ArrayList<File> theFiles = new ArrayList<File>();
        Files.walkFileTree(directory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                File file = path.toFile();
                if (file.isFile() && file.getName().toLowerCase().endsWith(".ipva.xml") && !file.getAbsolutePath().contains(File.separator + "slices" + File.separator)) {
                    theFiles.add(path.toFile());
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
        return theFiles;
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        return factory.newDocumentBuilder();
    }

    private Transformer getTransformer() throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        return transformer;
    }
}

