/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.utils;

import com.ibm.appscan.common.Messages;
import com.ibm.security.annotation.SuppressSecurityTrace;
import com.ibm.security.annotation.ValidatorMethod;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;

public class PathUtil {
    private static String addTrailingSeparator(String path) {
        return path.endsWith(File.separator) ? path : path + File.separator;
    }

    private static String[] checkIsParent(File f1, File f2) {
        try {
            String p1 = PathUtil.addTrailingSeparator(f1.getCanonicalPath());
            String p2 = PathUtil.addTrailingSeparator(f2.getCanonicalPath());
            if (p2.startsWith(p1)) {
                return new String[]{p1, p2};
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @ValidatorMethod
    public static File getSanitizedFile(String parentDir, String fileName) throws IOException {
        File ret = new File(parentDir, fileName);
        if (!PathUtil.isParent(new File(parentDir), ret)) {
            throw new IOException(Messages.getMessage("err.file.name.invalid", fileName, parentDir));
        }
        return ret;
    }

    @ValidatorMethod
    public static boolean isParent(File f1, File f2) {
        return PathUtil.checkIsParent(f1, f2) != null;
    }

    public static File makeRelative(File parent, File current, File file) {
        if (parent != null && PathUtil.isParent(parent, file)) {
            File prefix = null;
            String[] paths = null;
            while (current != null && (paths = PathUtil.checkIsParent(current, file)) == null) {
                current = current.getParentFile();
                prefix = new File(prefix, "..");
            }
            if (current != null) {
                return new File(prefix, paths[1].substring(paths[0].length()));
            }
        }
        return file;
    }

    public static String makeRelative(File parent, File current, String path) {
        return PathUtil.makeRelative(parent, current, new File(path)).getPath();
    }

    @SuppressSecurityTrace
    public static String makeAbsolute(String relPath, String relativeTo) {
        File file = new File(relPath);
        if (file.isAbsolute() || relativeTo == null) {
            return relPath;
        }
        String path = relativeTo;
        if (!".".equals(relPath)) {
            path = path + File.separator + relPath;
        }
        return path;
    }

    public static Path commonPath(Path path0, Path path1) {
        int minCount;
        if (path0.equals(path1)) {
            return path0;
        }
        path0 = path0.normalize();
        path1 = path1.normalize();
        for (int i = minCount = Math.min(path0.getNameCount(), path1.getNameCount()); i > 0; --i) {
            Path sp0 = path0.subpath(0, i);
            if (!sp0.equals(path1.subpath(0, i))) continue;
            String root = Objects.toString(path0.getRoot(), "");
            return Paths.get(root, sp0.toString());
        }
        return path0.getRoot();
    }

    public static String replaceBackslashes(String path) {
        return path.replaceAll("\\\\", "/");
    }
}

