/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.cloud.commands;

import com.ibm.appscan.cli.cloud.Messages;
import com.ibm.appscan.cli.cloud.handlers.CancelHandler;
import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.components.Command;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class CancelCommand
extends Command {
    private CancelHandler m_handler = new CancelHandler();

    public CancelCommand() {
    }

    public CancelCommand(String[] args) {
        super(args);
    }

    public void configure() {
        this.setNamespace(Messages.getMessage("command.analyze.namespace", new Object[0]));
        this.setName("cancel");
        this.setDescription(Messages.getMessage("command.cancel.description", new Object[0]));
        this.setOptions(this.buildOptions(), false);
    }

    public Command createCommand(String[] args) {
        return new CancelCommand(args);
    }

    public void execute() {
        CommandLine cmd = this.getCommandLine();
        if (cmd == null) {
            return;
        }
        String scanId = null;
        if (cmd.hasOption("i")) {
            scanId = cmd.getOptionValue("i");
        }
        try {
            this.m_handler.cancel(scanId);
        }
        catch (AppScanException e) {
            CommonCLICore.getLogManager().log(new Message((Throwable)e));
            CommonCLICore.getIOConsole().println(new Message((Throwable)e));
        }
    }

    protected Options buildOptions() {
        Options options = new Options();
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)Messages.getMessage("option.jobid.argument", new Object[0]));
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)Messages.getMessage("option.jobid.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"i"));
        return options;
    }
}

