/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.cloud.handlers;

import com.ibm.appscan.cli.cloud.Messages;
import com.ibm.appscan.cli.cloud.handlers.SAHandler;
import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import java.io.IOException;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONArtifact;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class ListHandler
extends SAHandler {
    private IProgress m_progress = new ProgressAdapter();

    public void list() {
        try {
            if (this.isTokenExpired()) {
                this.m_progress.setStatus(new Message(4, com.ibm.appscan.cli.cloud.auth.Messages.getMessage((String)"login.token.expired", (Object[])new Object[0])));
                return;
            }
            JSONArtifact content = this.getScanList();
            if (content != null) {
                this.parseJSONArtifact(content);
            }
        }
        catch (JSONException e) {
            this.m_progress.setStatus(new Message((Throwable)e));
        }
        catch (IOException e) {
            this.m_progress.setStatus(new Message((Throwable)e));
        }
    }

    private void parseJSONArtifact(JSONArtifact artifact) throws IOException {
        try {
            if (artifact instanceof JSONObject) {
                JSONObject responseObject = (JSONObject)artifact;
                if (responseObject.has("Items")) {
                    this.parseJobs(responseObject.getJSONArray("Items"));
                } else if (responseObject.has("Message")) {
                    this.getProgressAdapter().setStatus(new Message(4, responseObject.getString("Message")));
                }
            }
        }
        catch (JSONException e) {
            this.getProgressAdapter().setStatus(new Message((Throwable)e));
        }
    }

    private void parseJobs(JSONArray jobList) throws JSONException {
        if (jobList.size() < 1) {
            CommonCLICore.getIOConsole().println(Messages.getMessage("err.jobs.none", new Object[0]));
        } else {
            for (int i = 0; i < jobList.size(); ++i) {
                JSONObject job = (JSONObject)jobList.get(i);
                CommonCLICore.getIOConsole().println(job.getString("Id"));
            }
        }
    }
}

