/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.source.scanner.utils;

import com.hcl.appscan.source.scanner.logging.SourceCodeScannerException;
import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.ProcessRunner;
import com.ibm.appscan.common.utils.SystemUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AzcopyRunner {
    public static int run(List<String> commandArgs, final ILogManager logger) throws SourceCodeScannerException {
        List<String> args = AzcopyRunner.getOsCommandArgs();
        StringBuffer command = new StringBuffer();
        command.append("azcopy");
        for (String arg : commandArgs) {
            command.append(" ").append(arg);
        }
        args.add(command.toString());
        if (SystemUtil.isDevDebug()) {
            System.out.println(args.toString());
        }
        try {
            ProcessRunner.StreamHandler out = new ProcessRunner.StreamHandler(){

                protected void handle(String line) {
                    logger.log(new Message(1, line));
                }
            };
            ProcessRunner.StreamHandler error = new ProcessRunner.StreamHandler(){

                protected void handle(String line) {
                    logger.log(new Message(4, line));
                }
            };
            ProcessRunner runner = new ProcessRunner(false, args);
            logger.log(new Message(1, runner.getCommandArgs()));
            return runner.exec(out, error);
        }
        catch (IOException | InterruptedException e) {
            throw new SourceCodeScannerException(e, false);
        }
    }

    private static List<String> getOsCommandArgs() {
        ArrayList<String> args = new ArrayList<String>();
        if (SystemUtil.isWindows()) {
            args.add("cmd");
            args.add("/c");
        } else {
            args.add("/bin/sh");
            args.add("-c");
        }
        return args;
    }
}

