/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.jsf2;

import com.ibm.appscan.frameworks.handlers.jsf2.WebXmlParser;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class JsfConfigurationManager {
    private File m_webXmlFile;
    private File m_webContentDirectory;
    private List<String> m_facesConfigFiles = new ArrayList<String>();
    private List<String> m_viewFiles = new ArrayList<String>();
    private List<String> m_jsfViewFileExtensions = new ArrayList<String>();

    public JsfConfigurationManager(File webContentDirectory) {
        this.m_webContentDirectory = webContentDirectory;
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.handler.searching", (Object[])new Object[]{"web.xml", this.m_webContentDirectory.getAbsolutePath()}));
        Iterator iter = FileUtils.iterateFiles((File)webContentDirectory, (IOFileFilter)new NameFileFilter("web.xml"), (IOFileFilter)TrueFileFilter.INSTANCE);
        if (iter.hasNext()) {
            this.m_webXmlFile = (File)iter.next();
        }
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.examine", (Object[])new Object[]{this.m_webXmlFile.getAbsolutePath()}));
    }

    public List<String> getViewFiles() {
        return this.m_viewFiles;
    }

    public List<String> getFacesConfigFiles() {
        return this.m_facesConfigFiles;
    }

    public void setJsfConfiguration() {
        try {
            WebXmlParser webXmlParser = new WebXmlParser(this.m_webXmlFile.getCanonicalPath(), this.m_webContentDirectory.getCanonicalPath());
            this.m_facesConfigFiles = webXmlParser.getConfigFileList();
            if (this.m_facesConfigFiles.size() == 0) {
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.handler.searching", (Object[])new Object[]{"faces-config.xml", this.m_webContentDirectory.getAbsolutePath()}));
                String defaultFacesConfigFileName = null;
                Iterator iter = FileUtils.iterateFiles((File)this.m_webContentDirectory, (IOFileFilter)new NameFileFilter("faces-config.xml"), (IOFileFilter)TrueFileFilter.INSTANCE);
                if (iter.hasNext()) {
                    File xmlFile = (File)iter.next();
                    defaultFacesConfigFileName = xmlFile.getCanonicalPath();
                }
                if (defaultFacesConfigFileName != null) {
                    this.m_facesConfigFiles.add(defaultFacesConfigFileName);
                } else {
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.missing.in", (Object[])new Object[]{"config_files", "web.xml"}));
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.missing.in", (Object[])new Object[]{"faces-config.xml", this.m_webContentDirectory.getAbsolutePath()}));
                }
            }
            this.m_jsfViewFileExtensions = webXmlParser.getJsfViewFileExtensions();
            this.setViewFiles();
        }
        catch (Exception e) {
            System.out.println("Failure in setting JSF2 configurations: " + e.toString());
            TaintLogger.i().getLogger().warn((Object)("Failure in setting JSF2 configurations: " + this.m_webXmlFile), (Throwable)e);
        }
    }

    private void setViewFiles() {
        StringBuilder fileRegx = new StringBuilder();
        try {
            for (String fileExtension : this.m_jsfViewFileExtensions) {
                if (fileRegx.length() == 0) {
                    fileRegx.append(".*\\" + fileExtension);
                    continue;
                }
                fileRegx.append("|");
                fileRegx.append(".*\\" + fileExtension);
            }
            Pattern filePattern = Pattern.compile(fileRegx.toString());
            RegexFileFilter fileFilter = new RegexFileFilter(filePattern);
            Iterator iter = FileUtils.iterateFiles((File)this.m_webContentDirectory, (IOFileFilter)fileFilter, (IOFileFilter)TrueFileFilter.INSTANCE);
            while (iter.hasNext()) {
                File currentFile = (File)iter.next();
                System.out.println("JSF view file: " + currentFile.toString());
                this.m_viewFiles.add(currentFile.getCanonicalPath());
            }
        }
        catch (Exception e) {
            System.out.println("here was an exception while setting view files: " + e.toString());
            TaintLogger.i().getLogger().warn((Object)("Exception while collecting JSF view files from the application. WebContentDirectory = " + this.m_webContentDirectory + "; the regular expression of fileFilter isfileFilterRegularExpression = " + fileRegx + "; the URL pattern defined in this applications are '" + this.m_jsfViewFileExtensions.toString() + "'  "), (Throwable)e);
        }
    }
}

