/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.javaee.jsp;

import com.ibm.appscan.frameworks.analyzers.javaee.BeanScope;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.ElAccess;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.UnhandledELException;
import com.ibm.appscan.frameworks.specinfo.BeanDecl;
import com.ibm.appscan.frameworks.specinfo.GlobalRefExpr;
import com.ibm.appscan.frameworks.specinfo.NonDetSelectionExpr;
import com.ibm.appscan.frameworks.specinfo.NonVoidSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.ObjectRefExpr;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.HashSet;
import java.util.Set;

public class BeanDirectAccess
extends ElAccess {
    private String beanName;
    private Set<BeanScope> beanScopes = HashSetFactory.make();

    public BeanDirectAccess(String beanName, IMethod jspEvaluateCall, CallSiteReference callSiteReference, int srcLine) throws UnhandledELException {
        super(jspEvaluateCall, callSiteReference, srcLine);
        this.beanName = beanName;
        this.beanScopes.add(BeanScope.Request);
        this.beanScopes.add(BeanScope.Session);
    }

    @Override
    public Set<BeanDecl> getGlobalBeanDecls() {
        HashSet result = HashSetFactory.make();
        for (BeanScope beanScope : this.beanScopes) {
            result.add(BeanDecl.makeWithConcreteType((String)(beanScope.toString() + "." + this.beanName), (String)"java.lang.Object", (BeanDecl.BeanLifespan)beanScope.getLifeSpan()));
        }
        return result;
    }

    @Override
    public NonVoidSyntheticExpr getSyntheticExpr() {
        NonVoidSyntheticExpr expr;
        if (this.beanScopes.size() == 1) {
            expr = GlobalRefExpr.make((String)(this.beanScopes.iterator().next().toString() + "." + this.beanName));
        } else {
            HashSet globalRefs = HashSetFactory.make();
            for (BeanScope beanScope : this.beanScopes) {
                globalRefs.add(GlobalRefExpr.make((String)(beanScope.toString() + "." + this.beanName)));
            }
            expr = NonDetSelectionExpr.make((Set)globalRefs);
        }
        return ObjectRefExpr.make((NonVoidSyntheticExpr)expr, (String)"");
    }
}

