/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.struts1;

import com.ibm.appscan.frameworks.analyzers.javaee.BeanUtil;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.IJSPPrecompilerInfo;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.JspEntrypointResolver;
import com.ibm.appscan.frameworks.analyzers.struts1.AnalyzedBean;
import com.ibm.appscan.frameworks.analyzers.struts1.StrutsCodeAnalyzer;
import com.ibm.appscan.frameworks.analyzers.struts1.StrutsEntrypointUtil;
import com.ibm.appscan.frameworks.analyzers.struts1.StrutsForwardAnalyzer;
import com.ibm.appscan.frameworks.analyzers.struts1.StrutsForwardUtil;
import com.ibm.appscan.frameworks.analyzers.tiles.TilesAnalyzer;
import com.ibm.appscan.frameworks.parsers.strutsParser.IAction;
import com.ibm.appscan.frameworks.parsers.strutsParser.IForward;
import com.ibm.appscan.frameworks.parsers.strutsValidatorParser.IValidator;
import com.ibm.appscan.frameworks.specinfo.AssignableSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.AssignmentExpr;
import com.ibm.appscan.frameworks.specinfo.BeanDecl;
import com.ibm.appscan.frameworks.specinfo.FormalParameterExpr;
import com.ibm.appscan.frameworks.specinfo.GlobalRefExpr;
import com.ibm.appscan.frameworks.specinfo.ISyntheticMethod;
import com.ibm.appscan.frameworks.specinfo.LocalRefExpr;
import com.ibm.appscan.frameworks.specinfo.NonVoidSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.ObjectRefExpr;
import com.ibm.appscan.frameworks.specinfo.Property;
import com.ibm.appscan.frameworks.specinfo.SyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.SyntheticMethodImpl;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.frameworks.util.WalaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AnalyzedStrutsAction {
    private static final Logger logger = TaintLogger.i().getLogger();
    private Collection<String> forwardPaths;
    private final String actionClass;
    private final IAction action;
    private final Map<String, IForward> localForwards = HashMapFactory.make();
    private final String scope;
    private final String name;
    private final String path;
    private final String parameter;
    private final StrutsCodeAnalyzer codeAnalyzer;
    private boolean valid = true;
    private final JspEntrypointResolver resolver;
    private AnalyzedBean bean;

    public AnalyzedStrutsAction(IAction action, Map<String, AnalyzedBean> beans, Map<String, IForward> globalForwards, StrutsCodeAnalyzer codeAnalyzer, IJSPPrecompilerInfo jspInfo, String webContentDir) {
        this.action = action;
        this.codeAnalyzer = codeAnalyzer;
        this.bean = this.getBean(beans);
        for (IForward forward : action.getForward()) {
            this.localForwards.put(forward.getName(), forward);
        }
        String actionScope = action.getScope();
        this.scope = actionScope == null ? "session" : actionScope;
        this.name = action.getName();
        this.actionClass = action.getType();
        this.path = action.getPath();
        this.parameter = action.getParameter();
        this.forwardPaths = this.getForwardPaths(globalForwards);
        this.resolver = JspEntrypointResolver.make(jspInfo, webContentDir);
    }

    private AnalyzedBean getBean(Map<String, AnalyzedBean> beans) {
        if (this.action.getName() == null) {
            return null;
        }
        AnalyzedBean theBean = beans.get(this.action.getName());
        if (theBean == null) {
            logger.warn((Object)("Can't find named bean in configuration file " + this.action.getName()));
            return null;
        }
        return theBean;
    }

    private Collection<String> getForwardPaths(Map<String, IForward> globalForwards) {
        HashSet result = HashSetFactory.make();
        if (this.actionClass == null) {
            if (this.action.getForwardAttr() != null) {
                result.add(this.action.getForwardAttr());
            }
            return result;
        }
        if (this.action.getType() != null && this.action.getType().equals("org.apache.struts.actions.ForwardAction")) {
            if (this.action.getParameter() == null) {
                this.valid = false;
                logger.warn((Object)"Struts ForwardAction with no parameter");
            } else {
                result.add(this.action.getParameter());
            }
            return result;
        }
        Collection<StrutsForwardAnalyzer.ForwardInfo> allPossibleForwards = this.codeAnalyzer.getPossibleForwards(this.actionClass);
        for (StrutsForwardAnalyzer.ForwardInfo possibleForwards : allPossibleForwards) {
            for (String forwardName : possibleForwards.getForwardNames()) {
                IForward forward = null;
                if (this.localForwards.containsKey(forwardName)) {
                    forward = this.localForwards.get(forwardName);
                } else if (globalForwards.containsKey(forwardName)) {
                    forward = globalForwards.get(forwardName);
                } else {
                    logger.warn((Object)("Can't find forward in configuration file " + forwardName));
                    continue;
                }
                String redirect = forward.getRedirect();
                if (redirect != null && Boolean.parseBoolean(redirect)) continue;
                result.add(forward.getPath());
            }
            for (String url : possibleForwards.getUrls()) {
                result.add(url);
            }
        }
        return result;
    }

    public String getPath() {
        return this.path;
    }

    public String getParameter() {
        return this.parameter;
    }

    public Collection<String> getForwardPaths(Collection<AnalyzedStrutsAction> allActions) {
        ArrayList<String> result = new ArrayList<String>();
        for (String forwardPath : this.forwardPaths) {
            result.add(StrutsForwardUtil.findTrueForwardPath(forwardPath, allActions));
        }
        return result;
    }

    public String getActionClass() {
        return this.actionClass;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Action Class= " + this.actionClass + "\n");
        if (this.bean != null) {
            sb.append(this.bean.toString() + "\n");
        }
        sb.append("Forward Paths=");
        for (String forward : this.forwardPaths) {
            sb.append(forward + ",");
        }
        sb.append("\n");
        return sb.toString();
    }

    public boolean isValid() {
        return this.valid;
    }

    public Pair<ISyntheticMethod, BeanDecl> createSyntheticMethod(Collection<AnalyzedStrutsAction> allActions, IClassHierarchy cha) {
        boolean instantiateBean;
        if (!this.valid) {
            throw new IllegalStateException("attempting to creating synthetic method for invalid action");
        }
        if (this.actionClass == null) {
            throw new IllegalStateException("attempting to create synthetic method for action with no class");
        }
        IClass actionKlass = cha.lookupClass(WalaUtil.createTypeRefForJavaClassName(this.actionClass));
        if (actionKlass == null) {
            logger.debug((Object)("could not find Struts action class " + actionKlass));
            return null;
        }
        String methodSig = VDBJavaUtil.jvmToVDBSignature("AppScan.Synthetic.Struts1." + this.path.substring(1).replace('/', '_').replace("-", "_") + "_entry(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V");
        logger.info((Object)Messages.getString("framework.begin.syntheticmethod", methodSig));
        BeanDecl localBean = null;
        BeanDecl globalBean = null;
        ArrayList<SyntheticExpr> statements = new ArrayList<SyntheticExpr>();
        String beanLocalName = "theBean";
        boolean bl = instantiateBean = this.name != null && this.bean != null;
        if (instantiateBean) {
            String beanClass = this.bean.getBeanClass();
            IClass beanKlass = cha.lookupClass(WalaUtil.createTypeRefForJavaClassName(beanClass));
            boolean bl2 = instantiateBean = beanKlass != null;
        }
        if (instantiateBean) {
            ArrayList<Property> properties = new ArrayList<Property>();
            if (this.bean.isDynaBean()) {
                for (Property beanProp : this.bean.getBeanProperties()) {
                    properties.add(beanProp);
                }
            }
            if (this.bean.isDynaBean()) {
                localBean = BeanDecl.makeWithProperties((String)"theBean", (BeanDecl.BeanLifespan)BeanDecl.BeanLifespan.LOCAL, properties, (String)this.bean.getBeanClass());
            } else {
                String beanClassName = this.bean.getBeanClass();
                localBean = BeanDecl.makeWithConcreteType((String)"theBean", (String)beanClassName, (BeanDecl.BeanLifespan)BeanDecl.BeanLifespan.LOCAL);
            }
            statements.addAll(BeanUtil.taintBeanProperties(this.bean.getBeanClass(), this.bean.isDynaBean(), "theBean", this.action.getFilePositionInfo(), this.bean.getBeanProperties()));
            String heapName = AnalyzedStrutsAction.getGlobalBeanNameForAction(this.scope, this.name);
            ObjectRefExpr beanRef = ObjectRefExpr.make((NonVoidSyntheticExpr)GlobalRefExpr.make((String)heapName), (String)"");
            ObjectRefExpr l = ObjectRefExpr.make((NonVoidSyntheticExpr)LocalRefExpr.make((String)"theBean"), (String)"");
            statements.add((SyntheticExpr)AssignmentExpr.make((FilePositionInfo)this.action.getFilePositionInfo(), (AssignableSyntheticExpr)beanRef, (NonVoidSyntheticExpr)l));
            globalBean = localBean.getType() != null ? BeanDecl.makeWithConcreteType((String)heapName, (String)localBean.getType(), (BeanDecl.BeanLifespan)(this.scope.equals("request") ? BeanDecl.BeanLifespan.ENTRYPOINT : BeanDecl.BeanLifespan.GLOBAL)) : BeanDecl.makeWithProperties((String)heapName, (BeanDecl.BeanLifespan)(this.scope.equals("request") ? BeanDecl.BeanLifespan.ENTRYPOINT : BeanDecl.BeanLifespan.GLOBAL), (Collection)localBean.getProperties(), (String)localBean.getDynaBeanSupertypeName());
            statements.addAll(this.getValidatorSignatures("theBean"));
        }
        Set<String> calleeSignatures = StrutsEntrypointUtil.getActionEntrypointSignatures(actionKlass);
        for (String calleeSignature : calleeSignatures) {
            HashMap actualParameterPos2Value = HashMapFactory.make();
            if (instantiateBean) {
                actualParameterPos2Value.put(2, ObjectRefExpr.make((NonVoidSyntheticExpr)LocalRefExpr.make((String)"theBean"), (String)""));
            }
            actualParameterPos2Value.put(3, ObjectRefExpr.make((NonVoidSyntheticExpr)FormalParameterExpr.make((int)0), (String)""));
            actualParameterPos2Value.put(4, ObjectRefExpr.make((NonVoidSyntheticExpr)FormalParameterExpr.make((int)1), (String)""));
            logger.info((Object)Messages.getString("framework.generate.call", calleeSignature));
            statements.add((SyntheticExpr)VDBJavaUtil.invokeFromJVMSig(this.action.getFilePositionInfo(), calleeSignature, actualParameterPos2Value));
        }
        for (String forwardPath : this.forwardPaths) {
            StrutsForwardUtil.addInvokeForForwardPath(allActions, cha, statements, forwardPath, this.resolver, this.action.getFilePositionInfo(), 0, 1);
        }
        logger.info((Object)Messages.getString("framework.generate.syntheticmethod", methodSig));
        return Pair.make((Object)new SyntheticMethodImpl(methodSig, localBean == null ? Collections.emptySet() : Collections.singleton(localBean), statements), globalBean);
    }

    private Collection<SyntheticExpr> getValidatorSignatures(String beanLocalName) {
        HashSet statements = HashSetFactory.make();
        for (IValidator validator : this.bean.getValidators()) {
            HashMap actualParameterPos2Value = HashMapFactory.make();
            actualParameterPos2Value.put(0, ObjectRefExpr.make((NonVoidSyntheticExpr)LocalRefExpr.make((String)beanLocalName), (String)""));
            actualParameterPos2Value.put(validator.getRequestParamPosition(), ObjectRefExpr.make((NonVoidSyntheticExpr)FormalParameterExpr.make((int)0), (String)""));
            logger.info((Object)Messages.getString("framework.generate.call", validator.getResolvedMethodReference(null).getSignature()));
            statements.add(VDBJavaUtil.invokeFromJVMSig(validator.getFilePositionInfo(), validator.getResolvedMethodReference(null).getSignature(), actualParameterPos2Value));
        }
        return statements;
    }

    public static String getGlobalBeanNameForAction(String beanScope, String beanName) {
        return beanScope + '.' + beanName;
    }

    public void updateForwardWithTiles(TilesAnalyzer strutsTilesAnalyzer) {
        if (strutsTilesAnalyzer == null) {
            return;
        }
        ArrayList<String> newForwardPaths = new ArrayList<String>();
        for (String forwardPath : this.forwardPaths) {
            Collection<String> allRelevantPaths = strutsTilesAnalyzer.getAllRelevantPaths(forwardPath);
            if (allRelevantPaths != null) {
                newForwardPaths.addAll(allRelevantPaths);
                continue;
            }
            newForwardPaths.add(forwardPath);
        }
        this.forwardPaths = newForwardPaths;
    }

    public String getScope() {
        return this.scope;
    }

    public String getName() {
        return this.name;
    }

    public AnalyzedBean getBean() {
        return this.bean;
    }
}

