/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.struts1;

import com.ibm.appscan.frameworks.analyzers.generic.CodeProcessor;
import com.ibm.appscan.frameworks.analyzers.generic.StringConstantFlow;
import com.ibm.appscan.frameworks.analyzers.struts1.AbstractStrutsCodeVisitor;
import com.ibm.appscan.frameworks.analyzers.struts1.StrutsEntrypointUtil;
import com.ibm.appscan.frameworks.util.WalaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.strings.StringStuff;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class StrutsForwardAnalyzer
extends AbstractStrutsCodeVisitor {
    private final Map<MethodReference, ForwardInfo> method2ForwardInfo = HashMapFactory.make();

    public static StrutsForwardAnalyzer make(IClassHierarchy cha, Set<String> actionClassNames, Set<String> exceptionHandlerClassNames) {
        return new StrutsForwardAnalyzer(cha, actionClassNames, exceptionHandlerClassNames);
    }

    private StrutsForwardAnalyzer(IClassHierarchy cha, Set<String> actionClassNames, Set<String> exceptionHandlerClassNames) {
        super(cha, actionClassNames, exceptionHandlerClassNames);
    }

    public boolean accepts(IMethod m, CallSiteReference callSiteRef, CodeProcessor.ICallSiteInfo callInfo) {
        throw new UnsupportedOperationException();
    }

    public void visitCallSite(IMethod m, IR ir, DefUse du, TypeAbstraction[] types, CallSiteReference callSiteRef, SSAAbstractInvokeInstruction invoke, CodeProcessor.ICallSiteInfo callInfo) {
        throw new UnsupportedOperationException();
    }

    public void visitMethod(IMethod m, IR ir, DefUse du, TypeAbstraction[] type) {
        HashSet forwardNames = HashSetFactory.make();
        HashSet urls = HashSetFactory.make();
        Collection<SSAReturnInstruction> returnInstrs = this.getReturnInstrs(ir);
        for (SSAReturnInstruction returnInstr : returnInstrs) {
            int returnedVal = returnInstr.getUse(0);
            forwardNames.addAll(this.getForwardNamesForReturnedVal(returnedVal, ir, du));
            urls.addAll(this.getURLsForReturnedVal(returnedVal, ir, du));
        }
        this.method2ForwardInfo.put(m.getReference(), new ForwardInfo(forwardNames, urls));
    }

    public boolean visitsCallSites() {
        return false;
    }

    private Collection<SSAReturnInstruction> getReturnInstrs(IR ir) {
        return Iterator2Collection.toSet((Iterator)new FilterIterator(ir.iterateNormalInstructions(), (Predicate)new Predicate<SSAInstruction>(){

            public boolean test(SSAInstruction o) {
                return o instanceof SSAReturnInstruction;
            }
        }));
    }

    private Collection<String> getURLsForReturnedVal(int returnedVal, IR ir, DefUse du) {
        MethodReference setPathRef = WalaUtil.getResolvedMethodReference("org.apache.struts.action.ActionForward", "setPath(Ljava/lang/String;)V", this.cha);
        StringConstantFlow constantFlow = StringConstantFlow.makeIntraproc((IR)ir, (DefUse)du);
        HashSet result = HashSetFactory.make();
        for (CallSiteReference site : Iterator2Iterable.make((Iterator)ir.iterateCallSites())) {
            for (SSAAbstractInvokeInstruction invokeInstr : ir.getCalls(site)) {
                MethodReference resolvedRef;
                MethodReference declaredTarget = invokeInstr.getDeclaredTarget();
                IMethod method = this.cha.resolveMethod(declaredTarget);
                if (method == null || !(resolvedRef = method.getReference()).equals((Object)setPathRef) || invokeInstr.getReceiver() != returnedVal) continue;
                result.addAll(constantFlow.findIntraprocStringsFlowingToVar(invokeInstr.getUse(1)));
            }
        }
        return result;
    }

    private Collection<String> getForwardNamesForReturnedVal(int returnedVal, IR ir, DefUse du) {
        LinkedList<Integer> worklist = new LinkedList<Integer>();
        HashSet handled = HashSetFactory.make();
        HashSet result = HashSetFactory.make();
        MethodReference findMappingRef = WalaUtil.getResolvedMethodReference("org.apache.struts.action.ActionMapping", "findForward(Ljava/lang/String;)Lorg/apache/struts/action/ActionForward;", this.cha);
        worklist.add(returnedVal);
        handled.add(returnedVal);
        while (!worklist.isEmpty()) {
            SSAAbstractInvokeInstruction invoke;
            MethodReference declaredTarget;
            IMethod resolved;
            int curVal = (Integer)worklist.remove();
            SSAInstruction def = du.getDef(curVal);
            if (def instanceof SSANewInstruction) continue;
            if (def instanceof SSAPhiInstruction) {
                for (int i = 0; i < def.getNumberOfUses(); ++i) {
                    if (!handled.add(def.getUse(i))) continue;
                    worklist.add(def.getUse(i));
                }
                continue;
            }
            if (!(def instanceof SSAAbstractInvokeInstruction) || (resolved = this.cha.resolveMethod(declaredTarget = (invoke = (SSAAbstractInvokeInstruction)def).getDeclaredTarget())) == null || !resolved.getReference().equals((Object)findMappingRef)) continue;
            StringConstantFlow constantFlow = StringConstantFlow.makeIntraproc((IR)ir, (DefUse)du);
            result.addAll(constantFlow.findIntraprocStringsFlowingToVar(invoke.getUse(1)));
        }
        return result;
    }

    public Collection<ForwardInfo> getForwardInfoForClass(String className) {
        IClass klass = this.cha.lookupClass(WalaUtil.createTypeRefForJavaClassName(className));
        if (klass == null) {
            TaintLogger.i().getLogger().debug((Object)("could not resolve action class " + className + " when resolving forwards"));
            return Collections.emptySet();
        }
        Set<String> entrypointSignatures = StrutsEntrypointUtil.getStrutsEntrypointSigs(klass);
        HashSet result = HashSetFactory.make();
        for (String sig : entrypointSignatures) {
            ForwardInfo forwardInfo;
            MethodReference ref = StringStuff.makeMethodReference((String)sig);
            IMethod method = this.cha.resolveMethod(ref);
            if (method == null) {
                TaintLogger.i().getLogger().info((Object)("could not resolve method " + ref.getSignature() + " when trying to discover Struts forwards"));
            }
            if ((forwardInfo = this.method2ForwardInfo.get(method.getReference())) == null) continue;
            result.add(forwardInfo);
        }
        return result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.method2ForwardInfo == null ? 0 : this.method2ForwardInfo.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StrutsForwardAnalyzer other = (StrutsForwardAnalyzer)obj;
        return !(this.method2ForwardInfo == null ? other.method2ForwardInfo != null : !this.method2ForwardInfo.equals(other.method2ForwardInfo));
    }

    public static class ForwardInfo {
        private final Collection<String> forwardNames;
        private final Collection<String> urls;

        public ForwardInfo(Collection<String> forwardNames, Collection<String> urls) {
            this.forwardNames = forwardNames;
            this.urls = urls;
        }

        public Collection<String> getForwardNames() {
            return this.forwardNames;
        }

        public Collection<String> getUrls() {
            return this.urls;
        }

        public boolean isEmpty() {
            return this.forwardNames.isEmpty() && this.urls.isEmpty();
        }
    }
}

