/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.java;

import com.ibm.appscan.frameworks.FileLocations;
import com.ibm.appscan.frameworks.FrameworkInfoGenerator;
import com.ibm.appscan.frameworks.FrameworksInput;
import com.ibm.appscan.frameworks.analyzers.javaee.JavaEEOptions;
import com.ibm.appscan.frameworks.java.WAFLSpecGen;
import com.ibm.appscan.frameworks.specinfo.IFrameworkInfo;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.cha.IClassHierarchyDweller;
import com.ibm.wala.util.collections.Pair;
import java.io.IOException;
import java.util.Properties;
import org.xml.sax.SAXException;

public class JavaFrameworkInfoGenerator
implements FrameworkInfoGenerator,
IClassHierarchyDweller {
    private IClassHierarchy cha;

    public IFrameworkInfo generateFrameworkInfo(FrameworksInput input) throws ClassHierarchyException, IOException, SAXException {
        JavaFrameworkInfoGenerator.checkForRequiredOptions(input);
        FileLocations fileLocs = input.getFileLocs();
        Pair<IClassHierarchy, IFrameworkInfo> waflSpecAndCHAForJavaEEApp = WAFLSpecGen.makeWithDefaultHandlers().getWAFLSpecAndCHAForJavaEEApp(fileLocs.getScopeFileName(), fileLocs.getExclusionsFileName(), fileLocs.getWebContentDir(), input.getOptions());
        this.cha = (IClassHierarchy)waflSpecAndCHAForJavaEEApp.fst;
        return (IFrameworkInfo)waflSpecAndCHAForJavaEEApp.snd;
    }

    public static void checkForRequiredOptions(FrameworksInput input) throws IllegalStateException {
        Properties options = input.getOptions();
        for (JavaEEOptions option : JavaEEOptions.values()) {
            if (!option.isRequiredFromInput() || options.getProperty(option.getName()) != null) continue;
            TaintLogger.i().getLogger().fatal((Object)("input XML is missing the required option " + option.getName()));
            throw new IllegalStateException();
        }
        FileLocations fileLocs = input.getFileLocs();
        if (fileLocs.getWebContentDir() == null) {
            TaintLogger.i().getLogger().fatal((Object)"input XML is missing the web content directory");
            throw new IllegalStateException();
        }
    }

    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }
}

