/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph;

import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextItem;
import com.ibm.wala.ipa.callgraph.ContextKey;

public class DelegatingContext
implements Context {
    private final Context A;
    private final Context B;

    public DelegatingContext(Context A, Context B) {
        this.A = A;
        this.B = B;
        if (A == null) {
            throw new IllegalArgumentException("null A");
        }
        if (B == null) {
            throw new IllegalArgumentException("null B");
        }
    }

    @Override
    public ContextItem get(ContextKey name) {
        ContextItem result = this.A.get(name);
        if (result == null) {
            result = this.B.get(name);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.A.hashCode();
        result = 31 * result + this.B.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DelegatingContext other = (DelegatingContext)obj;
        if (!this.A.equals(other.A)) {
            return false;
        }
        return this.B.equals(other.B);
    }

    public String toString() {
        return "DelegatingContext [A=" + this.A + ", B=" + this.B + "]";
    }
}

