/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.ComposedIterator;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.MapIterator;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.functions.Function;
import java.util.Collection;
import java.util.Iterator;

public final class ConcreteTypeKey
implements InstanceKey {
    private final IClass type;

    public ConcreteTypeKey(IClass type) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (type.isInterface()) {
            Assertions.UNREACHABLE((String)("unexpected interface: " + type));
        }
        this.type = type;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConcreteTypeKey) {
            ConcreteTypeKey other = (ConcreteTypeKey)obj;
            return this.type.equals(other.type);
        }
        return false;
    }

    public int hashCode() {
        return 461 * this.type.hashCode();
    }

    public String toString() {
        return "[" + this.type + "]";
    }

    public IClass getType() {
        return this.type;
    }

    @Override
    public IClass getConcreteType() {
        return this.type;
    }

    public static InstanceKey[] getInstanceKeysForPEI(SSAInstruction pei, IR ir, IClassHierarchy cha) {
        if (pei == null) {
            throw new IllegalArgumentException("pei is null");
        }
        Collection<TypeReference> types = pei.getExceptionTypes();
        if (types == null) {
            return null;
        }
        InstanceKey[] result = new InstanceKey[types.size()];
        int i = 0;
        for (TypeReference type : types) {
            assert (type != null);
            IClass klass = cha.lookupClass(type);
            result[i++] = new ConcreteTypeKey(klass);
        }
        return result;
    }

    @Override
    public Iterator<Pair<CGNode, NewSiteReference>> getCreationSites(CallGraph CG) {
        return new ComposedIterator<CGNode, Pair<CGNode, NewSiteReference>>(CG.iterator()){

            public Iterator<? extends Pair<CGNode, NewSiteReference>> makeInner(final CGNode outer) {
                return new MapIterator((Iterator)new FilterIterator(outer.iterateNewSites(), (Predicate)new Predicate<NewSiteReference>(){

                    public boolean test(NewSiteReference o) {
                        return o.getDeclaredType().equals(ConcreteTypeKey.this.type.getReference());
                    }
                }), (Function)new Function<NewSiteReference, Pair<CGNode, NewSiteReference>>(){

                    public Pair<CGNode, NewSiteReference> apply(NewSiteReference object) {
                        return Pair.make((Object)outer, (Object)object);
                    }
                });
            }
        };
    }
}

