/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.ContextItem;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointsToSetVariable;
import com.ibm.wala.ipa.callgraph.propagation.PropagationSystem;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import java.util.Arrays;

public interface FilteredPointerKey
extends PointerKey {
    public TypeFilter getTypeFilter();

    public static class TargetMethodFilter
    implements TypeFilter {
        private final IMethod targetMethod;

        public TargetMethodFilter(IMethod targetMethod) {
            this.targetMethod = targetMethod;
        }

        public String toString() {
            return "TargetMethodFilter: " + this.targetMethod;
        }

        public IMethod getMethod() {
            return this.targetMethod;
        }

        public int hashCode() {
            return this.targetMethod.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof TargetMethodFilter && ((TargetMethodFilter)o).getMethod().equals(this.targetMethod);
        }

        @Override
        public boolean addFiltered(PropagationSystem system, PointsToSetVariable L, PointsToSetVariable R) {
            if (R.getValue() == null) {
                return false;
            }
            UpdateAction act = new UpdateAction(system, L, true);
            R.getValue().foreach((IntSetAction)act);
            return act.result;
        }

        @Override
        public boolean addInverseFiltered(PropagationSystem system, PointsToSetVariable L, PointsToSetVariable R) {
            if (R.getValue() == null) {
                return false;
            }
            UpdateAction act = new UpdateAction(system, L, false);
            R.getValue().foreach((IntSetAction)act);
            return act.result;
        }

        @Override
        public boolean isRootFilter() {
            return false;
        }

        private class UpdateAction
        implements IntSetAction {
            private boolean result = false;
            private final PointsToSetVariable L;
            private final PropagationSystem system;
            private final boolean sense;

            private UpdateAction(PropagationSystem system, PointsToSetVariable L, boolean sense) {
                this.L = L;
                this.sense = sense;
                this.system = system;
            }

            public void act(int i) {
                InstanceKey I = this.system.getInstanceKey(i);
                IClass C = I.getConcreteType();
                if (C.getMethod(TargetMethodFilter.this.targetMethod.getSelector()) == TargetMethodFilter.this.targetMethod == this.sense && !this.L.contains(i)) {
                    this.result = true;
                    this.L.add(i);
                }
            }
        }
    }

    public static class SingleInstanceFilter
    implements TypeFilter {
        private final InstanceKey concreteType;

        public SingleInstanceFilter(InstanceKey concreteType) {
            this.concreteType = concreteType;
        }

        public String toString() {
            return "SingleInstanceFilter: " + this.concreteType + " (" + this.concreteType.getClass() + ")";
        }

        public InstanceKey getInstance() {
            return this.concreteType;
        }

        public int hashCode() {
            return this.concreteType.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof SingleInstanceFilter && ((SingleInstanceFilter)o).getInstance().equals(this.concreteType);
        }

        @Override
        public boolean addFiltered(PropagationSystem system, PointsToSetVariable L, PointsToSetVariable R) {
            int idx = system.findOrCreateIndexForInstanceKey(this.concreteType);
            if (R.contains(idx) && !L.contains(idx)) {
                L.add(idx);
                return true;
            }
            return false;
        }

        @Override
        public boolean addInverseFiltered(PropagationSystem system, PointsToSetVariable L, PointsToSetVariable R) {
            int idx = system.findOrCreateIndexForInstanceKey(this.concreteType);
            if (!R.contains(idx) || L.contains(idx)) {
                return L.addAll(R);
            }
            MutableIntSet copy = IntSetUtil.makeMutableCopy((IntSet)R.getValue());
            copy.remove(idx);
            return L.addAll((IntSet)copy);
        }

        @Override
        public boolean isRootFilter() {
            return false;
        }
    }

    public static class MultipleClassesFilter
    implements TypeFilter {
        private final IClass[] concreteType;

        public MultipleClassesFilter(IClass[] concreteType) {
            this.concreteType = concreteType;
        }

        public String toString() {
            return "MultipleClassesFilter: " + Arrays.toString(this.concreteType);
        }

        public IClass[] getConcreteTypes() {
            return this.concreteType;
        }

        public int hashCode() {
            return this.concreteType[0].hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof MultipleClassesFilter)) {
                return false;
            }
            MultipleClassesFilter f = (MultipleClassesFilter)o;
            if (this.concreteType.length != f.concreteType.length) {
                return false;
            }
            for (int i = 0; i < this.concreteType.length; ++i) {
                if (this.concreteType[i].equals(f.concreteType[i])) continue;
                return false;
            }
            return true;
        }

        private IntSet bits(PropagationSystem system) {
            IntSet f = null;
            for (IClass cls : this.concreteType) {
                f = f == null ? system.getInstanceKeysForClass(cls) : f.union(system.getInstanceKeysForClass(cls));
            }
            return f;
        }

        @Override
        public boolean addFiltered(PropagationSystem system, PointsToSetVariable L, PointsToSetVariable R) {
            IntSet f = this.bits(system);
            return f == null ? false : L.addAllInIntersection(R, f);
        }

        @Override
        public boolean addInverseFiltered(PropagationSystem system, PointsToSetVariable L, PointsToSetVariable R) {
            IntSet f = this.bits(system);
            return f == null ? L.addAll(R) : L.addAll(IntSetUtil.diff((IntSet)R.getValue(), (IntSet)f));
        }

        @Override
        public boolean isRootFilter() {
            return this.concreteType.length == 1 && this.concreteType[0].getClassHierarchy().getRootClass().equals(this.concreteType[0]);
        }
    }

    public static class SingleClassFilter
    implements TypeFilter {
        private final IClass concreteType;

        public SingleClassFilter(IClass concreteType) {
            this.concreteType = concreteType;
        }

        public String toString() {
            return "SingleClassFilter: " + this.concreteType;
        }

        public IClass getConcreteType() {
            return this.concreteType;
        }

        public int hashCode() {
            return this.concreteType.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof SingleClassFilter && ((SingleClassFilter)o).getConcreteType().equals(this.concreteType);
        }

        @Override
        public boolean addFiltered(PropagationSystem system, PointsToSetVariable L, PointsToSetVariable R) {
            IntSet f = system.getInstanceKeysForClass(this.concreteType);
            return f == null ? false : L.addAllInIntersection(R, f);
        }

        @Override
        public boolean addInverseFiltered(PropagationSystem system, PointsToSetVariable L, PointsToSetVariable R) {
            IntSet f = system.getInstanceKeysForClass(this.concreteType);
            return f == null ? L.addAll(R) : L.addAll(IntSetUtil.diff((IntSet)R.getValue(), (IntSet)f));
        }

        @Override
        public boolean isRootFilter() {
            return this.concreteType.equals(this.concreteType.getClassHierarchy().getRootClass());
        }
    }

    public static interface TypeFilter
    extends ContextItem {
        public boolean addFiltered(PropagationSystem var1, PointsToSetVariable var2, PointsToSetVariable var3);

        public boolean addInverseFiltered(PropagationSystem var1, PointsToSetVariable var2, PointsToSetVariable var3);

        public boolean isRootFilter();
    }
}

