/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.cha;

import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.ClassLoaderFactory;
import com.ibm.wala.classLoader.ClassLoaderFactoryImpl;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.CancelCHAConstructionException;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.ClassHierarchyWarning;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.MapIterator;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.functions.Function;
import com.ibm.wala.util.ref.CacheReference;
import com.ibm.wala.util.ref.ReferenceCleanser;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ClassHierarchy
implements IClassHierarchy {
    private static final boolean DEBUG = false;
    private final Set<Language> languages = HashSetFactory.make();
    private final Map<TypeReference, Node> map = new ConcurrentHashMap<TypeReference, Node>();
    private TypeReference rootTypeRef;
    private Node root;
    private final ClassLoaderFactory factory;
    private final IClassLoader[] loaders;
    private final HashMap<IClass, Object> targetCache = HashMapFactory.make();
    private final AnalysisScope scope;
    private final Map<IClass, Set<IClass>> implementors = HashMapFactory.make();
    private Collection<IClass> subclassesOfError;
    private Collection<TypeReference> subTypeRefsOfError;
    private Collection<IClass> runtimeExceptionClasses;
    private Collection<TypeReference> runtimeExceptionTypeRefs;
    private int nextNumber = 1;
    private final Set<TypeReference> unresolved = HashSetFactory.make();

    private Set<IClass> computeSuperclasses(IClass klass) {
        HashSet result = HashSetFactory.make((int)3);
        klass = klass.getSuperclass();
        while (klass != null) {
            boolean added = result.add(klass);
            if (!added) {
                throw new IllegalStateException("cycle in the extends relation for class " + klass);
            }
            if ((klass = klass.getSuperclass()) == null || !klass.getReference().getName().equals(this.rootTypeRef.getName()) || klass.getReference().getClassLoader().equals(this.rootTypeRef.getClassLoader())) continue;
            throw new IllegalStateException("class " + klass + " is invalid, unexpected classloader");
        }
        return result;
    }

    private ClassHierarchy(AnalysisScope scope, ClassLoaderFactory factory, Language language, MonitorUtil.IProgressMonitor progressMonitor) throws ClassHierarchyException, IllegalArgumentException {
        this(scope, factory, Collections.singleton(language), progressMonitor);
    }

    private ClassHierarchy(AnalysisScope scope, ClassLoaderFactory factory, MonitorUtil.IProgressMonitor progressMonitor) throws ClassHierarchyException, IllegalArgumentException {
        this(scope, factory, scope.getLanguages(), progressMonitor);
    }

    /*
     * WARNING - void declaration
     */
    private ClassHierarchy(AnalysisScope scope, ClassLoaderFactory factory, Collection<Language> languages, MonitorUtil.IProgressMonitor progressMonitor) throws ClassHierarchyException, IllegalArgumentException {
        Warnings.clear();
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        if (scope.getLanguages().size() == 0) {
            throw new IllegalArgumentException("AnalysisScope must contain at least 1 language");
        }
        this.scope = scope;
        this.factory = factory;
        HashSet langNames = HashSetFactory.make();
        for (Language language : languages) {
            this.languages.add(language);
            this.languages.addAll(language.getDerivedLanguages());
            langNames.add(language.getName());
        }
        for (Language language : this.languages) {
            if (language.getRootType() == null || language.getRootType() == this.rootTypeRef) continue;
            if (this.rootTypeRef != null) {
                throw new IllegalArgumentException("AnalysisScope must have only 1 root type: " + language.getRootType() + ", " + this.rootTypeRef);
            }
            this.rootTypeRef = language.getRootType();
        }
        try {
            int numLoaders = 0;
            for (ClassLoaderReference ref : scope.getLoaders()) {
                if (!langNames.contains(ref.getLanguage())) continue;
                ++numLoaders;
            }
            this.loaders = new IClassLoader[numLoaders];
            boolean bl = false;
            if (progressMonitor != null) {
                progressMonitor.beginTask("Build Class Hierarchy", numLoaders * 2 - 1);
            }
            for (ClassLoaderReference ref : scope.getLoaders()) {
                void var7_14;
                if (progressMonitor != null && progressMonitor.isCanceled()) {
                    throw new CancelCHAConstructionException();
                }
                if (!langNames.contains(ref.getLanguage())) continue;
                IClassLoader icl = factory.getLoader(ref, this, scope);
                this.loaders[++var7_14] = icl;
                if (progressMonitor == null) continue;
                progressMonitor.worked((int)var7_14);
            }
            for (IClassLoader icl : this.loaders) {
                void var7_15;
                if (progressMonitor != null) {
                    progressMonitor.subTask("From " + icl.getName().toString());
                }
                this.addAllClasses(icl, progressMonitor);
                if (progressMonitor == null) continue;
                progressMonitor.worked((int)(++var7_15));
            }
        }
        catch (IOException e) {
            throw new ClassHierarchyException("factory.getLoader failed " + e);
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.done();
            }
        }
        if (this.root == null) {
            throw new ClassHierarchyException("failed to load root " + this.rootTypeRef + " of class hierarchy");
        }
        this.numberTree();
        ReferenceCleanser.registerClassHierarchy(this);
    }

    private void addAllClasses(IClassLoader loader, MonitorUtil.IProgressMonitor progressMonitor) throws CancelCHAConstructionException {
        HashSet toRemove = HashSetFactory.make();
        Iterator<IClass> it = loader.iterateAllClasses();
        while (it.hasNext()) {
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                throw new CancelCHAConstructionException();
            }
            IClass klass = it.next();
            boolean added = this.addClass(klass);
            if (added) continue;
            toRemove.add(klass);
        }
        loader.removeAll(toRemove);
    }

    @Override
    public boolean addClass(IClass klass) {
        Collection<IClass> loadedSuperInterfaces;
        Set<IClass> loadedSuperclasses;
        if (klass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        if (klass.getReference().getName().equals(this.rootTypeRef.getName()) && !klass.getReference().getClassLoader().equals(this.rootTypeRef.getClassLoader())) {
            throw new IllegalArgumentException("class " + klass + " is invalid, unexpected classloader");
        }
        try {
            loadedSuperclasses = this.computeSuperclasses(klass);
            loadedSuperInterfaces = klass.getAllImplementedInterfaces();
        }
        catch (Exception e) {
            if (klass instanceof ShrikeClass) {
                // empty if block
            }
            Warnings.add(ClassExclusion.create(klass.getReference(), e.getMessage()));
            return false;
        }
        Node node = this.findOrCreateNode(klass);
        if (klass.getReference().equals(this.rootTypeRef)) {
            assert (this.root == null);
            this.root = node;
        }
        HashSet workingSuperclasses = HashSetFactory.make(loadedSuperclasses);
        while (node != null) {
            IClass c = node.getJavaClass();
            IClass superclass = null;
            superclass = c.getSuperclass();
            if (superclass != null) {
                workingSuperclasses.remove(superclass);
                Node supernode = this.findOrCreateNode(superclass);
                if (node.getJavaClass() == supernode.getJavaClass() || superclass != supernode.getJavaClass()) {
                    return false;
                }
                supernode.addChild(node);
                if (supernode.getJavaClass().getReference().equals(this.rootTypeRef)) {
                    node = null;
                    continue;
                }
                node = supernode;
                continue;
            }
            node = null;
        }
        if (loadedSuperInterfaces != null) {
            for (final IClass iface : loadedSuperInterfaces) {
                try {
                    this.computeSuperclasses(iface);
                }
                catch (IllegalStateException e) {
                    Warnings.add(ClassExclusion.create(iface.getReference(), e.getMessage()));
                    continue;
                }
                if (!iface.isInterface()) {
                    Warnings.add(new Warning(){

                        @Override
                        public String getMsg() {
                            return "class implements non-interface " + iface.getReference() + " as an interface";
                        }
                    });
                    continue;
                }
                this.recordImplements(klass, iface);
            }
        }
        return true;
    }

    private void recordImplements(IClass klass, IClass iface) {
        Set impls = MapUtil.findOrCreateSet(this.implementors, (Object)iface);
        impls.add(klass);
    }

    @Override
    public Set<IMethod> getPossibleTargets(MethodReference ref) {
        IClassLoader loader;
        if (ref == null) {
            throw new IllegalArgumentException("ref is null");
        }
        try {
            loader = this.factory.getLoader(ref.getDeclaringClass().getClassLoader(), this, this.scope);
        }
        catch (IOException e) {
            throw new UnimplementedError("factory.getLoader failed " + e);
        }
        IClass declaredClass = loader.lookupClass(ref.getDeclaringClass().getName());
        if (declaredClass == null) {
            return Collections.emptySet();
        }
        HashSet targets = HashSetFactory.make();
        targets.addAll(this.findOrCreateTargetSet(declaredClass, ref));
        return targets;
    }

    private Set<IMethod> findOrCreateTargetSet(IClass declaredClass, MethodReference ref) {
        Set<IMethod> result;
        Map classCache = (Map)CacheReference.get(this.targetCache.get(declaredClass));
        if (classCache == null) {
            classCache = HashMapFactory.make((int)3);
            this.targetCache.put(declaredClass, CacheReference.make(classCache));
        }
        if ((result = (Set<IMethod>)classCache.get(ref)) == null) {
            result = this.getPossibleTargets(declaredClass, ref);
            classCache.put(ref, result);
        }
        return result;
    }

    @Override
    public Set<IMethod> getPossibleTargets(IClass declaredClass, MethodReference ref) {
        if (ref.getName().equals(MethodReference.initAtom)) {
            IMethod resolvedMethod = this.resolveMethod(ref);
            assert (resolvedMethod != null);
            return Collections.singleton(resolvedMethod);
        }
        if (declaredClass.isInterface()) {
            HashSet result = HashSetFactory.make((int)3);
            Set<IClass> impls = this.implementors.get(declaredClass);
            if (impls == null) {
                return Collections.emptySet();
            }
            for (IClass klass : impls) {
                if (klass.isInterface() || klass.isAbstract()) continue;
                result.addAll(this.computeTargetsNotInterface(ref, klass));
            }
            return result;
        }
        return this.computeTargetsNotInterface(ref, declaredClass);
    }

    private Set<IMethod> computeTargetsNotInterface(MethodReference ref, IClass klass) {
        Node n = this.findNode(klass);
        HashSet result = HashSetFactory.make((int)3);
        if (n == null) {
            return result;
        }
        Selector selector = ref.getSelector();
        IMethod resolved = this.resolveMethod(klass, selector);
        if (resolved != null) {
            result.add(resolved);
        }
        result.addAll(this.computeOverriders(n, selector));
        return result;
    }

    @Override
    public IMethod resolveMethod(MethodReference m) {
        if (m == null) {
            throw new IllegalArgumentException("m is null");
        }
        IClass receiver = this.lookupClass(m.getDeclaringClass());
        if (receiver == null) {
            return null;
        }
        Selector selector = m.getSelector();
        return this.resolveMethod(receiver, selector);
    }

    @Override
    public IField resolveField(FieldReference f) {
        if (f == null) {
            throw new IllegalArgumentException("f is null");
        }
        IClass klass = this.lookupClass(f.getDeclaringClass());
        if (klass == null) {
            return null;
        }
        return this.resolveField(klass, f);
    }

    @Override
    public IField resolveField(IClass klass, FieldReference f) {
        if (klass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        if (f == null) {
            throw new IllegalArgumentException("f is null");
        }
        return klass.getField(f.getName(), f.getFieldType().getName());
    }

    @Override
    public IMethod resolveMethod(IClass receiverClass, Selector selector) {
        if (receiverClass == null) {
            throw new IllegalArgumentException("receiverClass is null");
        }
        IMethod result = this.findMethod(receiverClass, selector);
        if (result != null) {
            return result;
        }
        IClass superclass = null;
        superclass = receiverClass.getSuperclass();
        if (superclass == null) {
            return null;
        }
        return this.resolveMethod(superclass, selector);
    }

    private IMethod findMethod(IClass clazz, Selector selector) {
        return clazz.getMethod(selector);
    }

    private Set<IMethod> computeOverriders(Node node, Selector selector) {
        HashSet result = HashSetFactory.make((int)3);
        Iterator<Node> it = node.getChildren();
        while (it.hasNext()) {
            Node child = it.next();
            IMethod m = this.findMethod(child.getJavaClass(), selector);
            if (m != null) {
                result.add(m);
            }
            result.addAll(this.computeOverriders(child, selector));
        }
        return result;
    }

    private Node findNode(IClass klass) {
        return this.map.get(klass.getReference());
    }

    private Node findOrCreateNode(IClass klass) {
        Node result = this.map.get(klass.getReference());
        if (result == null) {
            result = new Node(klass);
            this.map.put(klass.getReference(), result);
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(100);
        this.recursiveStringify(this.root, result);
        return result.toString();
    }

    private void recursiveStringify(Node n, StringBuffer buffer) {
        buffer.append(n.toString()).append("\n");
        Iterator<Node> it = n.getChildren();
        while (it.hasNext()) {
            Node child = it.next();
            this.recursiveStringify(child, buffer);
        }
    }

    private void numberTree() {
        assert (this.root != null);
        this.visitForNumbering(this.root);
    }

    private void visitForNumbering(Node N) {
        N.left = this.nextNumber++;
        for (Node C : N.children) {
            this.visitForNumbering(C);
        }
        N.right = this.nextNumber++;
    }

    @Override
    public ClassLoaderFactory getFactory() {
        return this.factory;
    }

    @Override
    public IClass getLeastCommonSuperclass(IClass a, IClass b) {
        Set<IClass> superA;
        Set<IClass> superB;
        assert (a.getClassLoader().getLanguage().equals(b.getClassLoader().getLanguage()));
        Language lang = a.getClassLoader().getLanguage();
        TypeReference tempA = a.getReference();
        if (a.equals(b)) {
            return a;
        }
        if (tempA.equals(TypeReference.Null)) {
            return b;
        }
        if (b.getReference().equals(TypeReference.Null)) {
            return a;
        }
        if (b.getReference().equals(lang.getRootType())) {
            return b;
        }
        Node n = this.map.get(b.getReference());
        if (n == null) assert (n != null) : "null n for " + b;
        try {
            superB = this.getSuperclasses(b);
        }
        catch (ClassHierarchyException e1) {
            e1.printStackTrace();
            Assertions.UNREACHABLE();
            superB = null;
        }
        for (IClass aa = a; aa != null; aa = aa.getSuperclass()) {
            if (!b.equals(aa) && !superB.contains(aa)) continue;
            return aa;
        }
        try {
            superA = this.getSuperclasses(a);
        }
        catch (ClassHierarchyException e1) {
            e1.printStackTrace();
            Assertions.UNREACHABLE();
            superA = null;
        }
        Assertions.UNREACHABLE((String)("getLeastCommonSuperclass " + tempA + " " + b + ": " + superA + ", " + superB));
        return null;
    }

    private Set<IClass> getSuperclasses(IClass c) throws ClassHierarchyException {
        HashSet result = HashSetFactory.make((int)3);
        while (c.getSuperclass() != null) {
            result.add(c.getSuperclass());
            c = c.getSuperclass();
        }
        return result;
    }

    @Override
    public TypeReference getLeastCommonSuperclass(TypeReference a, TypeReference b) {
        if (a == null) {
            throw new IllegalArgumentException("a is null");
        }
        if (a.equals(b)) {
            return a;
        }
        IClass aClass = this.lookupClass(a);
        IClass bClass = this.lookupClass(b);
        if (aClass == null || bClass == null) {
            if (aClass != null) {
                return aClass.getClassLoader().getLanguage().getRootType();
            }
            if (bClass != null) {
                return bClass.getClassLoader().getLanguage().getRootType();
            }
            return this.getRootClass().getReference();
        }
        return this.getLeastCommonSuperclass(aClass, bClass).getReference();
    }

    @Override
    public IClass lookupClass(TypeReference a) {
        if (a == null) {
            throw new IllegalArgumentException("a is null");
        }
        IClass cls = this.lookupClassRecursive(a);
        if (cls == null) {
            this.unresolved.add(a);
        }
        return cls;
    }

    private IClass lookupClassRecursive(TypeReference a) {
        TypeReference p;
        IClass c;
        ClassLoaderReference loader = a.getClassLoader();
        ClassLoaderReference parent = loader.getParent();
        if (parent != null && (c = this.lookupClassRecursive(p = TypeReference.findOrCreate(parent, a.getName()))) != null) {
            return c;
        }
        if (a.isArrayType()) {
            TypeReference elt = a.getInnermostElementType();
            if (elt.isPrimitiveType()) {
                return this.getRootClass().getClassLoader().lookupClass(a.getName());
            }
            c = this.lookupClassRecursive(elt);
            if (c == null) {
                return null;
            }
            return c.getClassLoader().lookupClass(a.getName());
        }
        Node n = this.map.get(a);
        if (n != null) {
            return n.klass;
        }
        return null;
    }

    private boolean slowIsSubclass(IClass sub, IClass sup) {
        if (sub == sup) {
            return true;
        }
        IClass parent = sub.getSuperclass();
        if (parent == null) {
            return false;
        }
        return this.slowIsSubclass(parent, sup);
    }

    @Override
    public boolean isSubclassOf(IClass c, IClass t) {
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        assert (t != null) : "null T";
        if (c.isArrayClass()) {
            if (t.getReference() == TypeReference.JavaLangObject) {
                return true;
            }
            if (t.getReference().isArrayType()) {
                TypeReference elementType = t.getReference().getArrayElementType();
                if (elementType.isPrimitiveType()) {
                    return elementType.equals(c.getReference().getArrayElementType());
                }
                IClass elementKlass = this.lookupClass(elementType);
                if (elementKlass == null) {
                    Warnings.add(ClassHierarchyWarning.create("could not find " + elementType));
                    return false;
                }
                IClass ce = ((ArrayClass)c).getElementClass();
                if (ce == null) {
                    return false;
                }
                if (elementKlass.isInterface()) {
                    return this.implementsInterface(ce, elementKlass);
                }
                return this.isSubclassOf(ce, elementKlass);
            }
            return false;
        }
        if (t.getReference().isArrayType()) {
            return false;
        }
        if (c.getReference().equals(t.getReference())) {
            return true;
        }
        Node n1 = this.map.get(c.getReference());
        if (n1 == null) {
            return false;
        }
        Node n2 = this.map.get(t.getReference());
        if (n2 == null) {
            return false;
        }
        if (n1.left == -1) {
            return this.slowIsSubclass(c, t);
        }
        if (n2.left == -1) {
            return this.slowIsSubclass(c, t);
        }
        return n2.left <= n1.left && n1.left <= n2.right;
    }

    @Override
    public boolean implementsInterface(IClass c, IClass i) {
        if (i == null) {
            throw new IllegalArgumentException("Cannot ask implementsInterface with i == null");
        }
        if (c == null) {
            throw new IllegalArgumentException("Cannot ask implementsInterface with c == null");
        }
        if (!i.isInterface()) {
            return false;
        }
        if (c.equals(i)) {
            return true;
        }
        if (c.isArrayClass()) {
            return i.equals(this.lookupClass(TypeReference.JavaLangCloneable)) || i.equals(this.lookupClass(TypeReference.JavaIoSerializable));
        }
        Set<IClass> impls = this.implementors.get(i);
        return impls != null && impls.contains(c);
    }

    @Override
    public Collection<IClass> computeSubClasses(TypeReference type) {
        IClass t = this.lookupClass(type);
        if (t == null) {
            throw new IllegalArgumentException("could not find class for TypeReference " + type);
        }
        if (t.getReference().equals(TypeReference.JavaLangError)) {
            if (this.subclassesOfError == null) {
                this.subclassesOfError = this.computeSubClassesInternal(t);
            }
            return this.subclassesOfError;
        }
        if (t.getReference().equals(TypeReference.JavaLangRuntimeException)) {
            if (this.runtimeExceptionClasses == null) {
                this.runtimeExceptionClasses = this.computeSubClassesInternal(t);
            }
            return this.runtimeExceptionClasses;
        }
        return this.computeSubClassesInternal(t);
    }

    @Override
    public Collection<TypeReference> getJavaLangErrorTypes() {
        if (this.subTypeRefsOfError == null) {
            this.computeSubClasses(TypeReference.JavaLangError);
            this.subTypeRefsOfError = HashSetFactory.make((int)this.subclassesOfError.size());
            for (IClass klass : this.subclassesOfError) {
                this.subTypeRefsOfError.add(klass.getReference());
            }
        }
        return Collections.unmodifiableCollection(this.subTypeRefsOfError);
    }

    @Override
    public Collection<TypeReference> getJavaLangRuntimeExceptionTypes() {
        if (this.runtimeExceptionTypeRefs == null) {
            this.computeSubClasses(TypeReference.JavaLangRuntimeException);
            this.runtimeExceptionTypeRefs = HashSetFactory.make((int)this.runtimeExceptionClasses.size());
            for (IClass klass : this.runtimeExceptionClasses) {
                this.runtimeExceptionTypeRefs.add(klass.getReference());
            }
        }
        return Collections.unmodifiableCollection(this.runtimeExceptionTypeRefs);
    }

    private Set<IClass> computeSubClassesInternal(IClass T) {
        if (T.isArrayClass()) {
            return Collections.singleton(T);
        }
        Node node = this.findNode(T);
        assert (node != null) : "null node for class " + T;
        HashSet result = HashSetFactory.make((int)3);
        result.add(T);
        Iterator<Node> it = node.getChildren();
        while (it.hasNext()) {
            Node child = it.next();
            result.addAll(this.computeSubClasses(child.klass.getReference()));
        }
        return result;
    }

    @Override
    public boolean isInterface(TypeReference type) {
        IClass T = this.lookupClass(type);
        assert (T != null) : "Null lookup for " + type;
        return T.isInterface();
    }

    @Override
    public Set<IClass> getImplementors(TypeReference type) {
        IClass T = this.lookupClass(type);
        Set<IClass> result = this.implementors.get(T);
        if (result == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Iterator<IClass> iterator() {
        Function<Node, IClass> toClass = new Function<Node, IClass>(){

            public IClass apply(Node n) {
                return n.klass;
            }
        };
        return new MapIterator(this.map.values().iterator(), (Function)toClass);
    }

    @Override
    public int getNumberOfClasses() {
        return this.map.keySet().size();
    }

    @Override
    public IClassLoader[] getLoaders() {
        return this.loaders;
    }

    @Override
    public IClassLoader getLoader(ClassLoaderReference loaderRef) {
        for (int i = 0; i < this.loaders.length; ++i) {
            if (!this.loaders[i].getReference().equals(loaderRef)) continue;
            return this.loaders[i];
        }
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public AnalysisScope getScope() {
        return this.scope;
    }

    @Override
    public int getNumberOfImmediateSubclasses(IClass klass) {
        if (klass.isArrayClass()) {
            IClass innermost = this.getInnermostTypeOfArrayClass(klass);
            return innermost == null ? 0 : this.getNumberOfImmediateSubclasses(innermost);
        }
        Node node = this.findNode(klass);
        return node.children.size();
    }

    @Override
    public Collection<IClass> getImmediateSubclasses(IClass klass) {
        if (klass.isArrayClass()) {
            return this.getImmediateArraySubclasses((ArrayClass)klass);
        }
        Function<Node, IClass> node2Class = new Function<Node, IClass>(){

            public IClass apply(Node n) {
                return n.klass;
            }
        };
        return Iterator2Collection.toSet((Iterator)new MapIterator(this.findNode(klass).children.iterator(), (Function)node2Class));
    }

    private Collection<IClass> getImmediateArraySubclasses(ArrayClass klass) {
        IClass innermost = this.getInnermostTypeOfArrayClass(klass);
        if (innermost == null) {
            return Collections.emptySet();
        }
        Collection<IClass> innermostSubclasses = this.getImmediateSubclasses(innermost);
        int dim = klass.getDimensionality();
        HashSet result = HashSetFactory.make();
        for (IClass k : innermostSubclasses) {
            TypeReference ref = k.getReference();
            for (int i = 0; i < dim; ++i) {
                ref = ref.getArrayTypeForElementType();
            }
            result.add(this.lookupClass(ref));
        }
        return result;
    }

    private IClass getInnermostTypeOfArrayClass(IClass klass) {
        TypeReference result = klass.getReference();
        while (result.isArrayType()) {
            result = result.getArrayElementType();
        }
        return result.isPrimitiveType() ? null : this.lookupClass(result);
    }

    public static ClassHierarchy make(AnalysisScope scope) throws ClassHierarchyException {
        if (scope == null) {
            throw new IllegalArgumentException("null scope");
        }
        return ClassHierarchy.make(scope, new ClassLoaderFactoryImpl(scope.getExclusions()));
    }

    public static ClassHierarchy make(AnalysisScope scope, MonitorUtil.IProgressMonitor monitor) throws ClassHierarchyException {
        if (scope == null) {
            throw new IllegalArgumentException("null scope");
        }
        return ClassHierarchy.make(scope, (ClassLoaderFactory)new ClassLoaderFactoryImpl(scope.getExclusions()), monitor);
    }

    public static ClassHierarchy make(AnalysisScope scope, ClassLoaderFactory factory) throws ClassHierarchyException {
        if (scope == null) {
            throw new IllegalArgumentException("null scope");
        }
        if (factory == null) {
            throw new IllegalArgumentException("null factory");
        }
        return new ClassHierarchy(scope, factory, null);
    }

    public static ClassHierarchy make(AnalysisScope scope, ClassLoaderFactory factory, MonitorUtil.IProgressMonitor monitor) throws ClassHierarchyException {
        return new ClassHierarchy(scope, factory, monitor);
    }

    public static ClassHierarchy make(AnalysisScope scope, ClassLoaderFactory factory, Set<Language> languages) throws ClassHierarchyException {
        return new ClassHierarchy(scope, factory, languages, null);
    }

    public static ClassHierarchy make(AnalysisScope scope, ClassLoaderFactory factory, Language language) throws ClassHierarchyException {
        return new ClassHierarchy(scope, factory, language, null);
    }

    public static ClassHierarchy make(AnalysisScope scope, ClassLoaderFactory factory, Language language, MonitorUtil.IProgressMonitor monitor) throws ClassHierarchyException {
        if (factory == null) {
            throw new IllegalArgumentException("null factory");
        }
        return new ClassHierarchy(scope, factory, language, monitor);
    }

    @Override
    public IClass getRootClass() {
        return this.root.getJavaClass();
    }

    @Override
    public boolean isRootClass(IClass c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException("c == null");
        }
        return c.equals(this.root.getJavaClass());
    }

    @Override
    public int getNumber(IClass c) {
        return this.map.get(c.getReference()).left;
    }

    @Override
    public boolean isAssignableFrom(IClass c1, IClass c2) {
        if (c2 == null) {
            throw new IllegalArgumentException("c2 is null");
        }
        if (c1 == null) {
            throw new IllegalArgumentException("c1 is null");
        }
        if (c1.isInterface()) {
            return this.implementsInterface(c2, c1);
        }
        if (c2.isInterface()) {
            return c1.equals(this.getRootClass());
        }
        return this.isSubclassOf(c2, c1);
    }

    @Override
    public final Set<TypeReference> getUnresolvedClasses() {
        return this.unresolved;
    }

    private static class ClassExclusion
    extends Warning {
        final TypeReference klass;
        final String message;

        ClassExclusion(TypeReference klass, String message) {
            super((byte)1);
            this.klass = klass;
            this.message = message;
        }

        @Override
        public String getMsg() {
            return this.getClass().toString() + " : " + this.klass + " " + this.message;
        }

        public static ClassExclusion create(TypeReference klass, String message) {
            return new ClassExclusion(klass, message);
        }
    }

    private static final class Node {
        private final IClass klass;
        private final Set<Node> children = HashSetFactory.make((int)3);
        private int left = -1;
        private int right = -1;

        Node(IClass klass) {
            this.klass = klass;
        }

        boolean isInterface() {
            return this.klass.isInterface();
        }

        IClass getJavaClass() {
            return this.klass;
        }

        void addChild(Node child) {
            this.children.add(child);
        }

        Iterator<Node> getChildren() {
            return this.children.iterator();
        }

        public String toString() {
            StringBuffer result = new StringBuffer(100);
            result.append(this.klass.toString()).append(":");
            Iterator<Node> i = this.children.iterator();
            while (i.hasNext()) {
                Node n = i.next();
                result.append(n.klass.toString());
                if (!i.hasNext()) continue;
                result.append(",");
            }
            return result.toString();
        }

        public int hashCode() {
            return this.klass.hashCode() * 929;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }
    }
}

