/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;

public abstract class SSAFieldAccessInstruction
extends SSAInstruction {
    private final FieldReference field;
    private final int ref;

    protected SSAFieldAccessInstruction(int iindex, FieldReference field, int ref) throws IllegalArgumentException {
        super(iindex);
        this.field = field;
        this.ref = ref;
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
    }

    public TypeReference getDeclaredFieldType() {
        return this.field.getFieldType();
    }

    public FieldReference getDeclaredField() {
        return this.field;
    }

    public int getRef() {
        return this.ref;
    }

    public boolean isStatic() {
        return this.ref == -1;
    }

    @Override
    public boolean isPEI() {
        return !this.isStatic();
    }
}

