/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.bytecode;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.shrikeBT.BytecodeConstants;

public class BytecodeStream
implements BytecodeConstants {
    private final IMethod method;
    private final IClass declaringClass;
    private final int bcLength;
    private final byte[] bcodes;
    private int bcIndex;
    private int opcode;
    private boolean wide;

    public BytecodeStream(IMethod m, byte[] bc) {
        if (m == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (bc == null) {
            throw new IllegalArgumentException("bc is null");
        }
        this.method = m;
        this.declaringClass = m.getDeclaringClass();
        this.bcodes = bc;
        this.bcLength = bc.length;
        this.bcIndex = 0;
    }

    public final IMethod method() {
        return this.method;
    }

    public final IClass declaringClass() {
        return this.declaringClass;
    }

    public final int length() {
        return this.bcLength;
    }

    public final int index() {
        return this.bcIndex;
    }

    public final void reset() {
        this.reset(0);
    }

    public final void reset(int index) {
        this.bcIndex = index;
    }

    public final boolean hasMoreBytecodes() {
        return this.bcIndex < this.bcLength;
    }

    public final int peekNextOpcode() {
        return this.getUnsignedByte(this.bcIndex);
    }

    public final int nextInstruction() {
        this.opcode = this.readUnsignedByte();
        this.wide = this.opcode == 196;
        return this.opcode;
    }

    public final int getOpcode() {
        return this.opcode;
    }

    public final boolean isWide() {
        return this.wide;
    }

    public final void skipInstruction() {
        int len = JBC_length[this.opcode] - 1;
        if (this.wide) {
            len += len;
        }
        if (len >= 0) {
            this.bcIndex += len;
        } else {
            this.skipSpecialInstruction(this.opcode);
        }
    }

    public final void skipInstruction(int opc, boolean w) {
        int len = JBC_length[opc] - 1;
        if (w) {
            len += len;
        }
        if (len >= 0) {
            this.bcIndex += len;
        } else {
            this.skipSpecialInstruction(opc);
        }
    }

    public final int getByteValue() {
        return this.readSignedByte();
    }

    public final int getShortValue() {
        return this.readSignedShort();
    }

    public final int getLocalNumber() {
        return this.readUnsignedByte();
    }

    public final int getWideLocalNumber() {
        return this.readUnsignedShort();
    }

    public final int getIncrement() {
        return this.readSignedByte();
    }

    public final int getWideIncrement() {
        return this.readSignedShort();
    }

    public final int getBranchOffset() {
        return this.readSignedShort();
    }

    public final int getWideBranchOffset() {
        return this.readSignedInt();
    }

    public final void alignSwitch() {
        int align = this.bcIndex & 3;
        if (align != 0) {
            this.bcIndex += 4 - align;
        }
    }

    public final int getDefaultSwitchOffset() {
        return this.readSignedInt();
    }

    public final int getLowSwitchValue() {
        return this.readSignedInt();
    }

    public final int getHighSwitchValue() {
        return this.readSignedInt();
    }

    public final void skipTableSwitchOffsets(int num) {
        this.bcIndex += num << 2;
    }

    public final int getTableSwitchOffset(int num) {
        return this.getSignedInt(this.bcIndex + (num << 2));
    }

    public final int computeTableSwitchOffset(int value, int low, int high) {
        if (value < low || value > high) {
            return 0;
        }
        return this.getSignedInt(this.bcIndex + (value - low << 2));
    }

    public final int getSwitchLength() {
        return this.readSignedInt();
    }

    public final void skipLookupSwitchPairs(int num) {
        this.bcIndex += num << 3;
    }

    public final int getLookupSwitchOffset(int num) {
        return this.getSignedInt(this.bcIndex + (num << 3) + 4);
    }

    public final int getLookupSwitchValue(int num) {
        return this.getSignedInt(this.bcIndex + (num << 3));
    }

    public final int computeLookupSwitchOffset(int value, int num) {
        for (int i = 0; i < num; ++i) {
            if (this.getSignedInt(this.bcIndex + (i << 3)) != value) continue;
            return this.getSignedInt(this.bcIndex + (i << 3) + 4);
        }
        return 0;
    }

    public final void alignInvokeInterface() {
        this.bcIndex += 2;
    }

    public final int getArrayElementType() {
        return this.readUnsignedByte();
    }

    public final int getArrayDimension() {
        return this.readUnsignedByte();
    }

    public final int getWideOpcode() {
        this.opcode = this.readUnsignedByte();
        return this.opcode;
    }

    public final int getConstantIndex() {
        return this.readUnsignedByte();
    }

    public final int getWideConstantIndex() {
        return this.readUnsignedShort();
    }

    private void skipSpecialInstruction(int opcode) {
        switch (opcode) {
            case 170: {
                this.alignSwitch();
                this.getDefaultSwitchOffset();
                int l = this.getLowSwitchValue();
                int h = this.getHighSwitchValue();
                this.skipTableSwitchOffsets(h - l + 1);
                break;
            }
            case 171: {
                this.alignSwitch();
                this.getDefaultSwitchOffset();
                int n = this.getSwitchLength();
                this.skipLookupSwitchPairs(n);
                break;
            }
            case 196: {
                int oc = this.getWideOpcode();
                int len = JBC_length[oc] - 1;
                this.bcIndex += len + len;
                break;
            }
            default: {
                throw new NullPointerException();
            }
        }
    }

    private final byte readSignedByte() {
        return this.bcodes[this.bcIndex++];
    }

    private final int readUnsignedByte() {
        return this.bcodes[this.bcIndex++] & 0xFF;
    }

    private final int getUnsignedByte(int index) {
        return this.bcodes[index] & 0xFF;
    }

    private final int readSignedShort() {
        int i = this.bcodes[this.bcIndex++] << 8;
        return i |= this.bcodes[this.bcIndex++] & 0xFF;
    }

    private final int readUnsignedShort() {
        int i = (this.bcodes[this.bcIndex++] & 0xFF) << 8;
        return i |= this.bcodes[this.bcIndex++] & 0xFF;
    }

    private final int readSignedInt() {
        int i = this.bcodes[this.bcIndex++] << 24;
        i |= (this.bcodes[this.bcIndex++] & 0xFF) << 16;
        i |= (this.bcodes[this.bcIndex++] & 0xFF) << 8;
        return i |= this.bcodes[this.bcIndex++] & 0xFF;
    }

    private final int getSignedInt(int index) {
        int i = this.bcodes[index++] << 24;
        i |= (this.bcodes[index++] & 0xFF) << 16;
        i |= (this.bcodes[index++] & 0xFF) << 8;
        return i |= this.bcodes[index] & 0xFF;
    }
}

