/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.samso.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class HashMapOrderedSet<V, T>
implements Set<T>,
Cloneable {
    private static final long serialVersionUID = 1L;
    private HashMap<V, ArrayList<T>> elements;
    private ArrayList<T> list;

    public HashMapOrderedSet() {
        this.elements = new HashMap();
        this.list = new ArrayList();
    }

    public HashMapOrderedSet(int initialCapacity, float loadFactor) {
        this.elements = new HashMap(initialCapacity, loadFactor);
        this.list = new ArrayList();
    }

    public HashMapOrderedSet(Collection<? extends T> rules) {
        this();
        this.addAll(rules);
    }

    protected abstract V getKey(T var1);

    public List<T> getList(V v) {
        return Collections.unmodifiableList(this.getModifiableList(v));
    }

    private List<T> getModifiableList(V v) {
        ArrayList<Object> rs = this.elements.get(v);
        if (rs == null) {
            rs = new ArrayList();
            this.elements.put((ArrayList<T>)v, rs);
        }
        return rs;
    }

    public Set<V> keySet() {
        return this.elements.keySet();
    }

    @Override
    public boolean add(T e) {
        if (this.contains(e)) {
            return false;
        }
        this.list.add(e);
        return this.getModifiableList(this.getKey(e)).add(e);
    }

    public boolean add(int idx, T e) {
        if (this.contains(e)) {
            return false;
        }
        this.list.add(idx, e);
        return this.getModifiableList(this.getKey(e)).add(e);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean modified = false;
        for (T r : c) {
            if (!this.add(r)) continue;
            modified = true;
        }
        return modified;
    }

    public boolean addAll(int idx, Collection<? extends T> c) {
        boolean modified = false;
        for (T r : c) {
            if (!this.add(idx, r)) continue;
            ++idx;
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.elements.clear();
        this.list.clear();
    }

    @Override
    public boolean contains(Object o) {
        Object r = o;
        List<T> rs = this.getList(this.getKey(r));
        return rs.contains(r);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        for (Map.Entry<V, ArrayList<T>> e : this.elements.entrySet()) {
            if (e.getValue().isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<T> iter = this.list.iterator();
        return new Iterator<T>(){
            private T cur;

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public T next() {
                this.cur = iter.next();
                return this.cur;
            }

            @Override
            public void remove() {
                ((ArrayList)HashMapOrderedSet.this.elements.get(HashMapOrderedSet.this.getKey(this.cur))).remove(this.cur);
                iter.remove();
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        Object v = o;
        List<T> s = this.getModifiableList(this.getKey(v));
        if (s.remove(o)) {
            if (s.isEmpty()) {
                this.elements.remove(this.getKey(v));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            if (!this.remove(o)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int i = 0;
        for (Map.Entry<V, ArrayList<T>> e : this.elements.entrySet()) {
            i += e.getValue().size();
        }
        return i;
    }

    @Override
    public Object[] toArray() {
        Object[] objs = new Object[this.size()];
        return this.toArray((U[])objs);
    }

    @Override
    public <U> U[] toArray(U[] objs) {
        int i = 0;
        for (T r : this) {
            objs[i] = r;
            ++i;
        }
        return objs;
    }

    public Object clone() {
        try {
            HashMapOrderedSet s = (HashMapOrderedSet)super.clone();
            s.elements = (HashMap)this.elements.clone();
            for (Map.Entry<ArrayList, ArrayList<T>> entry : s.elements.entrySet()) {
                entry.setValue((ArrayList)entry.getValue().clone());
            }
            return s;
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public int hashCode() {
        return this.elements.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Collection)) {
            return false;
        }
        Collection c = (Collection)o;
        if (this.size() != c.size()) {
            return false;
        }
        return this.containsAll(c) && c.containsAll(this);
    }
}

