/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.samso.m2lstr;

import com.ibm.wala.automaton.regex.string.AbstractPatternCompiler;
import com.ibm.wala.automaton.regex.string.ComplementPattern;
import com.ibm.wala.automaton.regex.string.ConcatenationPattern;
import com.ibm.wala.automaton.regex.string.EmptyPattern;
import com.ibm.wala.automaton.regex.string.IntersectionPattern;
import com.ibm.wala.automaton.regex.string.IterationPattern;
import com.ibm.wala.automaton.regex.string.SymbolPattern;
import com.ibm.wala.automaton.regex.string.UnionPattern;
import com.ibm.wala.automaton.regex.string.VariableBindingPattern;
import com.ibm.wala.automaton.regex.string.VariableReferencePattern;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IntSymbol;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.samso.m2lstr.IExtendedFormulaFactory;
import com.ibm.wala.samso.m2lstr.IFormula;
import com.ibm.wala.samso.m2lstr.ILambdaFormula;
import com.ibm.wala.samso.m2lstr.IPositionSetVariable;
import com.ibm.wala.samso.m2lstr.IPositionVariable;
import com.ibm.wala.samso.m2lstr.LambdaFormula;
import com.ibm.wala.samso.m2lstr.M2LSymbol;
import com.ibm.wala.samso.translator.IDeclarationSet;

public class RegexpToM2LFormula
extends AbstractPatternCompiler<ILambdaFormula> {
    private final IExtendedFormulaFactory ffactory;

    public RegexpToM2LFormula(IExtendedFormulaFactory ffactory) {
        this.ffactory = ffactory;
    }

    public ILambdaFormula onComplement(ComplementPattern pattern) {
        ILambdaFormula r = (ILambdaFormula)this.compile(pattern.getPattern());
        return LambdaFormula.make(r.getVariable(0), this.ffactory.createNot(r.getFormula()));
    }

    public ILambdaFormula onConcatenation(ConcatenationPattern pattern) {
        ILambdaFormula r1 = (ILambdaFormula)this.compile(pattern.getHead());
        ILambdaFormula r2 = (ILambdaFormula)this.compile(pattern.getTail());
        IPositionSetVariable v = this.ffactory.createPositionSetVariable();
        IFormula f = this.ffactory.createAnd(this.ffactory.createIsConcat(v, (IPositionSetVariable)r1.getVariable(0), (IPositionSetVariable)r2.getVariable(0)), this.ffactory.createAnd(r1.getFormula(), r2.getFormula()));
        f = this.ffactory.createExists((IPositionSetVariable)r2.getVariable(0), f);
        f = this.ffactory.createExists((IPositionSetVariable)r1.getVariable(0), f);
        return LambdaFormula.make(v, f);
    }

    public ILambdaFormula onEmpty(EmptyPattern pattern) {
        IPositionSetVariable v = this.ffactory.createPositionSetVariable();
        return LambdaFormula.make(v, this.ffactory.createIsEmpty(v));
    }

    public ILambdaFormula onIntersection(IntersectionPattern pattern) {
        ILambdaFormula r1 = (ILambdaFormula)this.compile(pattern.getLeft());
        ILambdaFormula r2 = (ILambdaFormula)this.compile(pattern.getRight());
        IPositionSetVariable v = this.ffactory.createPositionSetVariable();
        IFormula f = this.ffactory.createAnd(r1.getFormula(), r2.getFormula());
        IFormula eq = this.ffactory.createAnd(this.ffactory.createPositionSetEqual(v, (IPositionSetVariable)r1.getVariable(0)), this.ffactory.createPositionSetEqual(v, (IPositionSetVariable)r2.getVariable(0)));
        f = this.ffactory.createAnd(eq, f);
        f = this.ffactory.createExists((IPositionSetVariable)r2.getVariable(0), f);
        f = this.ffactory.createExists((IPositionSetVariable)r1.getVariable(0), f);
        return LambdaFormula.make(v, f);
    }

    public ILambdaFormula onIteration(IterationPattern pattern) {
        ILambdaFormula target = (ILambdaFormula)this.compile(pattern.getPattern());
        IPositionSetVariable R = this.ffactory.createPositionSetVariable();
        IPositionSetVariable S = (IPositionSetVariable)target.getVariable(0);
        IPositionSetVariable P = this.ffactory.createPositionSetVariable();
        IPositionVariable r1 = this.ffactory.createPositionVariable();
        IPositionVariable r2 = this.ffactory.createPositionVariable();
        IFormula min = this.ffactory.createIn(this.ffactory.createApplyPositionFunction(this.ffactory.createMinFunction(), R), P);
        IFormula max = this.ffactory.createIn(this.ffactory.createPositionPlus(this.ffactory.createApplyPositionFunction(this.ffactory.createMaxFunction(), R), 1), P);
        IFormula con = this.ffactory.createIsConsecutive(r1, r2, P);
        IFormula strr = this.ffactory.createIsStrr(S, R, r1, r2);
        IFormula impl = this.ffactory.createImply(con, this.ffactory.createExists(S, this.ffactory.createAnd(strr, target.getFormula())));
        IFormula impl2 = this.ffactory.createForall(r1, this.ffactory.createForall(r2, impl));
        IFormula body = this.ffactory.createExists(P, this.ffactory.createAnd(this.ffactory.createAnd(min, max), impl2));
        return LambdaFormula.make(R, body);
    }

    public ILambdaFormula onSymbol(SymbolPattern pattern) {
        ISymbol sym = pattern.getSymbol();
        IPositionSetVariable v = this.ffactory.createPositionSetVariable();
        if (sym instanceof StringSymbol) {
            StringSymbol ssym = (StringSymbol)sym;
            String s = ssym.getName();
            return LambdaFormula.make(v, this.ffactory.createIsStr(s, v));
        }
        if (sym instanceof CharSymbol) {
            CharSymbol csym = (CharSymbol)sym;
            String s = Character.toString(csym.charValue());
            return LambdaFormula.make(v, this.ffactory.createIsStr(s, v));
        }
        if (sym instanceof RangeSymbol) {
            RangeSymbol rsym = (RangeSymbol)sym;
            CharSymbol min = (CharSymbol)rsym.getMin();
            CharSymbol max = (CharSymbol)rsym.getMax();
            IPositionSetVariable R = this.ffactory.createPositionSetVariable();
            IFormula body = this.ffactory.createCharset(R, min.charValue(), max.charValue());
            return LambdaFormula.make(R, body);
        }
        if (sym instanceof IntSymbol) {
            IntSymbol isym = (IntSymbol)sym;
            String s = Character.toString(isym.charValue());
            return LambdaFormula.make(v, this.ffactory.createIsStr(s, v));
        }
        if (sym instanceof M2LSymbol) {
            M2LSymbol msym = (M2LSymbol)sym;
            IDeclarationSet declSet = msym.getLanguage();
            IFormula f = this.ffactory.createApplyPredicate(declSet.getTarget(), v);
            return LambdaFormula.make(v, f);
        }
        return LambdaFormula.make(v, this.ffactory.createTrue());
    }

    public ILambdaFormula onUnion(UnionPattern pattern) {
        IPositionSetVariable v = this.ffactory.createPositionSetVariable();
        ILambdaFormula r1 = (ILambdaFormula)this.compile(pattern.getLeft());
        IFormula eq1 = this.ffactory.createPositionSetEqual(v, (IPositionSetVariable)r1.getVariable(0));
        IFormula f1 = this.ffactory.createAnd(r1.getFormula(), eq1);
        f1 = this.ffactory.createExists((IPositionSetVariable)r1.getVariable(0), f1);
        ILambdaFormula r2 = (ILambdaFormula)this.compile(pattern.getRight());
        IFormula eq2 = this.ffactory.createPositionSetEqual(v, (IPositionSetVariable)r2.getVariable(0));
        IFormula f2 = this.ffactory.createAnd(r2.getFormula(), eq2);
        f2 = this.ffactory.createExists((IPositionSetVariable)r2.getVariable(0), f2);
        IFormula f = this.ffactory.createOr(f1, f2);
        return LambdaFormula.make(v, f);
    }

    public ILambdaFormula onVariableBinding(VariableBindingPattern pattern) {
        return (ILambdaFormula)this.compile(pattern.getPattern());
    }

    public ILambdaFormula onVariableReference(VariableReferencePattern pattern) {
        IPositionSetVariable pos = this.ffactory.createPositionSetVariable();
        return LambdaFormula.make(pos, this.ffactory.createTrue());
    }
}

