/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.samso.modular;

import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallerSiteContext;
import com.ibm.wala.samso.modular.ModuleUtil;
import com.ibm.wala.samso.translator.IDeclarationSet;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.stringAnalysis.grammar.GR;
import com.ibm.wala.stringAnalysis.grammar.GRule;
import com.ibm.wala.stringAnalysis.grammar.InvocationSymbol;
import com.ibm.wala.stringAnalysis.grammar.SignatureSymbol;
import com.ibm.wala.stringAnalysis.translator.CG2Grammar;
import com.ibm.wala.stringAnalysis.translator.IIR2Grammar;
import com.ibm.wala.stringAnalysis.translator.ISSA2Rule;
import com.ibm.wala.stringAnalysis.translator.TranslationContext;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class M2LModularCG2Grammar
extends CG2Grammar<IDeclarationSet> {
    private final ModuleUtil mutil;

    public M2LModularCG2Grammar(IIR2Grammar<IDeclarationSet> ir2gr, ModuleUtil mutil, MonitorUtil.IProgressMonitor progressMonitor, Logger logger) {
        super(ir2gr, progressMonitor, logger);
        this.mutil = mutil;
    }

    protected void translateNode(Collection<IProductionRule> rules, CGNode node, CallGraph callGraph, PointerAnalysis pointerAnalysis, ISSA2Rule<IDeclarationSet> ssa2rule) {
        IR ir = node.getIR();
        if (ir == null) {
            return;
        }
        IClassLoader loader = node.getMethod().getDeclaringClass().getClassLoader();
        if (ssa2rule.getSymbolFactory().getRepository().isBuiltin(node, loader.getReference())) {
            super.translateNode(rules, node, callGraph, pointerAnalysis, ssa2rule);
        } else if (this.mutil.isModuleEntry(node.getMethod().getReference())) {
            this.translateModuleEntry(rules, node, callGraph, pointerAnalysis, ssa2rule);
        } else {
            super.translateNode(rules, node, callGraph, pointerAnalysis, ssa2rule);
        }
    }

    private void translateModuleEntry(Collection<IProductionRule> rules, CGNode node, CallGraph callGraph, PointerAnalysis pointerAnalysis, ISSA2Rule<IDeclarationSet> ssa2rule) {
        IR ir = node.getIR();
        TypeInference typeInference = this.getTypeInferenceBuilder().createTypeInference(ir);
        if (typeInference != null) {
            typeInference.solve();
        }
        TranslationContext ctx = new TranslationContext(ir, node, callGraph, pointerAnalysis, typeInference, null, this.progressMonitor, this.logger);
        GR gr = this.getIR2Grammar().translate(ctx);
        boolean emptyGR = gr.getRules().isEmpty();
        this.addRules(rules, gr.getRules(), callGraph);
        this.registerIRInfo(ir, ssa2rule, ctx);
        Context c = node.getContext();
        if (c instanceof CallerSiteContext) {
            CallerSiteContext cc = (CallerSiteContext)c;
            CGNode caller = cc.getCaller();
            CallSiteReference site = cc.getCallSite();
            if (!emptyGR) {
                rules.addAll(this.createModuleRules(site, caller, node, callGraph, ctx));
            }
        } else {
            Iterator j = callGraph.getPredNodes((Object)node);
            while (j.hasNext()) {
                CGNode caller = (CGNode)j.next();
                if (caller == null) continue;
                Iterator k = callGraph.getPossibleSites(caller, node);
                while (k.hasNext()) {
                    CallSiteReference site = (CallSiteReference)k.next();
                    if (emptyGR) continue;
                    rules.addAll(this.createModuleRules(site, caller, node, callGraph, ctx));
                }
            }
        }
    }

    private void registerIRInfo(IR ir, ISSA2Rule<IDeclarationSet> ssa2rule, TranslationContext ctx) {
        List<Pair<Integer, TypeReference>> ivns = this.mutil.getStringInputValueNumbersWithTypes(ir);
        ArrayList<IVariable> inputs = new ArrayList<IVariable>();
        ArrayList<TypeName> itypes = new ArrayList<TypeName>();
        for (Pair<Integer, TypeReference> ivn : ivns) {
            Collection vs = ssa2rule.getSymbolFactory().createCDVariable(((Integer)ivn.fst).intValue(), ctx);
            assert (vs.size() == 1);
            IVariable v = (IVariable)vs.iterator().next();
            inputs.add(v);
            itypes.add(((TypeReference)ivn.snd).getName());
        }
        int[] ovns = this.mutil.getStringOutputValueNumbers(ir);
        ArrayList<IVariable> outputs = new ArrayList<IVariable>();
        ArrayList<TypeName> otypes = new ArrayList<TypeName>();
        for (int ovn : ovns) {
            Collection vs = ssa2rule.getSymbolFactory().createCDVariable(ovn, ctx);
            assert (vs.size() == 1);
            IVariable v = (IVariable)vs.iterator().next();
            outputs.add(v);
            otypes.add(ir.getMethod().getReturnType().getName());
        }
        this.mutil.registerIRInfo(ir, inputs, itypes, outputs, otypes);
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)("register IR's input/output: " + ir.getMethod().getSignature()));
            SAUtil.println((Object)("  input: " + inputs));
            SAUtil.println((Object)("  output: " + outputs));
        }
    }

    private Collection<IProductionRule> createModuleRules(CallSiteReference site, CGNode caller, CGNode callee, CallGraph cg, TranslationContext ctx) {
        ArrayList<IProductionRule> rules = new ArrayList<IProductionRule>();
        ISSA2Rule ssa2rule = this.getIR2Grammar().getBB2Grammar().getSSA2Rule();
        SSAAbstractInvokeInstruction[] invokes = caller.getIR().getCalls(site);
        String rawSignature = callee.getIR().getMethod().getSignature();
        SignatureSymbol sig = new SignatureSymbol("%" + rawSignature);
        TranslationContext callerContext = new TranslationContext(caller.getIR(), caller, ctx.getCallGraph(), ctx.getPointerAnalysis(), ctx.getTypeInference(), null, this.progressMonitor, this.logger);
        for (SSAAbstractInvokeInstruction invoke : invokes) {
            IVariable lhv = ssa2rule.getSymbolFactory().createValueNumberVariable(invoke.getDef(), caller, cg);
            Collection ss = ssa2rule.getSymbolFactory().createInvocationSymbol(invoke, callerContext);
            for (InvocationSymbol s : ss) {
                InvocationSymbol ns = new InvocationSymbol(cg, caller, (SSAInstruction)invoke, sig, s.getReceiver(), s.getParameters().toArray(new ISymbol[s.getParameters().size()]));
                GRule r = ssa2rule.createRule(caller.getIR(), (SSAInstruction)invoke, lhv, new ISymbol[]{ns});
                rules.add((IProductionRule)r);
            }
        }
        return rules;
    }
}

