/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.samso.modular;

import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.ProductionRule;
import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.string.ILanguageSymbol;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IValueSymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.samso.m2lstr.DeclarationSet;
import com.ibm.wala.samso.m2lstr.DeclarationSets;
import com.ibm.wala.samso.m2lstr.IPredicate;
import com.ibm.wala.samso.m2lstr.M2LSymbol;
import com.ibm.wala.samso.modular.ModuleUtil;
import com.ibm.wala.samso.modular.StringConstraintDeclaration;
import com.ibm.wala.samso.translator.IDeclarationSet;
import com.ibm.wala.samso.translator.M2LConstraintEncoder;
import com.ibm.wala.samso.translator.SolverContext;
import com.ibm.wala.samso.translator.repository.IM2LTranslatorRepository;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.stringAnalysis.grammar.IValueNumberInNode;
import com.ibm.wala.stringAnalysis.grammar.InvocationSymbol;
import com.ibm.wala.stringAnalysis.translator.ISolverCache;
import com.ibm.wala.stringAnalysis.translator.ISolverStack;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.MonitorUtil;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class M2LModularConstraintEncoder
extends M2LConstraintEncoder {
    private final ModuleUtil mutil;

    public M2LModularConstraintEncoder(IM2LTranslatorRepository repository, ISolverCache<IDeclarationSet> cache, ISolverStack stack, SolverContext initialContext, ModuleUtil mutil, MonitorUtil.IProgressMonitor monitor) {
        super(repository, cache, stack, initialContext, monitor);
        assert (mutil != null);
        this.mutil = mutil;
    }

    public Map<IVariable, IDeclarationSet> solve(SimpleGrammar g, Collection<? extends IVariable> startSymbols) {
        this.modularizeGrammar(g);
        return super.solve(g, startSymbols);
    }

    public IDeclarationSet solve(SimpleGrammar g, IVariable start) {
        this.modularizeGrammar(g);
        return (IDeclarationSet)super.solve(g, start);
    }

    public void modularizeGrammar(SimpleGrammar g) {
        HashMap<IVariable, Set<StringSymbol>> m = new HashMap<IVariable, Set<StringSymbol>>();
        for (IVariable iv : this.mutil.getInputVariables()) {
            Set<StringSymbol> ss = this.getConstantStrings(g, iv, m);
            Set del = g.getRules(iv);
            g.getRules().removeAll(del);
            if (ss == null) {
                IPredicate pred = this.mutil.getPredicate(iv);
                DeclarationSet declSet = new DeclarationSet(pred);
                StringConstraintDeclaration decl = new StringConstraintDeclaration("input svar " + pred);
                declSet.add(decl);
                ProductionRule r = new ProductionRule(iv, (ISymbol)new M2LSymbol(declSet));
                g.addRule((IProductionRule)r);
                continue;
            }
            for (StringSymbol s : ss) {
                ProductionRule r = new ProductionRule(iv, (ISymbol)s);
                g.addRule((IProductionRule)r);
            }
        }
    }

    private boolean isRegexp(TypeReference ty) {
        return "Ljava/util/regex/Pattern".equals(ty.getName().toString());
    }

    private boolean isRegexp(IVariable v) {
        if (v instanceof IValueNumberInNode) {
            IValueNumberInNode x = (IValueNumberInNode)v;
            IR ir = x.getCGNode().getIR();
            for (int i = 0; i < ir.getNumberOfParameters(); ++i) {
                TypeReference ty;
                if (ir.getParameterValueNumbers()[i] != x.getValueNumber() || !this.isRegexp(ty = ir.getParameterType(i))) continue;
                return true;
            }
        }
        return false;
    }

    Set<StringSymbol> getConstantStrings(SimpleGrammar g, IVariable v, Map<IVariable, Set<StringSymbol>> m) {
        Set rs = g.getRules(v);
        if (rs == null) {
            return null;
        }
        if (rs.isEmpty()) {
            return null;
        }
        if (m.containsKey(v)) {
            return m.get(v);
        }
        m.put(v, null);
        HashSet<StringSymbol> result = new HashSet<StringSymbol>();
        for (IProductionRule r : rs) {
            List l = r.getRight();
            if (l.size() == 1) {
                ISymbol s = (ISymbol)l.get(0);
                if (s instanceof IValueSymbol) {
                    result.add(((IValueSymbol)s).stringSymbolValue());
                    continue;
                }
                if (s instanceof IVariable) {
                    Set<StringSymbol> sub = this.getConstantStrings(g, (IVariable)s, m);
                    if (sub == null) {
                        return null;
                    }
                    result.addAll(sub);
                    continue;
                }
                return null;
            }
            return null;
        }
        m.put(v, result);
        return result;
    }

    protected IDeclarationSet solveInvocation(SimpleGrammar targetGrammar, IProductionRule invokeRule, InvocationSymbol invoke, int cycle) {
        if (invoke.getName().startsWith("%")) {
            IPredicate pred = this.getFormulaFactory().createPredicate(1, new IPredicate.ArgType[]{IPredicate.ArgType.POSITION_SET});
            DeclarationSet declSet = new DeclarationSet(pred);
            List<IPredicate> args = this.makeModuleParameters(invoke, declSet, targetGrammar);
            String signature = invoke.getName().substring(1);
            try {
                this.mutil.compile(signature);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            StringBuffer buff = new StringBuffer();
            buff.append("svar " + pred.getName() + " = ");
            buff.append("%i{" + this.mutil.getDFAFile(signature) + "}");
            buff.append("(");
            if (!args.isEmpty()) {
                for (IPredicate a : args) {
                    buff.append(a.toString());
                    buff.append(",");
                }
                buff.deleteCharAt(buff.length() - 1);
            }
            buff.append(")");
            StringConstraintDeclaration decl = new StringConstraintDeclaration(buff.toString());
            declSet.add(decl);
            return declSet;
        }
        return (IDeclarationSet)super.solveInvocation(targetGrammar, invokeRule, invoke, cycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IPredicate> makeModuleParameters(InvocationSymbol invoke, IDeclarationSet declSet, SimpleGrammar g) {
        SSAAbstractInvokeInstruction iinvoke = (SSAAbstractInvokeInstruction)invoke.getInstruction();
        ArrayList<ISymbol> args = new ArrayList<ISymbol>();
        boolean isStatic = iinvoke.isStatic();
        if (!isStatic) {
            args.add(invoke.getReceiver());
        }
        args.addAll(invoke.getParameters());
        int[] idx = this.mutil.getStringInput(iinvoke.getDeclaredTarget(), isStatic);
        ArrayList<IPredicate> ps = new ArrayList<IPredicate>();
        for (int i : idx) {
            IDeclarationSet ds;
            IDeclarationSet ds2;
            TypeReference ty = iinvoke.getDeclaredTarget().getParameterType(isStatic ? i : i - 1);
            ISymbol s = (ISymbol)args.get(i);
            if (s instanceof ILanguageSymbol) {
                M2LSymbol m2l = (M2LSymbol)((ILanguageSymbol)s).getLanguage();
                ds2 = m2l.getLanguage();
                declSet.addAll(ds2);
                ps.add(ds2.getTarget());
                continue;
            }
            if (s instanceof IValueSymbol) {
                String str = ((IValueSymbol)s).stringSymbolValue().value();
                ds2 = DeclarationSets.createDeclarationSet(str, this.getFormulaFactory());
                declSet.addAll(ds2);
                ps.add(ds2.getTarget());
                continue;
            }
            if (this.isRegexp(ty)) {
                this.pushContext(SolverContext.REGEXP);
                try {
                    ds = this.solve(g, (IVariable)s);
                    declSet.addAll(ds);
                    ps.add(ds.getTarget());
                    continue;
                }
                finally {
                    this.popContext();
                }
            }
            ds = this.solve(g, (IVariable)s);
            declSet.addAll(ds);
            ps.add(ds.getTarget());
        }
        return ps;
    }
}

