/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.tomcat;

import com.ibm.appscan.common.xml.XMLFileReader;
import java.io.File;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;

public class ServerXMLReader
extends XMLFileReader {
    private static final String E_SERVICE = "Service";
    private static final String E_ENGINE = "Engine";
    private static final String E_HOST = "Host";
    private static final String A_NAME = "name";
    private static final String A_DEFAULT_HOST = "defaultHost";
    private static final String A_APP_BASE = "appBase";
    private static final String A_UNPACK_WARS = "unpackWARs";
    private boolean inService = false;
    private String defaultHost = null;
    private String m_appBase = "webapps";
    private boolean m_unpackWARs = true;

    ServerXMLReader(File file) {
        super(file);
    }

    protected boolean process(StartElement element) {
        String name = element.getName().getLocalPart();
        if (!this.inService) {
            if (E_SERVICE.equals(name) && "Catalina".equals(this.getAttribute(element, A_NAME))) {
                this.inService = true;
            }
            return true;
        }
        if (this.defaultHost == null) {
            if (E_ENGINE.equals(name)) {
                this.defaultHost = this.getAttribute(element, A_DEFAULT_HOST);
            }
            return true;
        }
        if (E_HOST.equals(name) && this.defaultHost.equals(this.getAttribute(element, A_NAME))) {
            String unpackWARs;
            String appBase = this.getAttribute(element, A_APP_BASE);
            if (appBase != null) {
                this.m_appBase = appBase;
            }
            if ((unpackWARs = this.getAttribute(element, A_UNPACK_WARS)) != null) {
                this.m_unpackWARs = Boolean.parseBoolean(unpackWARs);
            }
            return false;
        }
        return true;
    }

    protected boolean process(EndElement element) {
        String name = element.getName().getLocalPart();
        if (E_SERVICE.equals(name)) {
            this.inService = false;
        } else if (E_ENGINE.equals(name)) {
            this.defaultHost = null;
        }
        return true;
    }

    String getAppBase() {
        return this.m_appBase;
    }

    boolean unpackWARs() {
        return this.m_unpackWARs;
    }
}

