/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.common.utils;

import java.util.List;

public class ConsoleUtil {
    private static final String NEW_LINE = "\n";
    private static final String MARGIN_SPACE = " ";
    private static final String HORIZONTAL_SEPARATOR_CHAR = "-";
    private static final int MAX_COL_WIDTH = 50;

    public static String generateTable(String title, Object[] headers, List<Object[]> data) {
        int[] colWidths = new int[headers.length];
        for (int h = 0; h < headers.length; ++h) {
            colWidths[h] = ((String)headers[h]).length();
        }
        for (Object[] row : data) {
            for (int c = 0; c < row.length; ++c) {
                String cell = (String)row[c];
                if (cell == null || colWidths[c] >= cell.length()) continue;
                colWidths[c] = cell.length() < 50 ? cell.length() : 50;
            }
        }
        StringBuilder formatBuilder = new StringBuilder();
        StringBuilder rowBuilder = new StringBuilder();
        for (int s = 0; s < headers.length; ++s) {
            if (s > 0) {
                rowBuilder.append(MARGIN_SPACE);
                formatBuilder.append(MARGIN_SPACE);
            }
            formatBuilder.append("%-" + colWidths[s] + "." + 50 + "s");
            for (int i = 0; i < colWidths[s]; ++i) {
                if (i >= 50) continue;
                rowBuilder.append(HORIZONTAL_SEPARATOR_CHAR);
            }
            if (s != headers.length - 1) continue;
            formatBuilder.append(NEW_LINE);
        }
        String format = formatBuilder.toString();
        String rowSeparator = rowBuilder.toString();
        StringBuilder table = new StringBuilder();
        table.append(NEW_LINE + (title == null ? "" : title) + NEW_LINE);
        table.append(String.format(format, headers));
        table.append(rowSeparator + NEW_LINE);
        if (data.size() == 0) {
            table.append(String.format(format, new Object[headers.length]));
        } else {
            for (Object[] dataRow : data) {
                for (int d = 0; d < dataRow.length; ++d) {
                    String old = dataRow[d].toString();
                    if (old.length() <= 50) continue;
                    dataRow[d] = old.substring(0, Math.min(old.length(), 47)) + "...";
                }
                table.append(String.format(format, dataRow));
            }
        }
        return table.toString();
    }
}

