/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.tokenizer;

import com.ibm.appscan.assessment.model.Finding;
import com.ibm.appscan.assessment.model.Site;
import com.ibm.appscan.assessment.model.Taint;
import com.ibm.appscan.tokenizer.BaseTokenizer;
import com.ibm.appscan.tokenizer.TokenizerException;
import java.util.ArrayList;

public abstract class BaseFindingTokenizer
extends BaseTokenizer {
    private static final long serialVersionUID = -2960601880209377860L;

    @Override
    protected String getTokenSentence_(Object o) throws TokenizerException {
        if (o instanceof Finding) {
            return this.getFindingSentence_((Finding)o);
        }
        return "";
    }

    protected abstract String getFindingSentence_(Finding var1) throws TokenizerException;

    protected ArrayList<Site> getFindingSites_(Finding f) throws TokenizerException {
        ArrayList<Site> ret = new ArrayList<Site>();
        if (f.getTrace() == null) {
            ret.add(f.getSite());
        } else {
            for (Taint t : f.getTrace().getTaintList()) {
                if (!this.isGoodSite(t.getSite()).booleanValue()) continue;
                ret.add(t.getSite());
            }
        }
        return ret;
    }

    protected Boolean isGoodSite(Site site) {
        if (!(site.getSignature().contains("automatic_external_caller") || site.getSignature().contains("external_source") || site.getSignature().contains("external_caller"))) {
            return true;
        }
        return false;
    }

    public String contextFilteredString(String rawContext) {
        String s = rawContext.replaceAll("[a-zA-Z]+[@][0-9a-zA-Z_$#]*", "");
        s = s.replaceAll("new||output|java lang", "");
        return s;
    }
}

