/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.internal.discovery.aspnet;

import com.hcl.appscan.discovery.aspnet.IAspNetConstants;
import com.hcl.appscan.internal.discovery.aspnet.AspNetStrategy;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.model.StringPattern;
import com.ibm.appscan.discovery.dir.BaseCustomCollector;
import com.ibm.appscan.discovery.dir.FileCollectorStrategy;
import java.io.File;
import java.util.Set;

public class AspNetCollector
extends BaseCustomCollector
implements IAspNetConstants {
    public AspNetCollector(File crawlRoot, Set<StringPattern> includes, Set<StringPattern> excludes) {
        super(crawlRoot, includes, excludes);
    }

    public String getType() {
        return "AspNetCollector";
    }

    protected String getFileExtensionSetName() {
        return "asp.net";
    }

    protected boolean acceptFile(File file) {
        return file.getName().equalsIgnoreCase("web.config") || super.acceptFile(file);
    }

    protected ScanTargetStrategy getScanTargetStrategy(ScanTargetStrategy parentStrategy) {
        String root = this.getCrawlRoot().getAbsolutePath();
        if (parentStrategy != null && parentStrategy instanceof FileCollectorStrategy) {
            root = ((FileCollectorStrategy)parentStrategy).getStagingDirectory().getAbsolutePath();
        }
        return new AspNetStrategy(root, this.getScanFiles());
    }
}

