/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.config.handlers;

import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.cli.config.Messages;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.PackageUtil;
import com.ibm.appscan.common.utils.WebServiceUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;

public class PackageHandler {
    private static String USER_DIR = System.getProperty("user.dir");
    private ProgressAdapter m_progress = new ProgressAdapter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void packFile(String name, String saveLocation, String fileExtension, String path) {
        Message message;
        if (path == null) {
            path = System.getProperty("user.dir");
        }
        if (saveLocation != null && new File(saveLocation).isFile()) {
            Message status = new Message(4, Messages.INVALID_SAVE_LOCATION);
            this.m_progress.setStatus(status);
            return;
        }
        File inputFile = new File(path);
        if (!inputFile.exists()) {
            Message message2 = new Message(4, Messages.bind(Messages.ERR_PACKAGE_NOT_FOUND, path));
            CommonCLICore.getLogManager().log(message2);
            CommonCLICore.getIOConsole().println(message2);
            return;
        }
        if (inputFile.isDirectory()) {
            File[] discoveredFiles = PackageHandler.findFiles(inputFile, fileExtension);
            if (discoveredFiles.length > 1) {
                message = new Message(4, Messages.ERR_PACKAGE_MULTIPLE);
                CommonCLICore.getLogManager().log(message);
                CommonCLICore.getIOConsole().println(message);
            } else if (discoveredFiles.length < 1) {
                message = new Message(4, Messages.ERR_PACKAGE_NONE);
                CommonCLICore.getLogManager().log(message);
                CommonCLICore.getIOConsole().println(message);
            } else {
                inputFile = discoveredFiles[0];
            }
        }
        if (inputFile.isFile() && inputFile.getName().endsWith(fileExtension)) {
            File destination;
            CommonCLICore.getIOConsole().println(new Message(1, Messages.JOB_PACKAGE));
            if (name == null) {
                name = inputFile.getName();
            }
            if (!name.endsWith(".irx")) {
                int idx = name.lastIndexOf(".");
                if (idx >= 0 && fileExtension.matches(name.substring(idx))) {
                    name = name.substring(0, idx);
                }
                name = name + ".irx";
            }
            if ((destination = this.getSaveFile(saveLocation, name)).isFile()) {
                Message status = new Message(4, Messages.bind(Messages.SAVE_LOCATION_EXIST, destination.getAbsolutePath()));
                this.m_progress.setStatus(status);
                return;
            }
            if (!WebServiceUtil.isValidFilename((String)destination.getName())) {
                message = new Message(4, Messages.bind(Messages.INPUT_CONTAINS_INVALID_CHARS, destination.getName()));
                this.m_progress.setStatus(message);
                return;
            }
            boolean packageSuccess = true;
            try {
                PackageUtil.pack((File)inputFile, (File)destination);
            }
            catch (IOException e) {
                packageSuccess = false;
                CommonCLICore.getLogManager().log(new Message((Throwable)e));
                CommonCLICore.getIOConsole().println(new Message(4, Messages.PACKAGE_ASSESSMENTS_NOT_OK));
            }
            finally {
                if (packageSuccess) {
                    CommonCLICore.getLogManager().log(new Message(1, Messages.PACKAGE_ASSESSMENTS_OK));
                    CommonCLICore.getIOConsole().println(Messages.PACKAGE_ASSESSMENTS_OK);
                }
            }
        }
    }

    private static File[] findFiles(File directory, final String extension) {
        File[] sourceFiles = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file == null || !file.isFile() || !file.exists()) {
                    return false;
                }
                return PackageHandler.checkFileExtension(file, extension);
            }
        });
        return sourceFiles;
    }

    private static boolean checkFileExtension(File file, String extension) {
        if (extension == null) {
            return true;
        }
        String name = file.getName().toLowerCase();
        return name.endsWith(extension);
    }

    private File getSaveFile(String saveLocation, String filename) {
        if (saveLocation == null) {
            saveLocation = USER_DIR;
        }
        File saveDir = new File(saveLocation);
        if (!filename.endsWith(".irx")) {
            filename = filename + ".irx";
        }
        saveDir.mkdirs();
        return new File(saveDir, filename);
    }
}

