/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.config.handlers;

import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.cli.config.Messages;
import com.ibm.appscan.cli.config.components.ScanManager;
import com.ibm.appscan.cli.config.handlers.ConfigurationHandler;
import com.ibm.appscan.cli.config.handlers.CreateHandler;
import com.ibm.appscan.cli.config.handlers.DiscoveryHandler;
import com.ibm.appscan.cli.config.handlers.SaveHandler;
import com.ibm.appscan.cli.config.handlers.TransformHandler;
import com.ibm.appscan.cli.config.handlers.ValidateHandler;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.logging.stats.MergedStatsWriter;
import com.ibm.appscan.common.model.IScanTarget;
import com.ibm.appscan.common.model.ProgressTracker;
import com.ibm.appscan.common.model.SaveLocation;
import com.ibm.appscan.common.model.validation.IValidationIssue;
import com.ibm.appscan.common.model.xml.IModelXMLConstants;
import com.ibm.appscan.common.utils.FileUtil;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.KeyUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.common.utils.VersionUtil;
import com.ibm.appscan.common.utils.WebServiceUtil;
import com.ibm.appscan.config.Configurator;
import com.ibm.appscan.internal.cli.config.IRGenProgressTracker;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public class PrepareHandler
implements IModelXMLConstants {
    private static String USER_DIR = System.getProperty("user.dir");
    private static final String DEFAULT_CONFIG = USER_DIR + File.separator + "appscan-config" + ".xml";
    private IProgress m_progress = null;
    private File m_saveFile = null;
    private Map<String, Boolean> m_targetsToDiscover = null;
    private ConfigurationHandler m_configHandler = null;
    private CreateHandler m_createHandler = null;
    private SaveHandler m_saveHandler = null;
    private DiscoveryHandler m_discoveryHandler = null;
    private ValidateHandler m_validateHandler = null;
    private TransformHandler m_transformHandler = null;

    public PrepareHandler() {
        this(null);
    }

    public PrepareHandler(IProgress progress) {
        this.initializeHandlers(progress);
        this.m_progress = progress == null ? new ProgressAdapter() : progress;
    }

    private void initializeHandlers(IProgress progress) {
        this.m_configHandler = new ConfigurationHandler();
        this.m_createHandler = new CreateHandler();
        this.m_saveHandler = new SaveHandler();
        this.m_discoveryHandler = new DiscoveryHandler();
        this.m_validateHandler = new ValidateHandler(progress);
        this.m_transformHandler = new TransformHandler();
    }

    public void setDryRun(boolean dryRun) {
        if (dryRun) {
            System.setProperty("dryRun", "");
        }
    }

    public int configure(String filename, String saveLocation, String logLocation, String inputConfigFile) {
        if (SystemUtil.isDryRun()) {
            System.setProperty("DELETE_IRX", "");
        }
        int rc = 0;
        filename = this.getWorkingName(filename);
        if (!(SystemUtil.isDryRun() || this.versionCheck() && this.checkPublicKey() && filename != null)) {
            return rc;
        }
        this.m_saveFile = this.getSaveFile(saveLocation, filename);
        if (saveLocation != null && new File(saveLocation).isFile()) {
            Message status = new Message(4, Messages.INVALID_SAVE_LOCATION);
            this.m_progress.setStatus(status);
            return -1;
        }
        if (this.m_saveFile.isFile()) {
            Message status = new Message(4, Messages.bind(Messages.SAVE_LOCATION_EXIST, this.m_saveFile.getAbsolutePath()));
            this.m_progress.setStatus(status);
            return -1;
        }
        System.setProperty("IRX_NAME", FileUtil.getBaseName((File)this.m_saveFile));
        System.setProperty("IRX_LOCATION", this.m_saveFile.getParent());
        if (logLocation != null) {
            this.m_transformHandler.setLogDir(new File(logLocation));
        }
        File configFile = null;
        configFile = inputConfigFile == null ? new File(DEFAULT_CONFIG) : new File(inputConfigFile);
        CF_STATUS status = this.validateConfigFile(configFile, inputConfigFile != null);
        rc = status == CF_STATUS.VALID && this.m_configHandler.isValidConfigFile(configFile) ? this.prepareIR(configFile) : (status == CF_STATUS.NOT_FOUND && inputConfigFile == null ? this.prepareIR(null) : -1);
        return rc;
    }

    public boolean isValidFlagCombination() {
        boolean invalidCombo5;
        boolean invalidCombo1 = SystemUtil.isSecretsOnly() && SystemUtil.isOpenSourceOnly();
        boolean invalidCombo2 = SystemUtil.isOpenSourceOnly() && SystemUtil.isStaticAnalysisOnly();
        boolean invalidCombo3 = SystemUtil.isSecretsOnly() && SystemUtil.isSecretsScanningDisabled();
        boolean invalidCombo4 = SystemUtil.isSecretsOnly() && SystemUtil.isOpenSourceOnly() && SystemUtil.isStaticAnalysisOnly();
        boolean bl = invalidCombo5 = SystemUtil.isSecretsScanningDisabled() && SystemUtil.isSecretsScanningEnabled();
        if (invalidCombo4) {
            return this.handleInvalidCombination("Secrets Only", "Open Source Only", "Static Analysis Only");
        }
        if (invalidCombo1) {
            return this.handleInvalidCombination("Secrets Only", "Open Source Only");
        }
        if (invalidCombo2) {
            return this.handleInvalidCombination("Open Source Only", "Static Analysis Only");
        }
        if (invalidCombo3) {
            return this.handleInvalidCombination("Secrets Only", "Disable Secrets");
        }
        if (invalidCombo5) {
            return this.handleInvalidCombination("Disable Secrets", "Enable Secrets");
        }
        return true;
    }

    private boolean handleInvalidCombination(String arg1, String arg2) {
        return this.handleInvalidCombination(arg1, arg2, null);
    }

    private boolean handleInvalidCombination(String arg1, String arg2, String arg3) {
        String message = arg3 == null ? Messages.bind(Messages.INVALID_FLAG_COMBINATION, arg1, arg2) : Messages.bind(Messages.INVALID_FLAG_COMBINATION, arg1 + ", " + arg2, arg3);
        Message status = new Message(4, message);
        this.m_progress.setStatus(status);
        return false;
    }

    private int prepareIR(File config) {
        int rc = 0;
        long prepareStart = System.currentTimeMillis();
        this.m_createHandler.createScan();
        this.logClientInformation();
        this.m_targetsToDiscover = this.m_configHandler.read(config);
        int targetsFound = 0;
        if (!this.isValidFlagCombination()) {
            return rc;
        }
        if (this.m_targetsToDiscover != null && !this.m_targetsToDiscover.isEmpty()) {
            if (!SystemUtil.useStagerForJavaFiles() && SystemUtil.useSlicerForJavaFiles() && this.m_progress != null) {
                ScanManager.getInstance().getActiveScan().getLogManager().log(new Message(2, Messages.bind(Messages.STAGE_OFF_SLICE_ON, new Object[0])));
            }
            targetsFound = this.m_discoveryHandler.discover(this.m_targetsToDiscover);
        }
        if (targetsFound < 1) {
            this.m_progress.setStatus(new Message(2, Messages.DISCOVER_NO_FILES));
            rc = -1;
        } else {
            this.m_saveHandler.saveAs(this.m_saveFile.getPath());
            this.copyConfigFileToLogs(config);
            this.m_validateHandler.setConfigDir(config == null ? new File(USER_DIR) : config.getParentFile());
            boolean isValid = this.m_validateHandler.validate();
            if (isValid && !SystemUtil.isDryRun()) {
                IProgress progressTracker = this.initializeProgressTracker();
                if (config != null) {
                    this.m_transformHandler.setConfigDir(config.getParentFile());
                }
                rc = this.m_transformHandler.transform(progressTracker);
                if (progressTracker instanceof ProgressTracker) {
                    ((ProgressTracker)progressTracker).setComplete();
                }
                CommonCLICore.getLogManager().log(new Message(1, Messages.bind(Messages.GENERATE_RC, rc)));
                this.printNamespaces();
                try {
                    MergedStatsWriter writer = new MergedStatsWriter(ScanManager.getInstance().getActiveScan().getSaveLocation().getWorkLocation());
                    writer.getMetric("TotalPrepareTimeMS").addMetricValue(String.valueOf(System.currentTimeMillis() - prepareStart));
                    writer.saveXml();
                }
                catch (IOException | ParserConfigurationException | TransformerException e) {
                    CommonCore.getLogManager().log(e);
                }
                if (rc == 1 && !this.m_configHandler.fileExists() && !this.m_transformHandler.getMissingDependencies().isEmpty()) {
                    this.m_configHandler.create();
                }
            } else {
                this.printNamespaces();
                this.printValidationIssues(isValid);
                if (!SystemUtil.isDryRun()) {
                    rc = -1;
                }
                try {
                    new Configurator(ScanManager.getInstance().getActiveScan()).zipLogs();
                }
                catch (IOException e) {
                    CommonCore.getLogManager().log((Exception)e);
                }
            }
        }
        return rc;
    }

    private void logClientInformation() {
        String irGenClient = SystemUtil.getIRGenClient();
        String operatingSystem = System.getProperty("os.name");
        String appscanVersion = VersionUtil.getLocalToolsVersion();
        String clientVersion = SystemUtil.getClientVersion();
        clientVersion = clientVersion != null ? clientVersion : "";
        Message message = new Message(1, Messages.bind(Messages.APPSCAN_IRGEN_CLIENT, irGenClient, clientVersion, appscanVersion, operatingSystem));
        ScanManager.getInstance().getActiveScan().getLogManager().log(message);
        CommonCLICore.getLogManager().log(message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getWorkingName(String filename) {
        if (filename == null) {
            File directory = new File(USER_DIR);
            if (WebServiceUtil.isValidFilename((String)directory.getName())) {
                return this.generateFileName(USER_DIR);
            }
            String validName = WebServiceUtil.getValidFilename((String)directory.getName());
            if (validName != null && validName.length() > 0) {
                return this.generateFileName(validName);
            }
            Message message = new Message(4, Messages.bind(Messages.INPUT_CONTAINS_INVALID_CHARS, directory.getName()));
            this.m_progress.setStatus(message);
            return null;
        }
        if (WebServiceUtil.isValidFilename((String)filename)) return filename;
        Message message = new Message(4, Messages.bind(Messages.INPUT_CONTAINS_INVALID_CHARS, filename));
        this.m_progress.setStatus(message);
        return null;
    }

    private String generateFileName(String directoryName) {
        String filename = null;
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        String timestamp = sdf.format(date);
        filename = new File(directoryName).getName();
        filename = filename + "_" + timestamp;
        return filename;
    }

    private File getSaveFile(String saveLocation, String filename) {
        String irxPath;
        if (saveLocation == null) {
            saveLocation = USER_DIR;
        }
        if (!saveLocation.endsWith(File.separator)) {
            saveLocation = saveLocation + File.separator;
        }
        if (!(irxPath = saveLocation + filename).endsWith(".irx")) {
            irxPath = irxPath + ".irx";
        }
        return new File(irxPath);
    }

    private CF_STATUS validateConfigFile(File configFile, boolean userSpecified) {
        CF_STATUS status = null;
        if (configFile.isDirectory()) {
            this.m_progress.setStatus(new Message(4, Messages.bind(Messages.INVALID_CONFIGURATION_FILE_SPECIFIED, configFile.getPath())));
            return CF_STATUS.INVALID;
        }
        if (!configFile.exists()) {
            if (userSpecified) {
                this.m_progress.setStatus(new Message(2, Messages.bind(Messages.CONFIGURATION_FILE_NOT_FOUND, configFile.getPath())));
            }
            status = CF_STATUS.NOT_FOUND;
        } else {
            this.m_progress.setStatus(new Message(1, Messages.bind(Messages.CONFIGURATION_FILE_FOUND, configFile.getPath())));
            this.m_progress.setStatus(new Message(1, Messages.PROCESSING_CONFIGURATION_FILE));
            status = CF_STATUS.VALID;
        }
        return status;
    }

    private boolean versionCheck() {
        if (CommonCore.getConfiguration().getSettingValueBooleanDefaultFalse("DisableVersionCheck")) {
            return true;
        }
        String localVersion = VersionUtil.getLocalToolsVersion();
        String serverVersion = VersionUtil.getServerToolsVersion();
        if (localVersion == null || serverVersion == null) {
            CommonCLICore.getIOConsole().println(new Message(2, Messages.ERR_VERSION_CHECK_FAILED));
        } else if (!VersionUtil.isLatest((String)localVersion)) {
            int localState = VersionUtil.compareWithLatest((String)localVersion);
            if (localState == 2 || localState == 1) {
                Message message = new Message(2, Messages.bind(Messages.WARN_VERSION_MISMATCH, VersionUtil.getUtilityDownloadURL()));
                CommonCLICore.getIOConsole().println(message);
            } else if (localState == 3) {
                Message message = new Message(4, Messages.bind(Messages.ERR_VERSION_MISMATCH, VersionUtil.getUtilityDownloadURL()));
                CommonCLICore.getIOConsole().println(message);
                return false;
            }
        }
        return true;
    }

    private boolean checkPublicKey() {
        Message message;
        if (!SystemUtil.shouldEncrypt()) {
            return true;
        }
        boolean success = false;
        if (!KeyUtil.updatePublicKey()) {
            message = new Message(2, Messages.PUBLICKEY_UPDATE_NOT_OK);
            CommonCLICore.getIOConsole().println(message);
        }
        if (new File(CommonCore.getDirectoryLocator().getConfig() + "rsa.pub").exists()) {
            success = true;
        } else {
            message = new Message(4, Messages.PUBLICKEY_NOT_FOUND);
            CommonCLICore.getIOConsole().println(message);
        }
        return success;
    }

    private void copyConfigFileToLogs(File configFile) {
        try {
            SaveLocation location = ScanManager.getInstance().getActiveScan().getSaveLocation();
            if (configFile == null || !configFile.isFile() || location == null) {
                return;
            }
            File logDir = new File(location.getWorkLocation(), "logs");
            if (!logDir.isDirectory()) {
                logDir.mkdirs();
            }
            File destFile = new File(logDir, configFile.getName());
            IOUtil.copy((File)configFile, (File)destFile);
        }
        catch (IOException e) {
            CommonCLICore.getLogManager().log(new Message(Messages.FAILED_COPYING_CONFIG_FILE, (Throwable)e));
        }
    }

    private void printValidationIssues(boolean isValid) {
        ArrayList<IValidationIssue> issues = new ArrayList<IValidationIssue>();
        ProgressAdapter progress = new ProgressAdapter(ScanManager.getInstance().getActiveScan());
        for (Object target : ScanManager.getInstance().getActiveScan().getScanTargets()) {
            issues.addAll(this.getTargetIssues((IScanTarget)target));
        }
        if (!issues.isEmpty()) {
            TreeSet<String> issueText = new TreeSet<String>();
            for (IValidationIssue issue : issues) {
                issueText.add(issue.getIssueText());
            }
            String validationIssues = Messages.VALIDATE_PROBLEMS_FOUND;
            for (String issue : issueText) {
                validationIssues = validationIssues + "\n\t" + issue;
            }
            progress.setStatus(new Message(2, validationIssues));
        }
        if (isValid && issues.isEmpty()) {
            progress.setStatus(new Message(2, Messages.VALIDATE_OK));
        }
    }

    private Collection<IValidationIssue> getTargetIssues(IScanTarget target) {
        Collection issues = target.getValidationIssues();
        if (target.getChildren() != null) {
            for (IScanTarget child : target.getChildren()) {
                issues.addAll(this.getTargetIssues(child));
            }
        }
        return issues;
    }

    private void printNamespaces() {
        TreeSet<String> namespaces = new TreeSet<String>();
        ProgressAdapter progress = new ProgressAdapter(ScanManager.getInstance().getActiveScan());
        for (IScanTarget target : ScanManager.getInstance().getActiveScan().getScanTargets()) {
            namespaces.addAll(this.findNameSpaces(target));
        }
        if (!namespaces.isEmpty()) {
            String namespacesList = Messages.PKG_LIST_START_MESSAGE;
            for (String namespace : namespaces) {
                namespacesList = namespacesList + "\n\t" + namespace;
            }
            progress.setStatus(new Message(1, namespacesList));
        }
    }

    private Collection<String> findNameSpaces(IScanTarget target) {
        Collection namespaces = target.getNameSpaces();
        if (target.getChildren() != null) {
            for (IScanTarget t : target.getChildren()) {
                namespaces.addAll(this.findNameSpaces(t));
            }
        }
        return namespaces;
    }

    private IProgress initializeProgressTracker() {
        if (this.m_progress instanceof ProgressTracker) {
            IRGenProgressTracker tracker = new IRGenProgressTracker(this.m_progress, ScanManager.getInstance().getActiveScan());
            ((ProgressTracker)this.m_progress).addChildTracker((ProgressTracker)tracker);
            return tracker;
        }
        return new ProgressAdapter(ScanManager.getInstance().getActiveScan());
    }

    private static enum CF_STATUS {
        VALID,
        INVALID,
        NOT_FOUND;

    }
}

