/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.cli.config;

import com.ibm.appscan.cli.config.Messages;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.ProgressTracker;
import com.ibm.appscan.internal.cli.config.SastServicesProgressTracker;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IRGenProgressTracker
extends ProgressTracker
implements IProgress {
    private static final Pattern m_pattern = Pattern.compile("\\([0-9]+%\\)");
    private IProgress m_parent;

    public IRGenProgressTracker(IProgress parentProgress, IScan scan) {
        super(100);
        this.m_parent = parentProgress;
    }

    public void setStatus(Message status) {
        if (status.getText().startsWith(Messages.PROCESSED)) {
            this.updateProgress(status.getText());
        }
        this.m_parent.setStatus(status);
    }

    public void resetStatus() {
    }

    public boolean isCanceled() {
        return false;
    }

    private void updateProgress(String message) {
        Matcher matcher = m_pattern.matcher(message);
        if (matcher.find()) {
            String percentComplete = matcher.group();
            try {
                int percent = Integer.parseInt(percentComplete.substring(1, percentComplete.length() - 2));
                if (percent == 100) {
                    this.setComplete();
                    if (this.m_parent instanceof SastServicesProgressTracker) {
                        ((SastServicesProgressTracker)this.m_parent).setComplete();
                    }
                } else {
                    while (this.getPercentComplete() < percent) {
                        this.unitCompleted();
                    }
                }
            }
            catch (NumberFormatException e) {
                return;
            }
        }
    }
}

