/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.cli.config;

import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.cli.config.Messages;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.ProgressTracker;
import com.ibm.appscan.common.utils.SystemUtil;

public class SastServicesProgressTracker
extends ProgressTracker
implements IProgress {
    private static final int SLEEP_INTERVAL = SystemUtil.getUpdateServerInterval() * 1000;
    private Thread m_thread = null;
    private transient boolean m_stop = false;
    private ProgressAdapter progressAdapter = new ProgressAdapter();

    public SastServicesProgressTracker() {
        super(0);
        this.beginLongProcess();
    }

    public void setStatus(Message status) {
        this.progressAdapter.setStatus(status);
    }

    public void resetStatus() {
        this.progressAdapter.resetStatus();
    }

    public boolean isCanceled() {
        return this.progressAdapter.isCanceled();
    }

    public synchronized void beginLongProcess() {
        if (this.m_thread == null) {
            this.m_stop = false;
            this.m_thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(SLEEP_INTERVAL);
                                SastServicesProgressTracker.this.setStatus(new Message(1, Messages.PROCESSED + " (" + SastServicesProgressTracker.this.getPercentComplete() + "%)"));
                            }
                        }
                        catch (InterruptedException e) {
                            if (!SastServicesProgressTracker.this.m_stop) continue;
                            return;
                        }
                        catch (Exception e) {
                            SastServicesProgressTracker.this.setStatus(new Message(4, "Unexpected exception occurred: " + e.toString()));
                            continue;
                        }
                        break;
                    }
                }
            });
            this.m_thread.start();
        }
    }

    public synchronized void endLongProcess() {
        if (this.m_thread != null) {
            this.m_stop = true;
            this.m_thread.interrupt();
            this.m_thread = null;
        }
    }

    public void setComplete() {
        super.setComplete();
        this.endLongProcess();
    }
}

