/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.client;

import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IVariableFactory;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.impl.BasicCallGraph;
import com.ibm.wala.ipa.callgraph.impl.ExplicitCallGraph;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.slicer.NormalStatement;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.stringAnalysis.client.IGrammarBasedStringAnalyzer;
import com.ibm.wala.stringAnalysis.grammar.GR;
import com.ibm.wala.stringAnalysis.slicer.CGFilter;
import com.ibm.wala.stringAnalysis.slicer.DelegatingCallGraph;
import com.ibm.wala.stringAnalysis.translator.IConstraintSolver;
import com.ibm.wala.stringAnalysis.translator.IRuleModifier;
import com.ibm.wala.stringAnalysis.translator.ITranslatorRepository;
import com.ibm.wala.util.MonitorUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public abstract class SliceStringAnalyzer<T>
implements IGrammarBasedStringAnalyzer<T> {
    private final BasicCallGraph bcg;
    private final IGrammarBasedStringAnalyzer<T> baseAnalyzer;
    private final Collection<Statement> slice = new HashSet<Statement>();

    public SliceStringAnalyzer(Iterator<Statement> slice, ExplicitCallGraph cg, PointerAnalysis pa, AnalysisOptions options, MonitorUtil.IProgressMonitor monitor) {
        this.bcg = this.createPartialCallGraph(slice, cg, options);
        this.baseAnalyzer = this.createStringAnalyzer(this.bcg, pa, cg.getClassHierarchy(), options, monitor);
    }

    protected abstract IGrammarBasedStringAnalyzer<T> createStringAnalyzer(BasicCallGraph var1, PointerAnalysis var2, IClassHierarchy var3, AnalysisOptions var4, MonitorUtil.IProgressMonitor var5);

    private BasicCallGraph createPartialCallGraph(Iterator<Statement> slice, ExplicitCallGraph cg, AnalysisOptions options) {
        Collection<CGNode> sliceNodes = this.extractSliceNodes(slice);
        DelegatingCallGraph partialCG = new DelegatingCallGraph(cg, new CGFilter(sliceNodes), cg.getClassHierarchy(), options, cg.getAnalysisCache());
        return partialCG;
    }

    private Collection<CGNode> extractSliceNodes(Iterator<Statement> slice) {
        HashSet<CGNode> allNodes = new HashSet<CGNode>();
        while (slice.hasNext()) {
            Statement stmt = slice.next();
            this.slice.add(stmt);
            allNodes.add(stmt.getNode());
        }
        return allNodes;
    }

    @Override
    public void addRuleModifier(IRuleModifier appender) {
        this.baseAnalyzer.addRuleModifier(appender);
    }

    @Override
    public CallGraph getCallGraph() {
        return this.bcg;
    }

    public Collection<Statement> getSlice() {
        return this.slice;
    }

    public Collection<SSAInstruction> getSelectedInstructions() {
        HashSet<SSAInstruction> instructions = new HashSet<SSAInstruction>();
        for (Statement s : this.getSlice()) {
            if (!(s instanceof NormalStatement)) continue;
            NormalStatement ns = (NormalStatement)s;
            instructions.add(ns.getInstruction());
        }
        return instructions;
    }

    @Override
    public GR getGR() {
        return this.baseAnalyzer.getGR();
    }

    @Override
    public PointerAnalysis getPointerAnalysis() {
        return this.baseAnalyzer.getPointerAnalysis();
    }

    @Override
    public ITranslatorRepository<T> getRepository() {
        return this.baseAnalyzer.getRepository();
    }

    @Override
    public IVariableFactory<IVariable> getVariableFactory() {
        return this.baseAnalyzer.getVariableFactory();
    }

    @Override
    public IConstraintSolver<T> getSolver() {
        return this.baseAnalyzer.getSolver();
    }

    @Override
    public Map<IVariable, T> infer(Collection<? extends IVariable> vars) {
        return this.baseAnalyzer.infer(vars);
    }
}

