/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.condition;

import com.ibm.wala.automaton.DMap;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.cfg.Util;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.stringAnalysis.condition.IPathCondition;
import com.ibm.wala.stringAnalysis.condition.IPathConditionAnalysis;
import com.ibm.wala.stringAnalysis.condition.ISymbolicCondition;
import com.ibm.wala.stringAnalysis.condition.ISymbolicMergeCondition;
import com.ibm.wala.stringAnalysis.condition.PathCondition;
import com.ibm.wala.stringAnalysis.condition.SymbolicCaseCondition;
import com.ibm.wala.stringAnalysis.condition.SymbolicDefaultCaseCondition;
import com.ibm.wala.stringAnalysis.condition.SymbolicNotTakenCondition;
import com.ibm.wala.stringAnalysis.condition.SymbolicTakenCondition;
import com.ibm.wala.util.debug.UnimplementedError;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SymbolicPathConditionAnalysis
implements IPathConditionAnalysis {
    private CGNode node;
    private IR ir;
    private SSACFG cfg;
    private Map<ISSABasicBlock, Collection<ISymbolicCondition>> symbolicCondition;
    private Map<ISSABasicBlock, IPathCondition> pathCondition;
    private static boolean useGetBlockForInstruction = true;

    public SymbolicPathConditionAnalysis(CGNode node) {
        this.node = node;
        this.ir = node.getIR();
        this.cfg = this.ir.getControlFlowGraph();
        this.symbolicCondition = new HashMap<ISSABasicBlock, Collection<ISymbolicCondition>>();
        this.pathCondition = new DMap<ISSABasicBlock, IPathCondition>(){

            protected IPathCondition create(ISSABasicBlock key) {
                Collection sc = (Collection)SymbolicPathConditionAnalysis.this.symbolicCondition.get(key);
                PathCondition pathCond = new PathCondition();
                for (ISymbolicCondition s : sc) {
                    pathCond.and(s.pathCondition());
                }
                return pathCond;
            }
        };
        this.calculateSymbolicCondition((ISSABasicBlock)this.cfg.getBlockForInstruction(0), Collections.emptySet());
    }

    protected Collection<ISymbolicCondition> createSymbolicConditions(Collection<ISymbolicCondition> c) {
        HashSet<ISymbolicMergeCondition> mergeConds = new HashSet<ISymbolicMergeCondition>();
        Collection<ISymbolicCondition> conds = new HashSet<ISymbolicCondition>();
        for (ISymbolicCondition s : c) {
            if (s instanceof ISymbolicMergeCondition) {
                mergeConds.add((ISymbolicMergeCondition)s);
                continue;
            }
            conds.add(s);
        }
        for (ISymbolicMergeCondition m : mergeConds) {
            conds = m.merge(conds);
        }
        return conds;
    }

    protected void calculateSymbolicCondition(ISSABasicBlock bb, Collection<ISymbolicCondition> c) {
        if (this.symbolicCondition.containsKey(bb)) {
            return;
        }
        this.symbolicCondition.put(bb, this.createSymbolicConditions(c));
        int lastIndex = bb.getLastInstructionIndex();
        if (lastIndex < 0) {
            Iterator iter = this.cfg.getSuccNodes(bb);
            while (iter.hasNext()) {
                ISSABasicBlock succ = (ISSABasicBlock)iter.next();
                this.calculateSymbolicCondition(succ, c);
            }
            return;
        }
        SSAInstruction last = this.ir.getInstructions()[lastIndex];
        if (last instanceof SSAConditionalBranchInstruction) {
            SSAConditionalBranchInstruction bi = (SSAConditionalBranchInstruction)last;
            ISSABasicBlock thenBlock = (ISSABasicBlock)Util.getTakenSuccessor((ControlFlowGraph)this.cfg, (IBasicBlock)bb);
            ISSABasicBlock elseBlock = (ISSABasicBlock)Util.getNotTakenSuccessor((ControlFlowGraph)this.cfg, (IBasicBlock)bb);
            Collection<ISymbolicCondition> thenCond = this.createSymbolicConditions(c);
            Collection<ISymbolicCondition> elseCond = this.createSymbolicConditions(c);
            thenCond.add(new SymbolicTakenCondition(this.node, bi));
            elseCond.add(new SymbolicNotTakenCondition(this.node, bi));
            this.calculateSymbolicCondition(thenBlock, thenCond);
            this.calculateSymbolicCondition(elseBlock, elseCond);
        } else if (last instanceof SSASwitchInstruction) {
            SSASwitchInstruction si = (SSASwitchInstruction)last;
            int[] caseAndLabels = si.getCasesAndLabels();
            for (int i = 0; i < caseAndLabels.length; ++i) {
                int caseValue = caseAndLabels[i];
                int index = caseAndLabels[++i];
                SSACFG.BasicBlock succ = this.getBlockForIndex(index);
                Collection<ISymbolicCondition> c2 = this.createSymbolicConditions(c);
                c2.add(new SymbolicCaseCondition(this.node, si, caseValue));
                this.calculateSymbolicCondition((ISSABasicBlock)succ, c2);
            }
            SSACFG.BasicBlock defaultBlock = this.getBlockForIndex(si.getDefault());
            Collection<ISymbolicCondition> dc = this.createSymbolicConditions(c);
            dc.add(new SymbolicDefaultCaseCondition(this.node, si));
            this.calculateSymbolicCondition((ISSABasicBlock)defaultBlock, dc);
        } else {
            Iterator iter = this.cfg.getSuccNodes(bb);
            while (iter.hasNext()) {
                ISSABasicBlock succ = (ISSABasicBlock)iter.next();
                this.calculateSymbolicCondition(succ, c);
            }
        }
    }

    @Override
    public IPathCondition getCondition(ISSABasicBlock block) {
        return this.pathCondition.get(block);
    }

    private SSACFG.BasicBlock getBlockForIndex(int index) {
        if (useGetBlockForInstruction) {
            return this.cfg.getBlockForInstruction(index);
        }
        return this.cfg.getBasicBlock(index);
    }

    @Override
    public List<IPathCondition> getConditions(ISSABasicBlock block) {
        throw new UnimplementedError();
    }
}

