/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.condition.dnf;

import com.ibm.wala.stringAnalysis.condition.ConjunctiveCondition;
import com.ibm.wala.stringAnalysis.condition.IPrimitiveCondition;
import com.ibm.wala.stringAnalysis.condition.dnf.Term;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public class Conjuction {
    private final IPrimitiveCondition[] conditions;

    public static Conjuction make(IPrimitiveCondition[] conditions) {
        if (Conjuction.hasContradiction(conditions)) {
            return null;
        }
        TreeSet<IPrimitiveCondition> s = new TreeSet<IPrimitiveCondition>(new Comparator<IPrimitiveCondition>(){

            @Override
            public int compare(IPrimitiveCondition o1, IPrimitiveCondition o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        s.addAll(Arrays.asList(conditions));
        int size = s.size();
        if (size != conditions.length) {
            conditions = new IPrimitiveCondition[size];
        }
        s.toArray(conditions);
        return new Conjuction(conditions);
    }

    private static boolean hasContradiction(IPrimitiveCondition[] conditions) {
        for (int i = 0; i < conditions.length; ++i) {
            IPrimitiveCondition pc1 = conditions[i];
            if (!pc1.isContrary(Arrays.asList(conditions))) continue;
            return true;
        }
        return false;
    }

    private Conjuction(IPrimitiveCondition[] conjunctions) {
        this.conditions = conjunctions;
    }

    public Conjuction and(IPrimitiveCondition primCondition) {
        return this.and(Conjuction.make(new IPrimitiveCondition[]{primCondition}));
    }

    public Conjuction and(Conjuction conjuction) {
        int m = this.conditions.length;
        int n = conjuction.conditions.length;
        IPrimitiveCondition[] newConjunctions = new IPrimitiveCondition[m + n];
        System.arraycopy(this.conditions, 0, newConjunctions, 0, m);
        System.arraycopy(conjuction.conditions, 0, newConjunctions, m, n);
        return Conjuction.make(newConjunctions);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        boolean first = true;
        for (int i = 0; i < this.conditions.length; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(" and ");
            }
            sb.append(this.conditions[i]);
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.conditions);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Conjuction other = (Conjuction)obj;
        return Arrays.equals(this.conditions, other.conditions);
    }

    public Collection<IPrimitiveCondition> getAllPrimitiveConditions() {
        return Arrays.asList(this.conditions);
    }

    public ConjunctiveCondition toConjunctiveCondition() {
        List<IPrimitiveCondition> asList = Arrays.asList(this.conditions);
        return new ConjunctiveCondition((Collection<? extends IPrimitiveCondition>)asList);
    }

    public Term toTerm(List<IPrimitiveCondition> baseConditions) {
        byte[] termVals = new byte[baseConditions.size()];
        int i = 0;
        for (IPrimitiveCondition pc : baseConditions) {
            IPrimitiveCondition notPc = pc.inverse();
            termVals[i] = 2;
            for (IPrimitiveCondition pc1 : this.conditions) {
                if (pc.equals(pc1)) {
                    termVals[i] = 1;
                    break;
                }
                if (!notPc.equals(pc1)) continue;
                termVals[i] = 0;
                break;
            }
            ++i;
        }
        Term ret = new Term(termVals);
        return ret;
    }

    public boolean isTrue() {
        return this.conditions.length == 0;
    }
}

