/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.grammar;

import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.VariableWrapper;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.stringAnalysis.util.SAUtil;

public class UpdatedObject
extends VariableWrapper
implements IVariable {
    private IR ir;
    private int pc;

    public UpdatedObject(IVariable v, IR ir, int pc) {
        super(v);
        this.ir = ir;
        this.pc = pc;
    }

    public UpdatedObject(IVariable v, IR ir) {
        super(v);
        this.ir = ir;
        this.pc = -1;
    }

    public UpdatedObject(IVariable v, IR ir, SSAInstruction instruction) {
        super(v);
        this.ir = ir;
        this.pc = SAUtil.Domo.findPC(this.ir, instruction);
    }

    public void setIR(IR ir) {
        this.ir = ir;
    }

    public void setPC(int pc) {
        this.pc = pc;
    }

    public IR getIR() {
        return this.ir;
    }

    public int getPC() {
        return this.pc;
    }

    public int hashCode() {
        return super.hashCode() + (this.ir == null ? 0 : this.ir.hashCode()) + this.pc;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            UpdatedObject uo = (UpdatedObject)((Object)obj);
            if (this.ir == null) {
                return uo.ir == null && this.pc == uo.pc;
            }
            return this.ir.equals(uo.ir) && this.pc == uo.pc;
        }
        return false;
    }

    public String toString() {
        return super.toString() + "_" + this.pc;
    }

    public String getName() {
        return super.getName() + "_" + this.pc;
    }

    public boolean matches(ISymbol symbol, IMatchContext context) {
        if (!((Object)((Object)this)).getClass().equals(symbol.getClass())) {
            return false;
        }
        if (this == symbol) {
            return true;
        }
        UpdatedObject uo = (UpdatedObject)symbol;
        if (super.matches((ISymbol)uo, context)) {
            if (this.ir == null) {
                return uo.ir == null && this.pc == uo.pc;
            }
            return this.ir.equals(uo.ir) && this.pc == uo.pc;
        }
        return false;
    }
}

