/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.ssa;

import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.stringAnalysis.ssa.ISSACFGBasicBlock;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.EmptyIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SyntheticAbstractCFG
extends AbstractCFG<SSAInstruction, ISSACFGBasicBlock> {
    private final SSAInstruction[] instructions;
    private final SSACFG delegate;
    private final Map<SSACFG.BasicBlock, ISSACFGBasicBlock> bbMap;

    public SyntheticAbstractCFG(SSACFG cfg) {
        super(cfg.getMethod());
        this.instructions = (SSAInstruction[])cfg.getInstructions().clone();
        this.bbMap = new HashMap<SSACFG.BasicBlock, ISSACFGBasicBlock>();
        this.delegate = cfg;
        this.computeNodes();
        this.init();
        this.computeEdges();
    }

    private void computeNodes() {
        SSACFG.BasicBlock entry = this.delegate.entry();
        SSACFG.BasicBlock exit = this.delegate.exit();
        BasicBlock newEntry = new BasicBlock(entry);
        this.addNode((IBasicBlock)newEntry);
        this.bbMap.put(entry, newEntry);
        for (ISSABasicBlock b : this.delegate) {
            SSACFG.BasicBlock bb = (SSACFG.BasicBlock)b;
            if (bb.isExitBlock() || bb.isEntryBlock()) continue;
            BasicBlock sbb = new BasicBlock(bb);
            this.bbMap.put(bb, sbb);
            this.addNode((IBasicBlock)sbb);
        }
        if (!entry.equals((Object)exit)) {
            BasicBlock newExit = new BasicBlock(exit);
            this.addNode((IBasicBlock)new BasicBlock(exit));
            this.bbMap.put(exit, newExit);
        }
    }

    private void computeEdges() {
        for (ISSABasicBlock b : this.delegate) {
            BasicBlock succSBB;
            SSACFG.BasicBlock succB;
            SSACFG.BasicBlock bb = (SSACFG.BasicBlock)b;
            BasicBlock sbb = (BasicBlock)this.bbMap.get(bb);
            for (ISSABasicBlock succ : this.delegate.getNormalSuccessors((ISSABasicBlock)bb)) {
                succB = (SSACFG.BasicBlock)succ;
                succSBB = new BasicBlock(succB);
                this.bbMap.put(succB, succSBB);
                this.addNormalEdge((IBasicBlock)sbb, (IBasicBlock)succSBB);
            }
            for (ISSABasicBlock succ : this.delegate.getExceptionalSuccessors((ISSABasicBlock)bb)) {
                succB = (SSACFG.BasicBlock)succ;
                succSBB = new BasicBlock(succB);
                this.bbMap.put(succB, succSBB);
                this.addExceptionalEdge((IBasicBlock)sbb, (IBasicBlock)succSBB);
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof SyntheticAbstractCFG)) {
            return false;
        }
        SyntheticAbstractCFG other = (SyntheticAbstractCFG)((Object)o);
        return this.delegate.equals((Object)other.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public ISSACFGBasicBlock getBlockForInstruction(int index) {
        SSACFG.BasicBlock bb = this.delegate.getBlockForInstruction(index);
        return this.bbMap.get(bb);
    }

    public SSAInstruction[] getInstructions() {
        return this.instructions;
    }

    public int getProgramCounter(int index) {
        return this.delegate.getProgramCounter(index);
    }

    public class BasicBlock
    implements ISSACFGBasicBlock {
        private Map<Integer, SSAPhiInstruction> localPhis;
        private Map<Integer, SSAPhiInstruction> stackSlotPhis;
        private SSACFG.BasicBlock delegate;

        public BasicBlock(SSACFG.BasicBlock bb) {
            this.delegate = bb;
            this.localPhis = new HashMap<Integer, SSAPhiInstruction>();
            this.stackSlotPhis = new HashMap<Integer, SSAPhiInstruction>();
            this.fillPhis();
        }

        private void fillPhis() {
            this.delegate.getAllInstructions();
            int i = 0;
            SSAPhiInstruction phi = this.delegate.getPhiForLocal(i);
            while (phi != null) {
                this.localPhis.put(i, phi);
                phi = this.delegate.getPhiForLocal(++i);
            }
            i = 0;
            phi = this.delegate.getPhiForStackSlot(i);
            while (phi != null) {
                this.stackSlotPhis.put(i, phi);
                phi = this.delegate.getPhiForStackSlot(++i);
            }
        }

        public int getNumber() {
            return this.delegate.getNumber();
        }

        public int getFirstInstructionIndex() {
            return this.delegate.getFirstInstructionIndex();
        }

        public boolean isCatchBlock() {
            return this.delegate.isCatchBlock();
        }

        public int getLastInstructionIndex() {
            return this.delegate.getLastInstructionIndex();
        }

        public Iterator<SSAPhiInstruction> iteratePhis() {
            LinkedList<SSAPhiInstruction> result = new LinkedList<SSAPhiInstruction>();
            for (SSAPhiInstruction phi : this.stackSlotPhis.values()) {
                if (phi == null) continue;
                result.add(phi);
            }
            if (this.localPhis == null) {
                return result.iterator();
            }
            for (SSAPhiInstruction phi : this.localPhis.values()) {
                if (phi == null) continue;
                result.add(phi);
            }
            return result.iterator();
        }

        public SSAPhiInstruction getPhiForStackSlot(int slot) {
            return this.stackSlotPhis.get(slot);
        }

        @Override
        public SSAPhiInstruction getPhiForLocal(int n) {
            return this.localPhis.get(n);
        }

        public void addPhiForStackSlot(int slot, SSAPhiInstruction phi) {
            this.stackSlotPhis.put(slot, phi);
        }

        @Override
        public void addPhiForLocal(int n, SSAPhiInstruction phi) {
            this.localPhis.put(n, phi);
        }

        private void removePhis(Map<Integer, SSAPhiInstruction> phis, Set<SSAPhiInstruction> toRemove) {
            HashSet<Integer> rms = new HashSet<Integer>();
            for (Map.Entry<Integer, SSAPhiInstruction> e : phis.entrySet()) {
                if (!toRemove.contains(e.getValue())) continue;
                rms.add(e.getKey());
            }
            Iterator<Map.Entry<Integer, Object>> iterator = rms.iterator();
            while (iterator.hasNext()) {
                int k = (Integer)((Object)iterator.next());
                phis.remove(k);
            }
        }

        @Override
        public void removePhis(Set<SSAPhiInstruction> toRemove) {
            this.removePhis(this.stackSlotPhis, toRemove);
            this.removePhis(this.localPhis, toRemove);
        }

        public Iterator<SSAPiInstruction> iteratePis() {
            return this.delegate.iteratePis();
        }

        public Iterator<SSAInstruction> iterateNormalInstructions() {
            int lookup;
            final int end = this.getLastInstructionIndex();
            for (lookup = this.getFirstInstructionIndex(); lookup <= end && SyntheticAbstractCFG.this.instructions[lookup] == null; ++lookup) {
            }
            final int dummy = lookup;
            return new Iterator<SSAInstruction>(){
                private int start;
                {
                    this.start = dummy;
                }

                @Override
                public boolean hasNext() {
                    return this.start <= end;
                }

                @Override
                public SSAInstruction next() {
                    SSAInstruction i = SyntheticAbstractCFG.this.instructions[this.start];
                    ++this.start;
                    while (this.start <= end && SyntheticAbstractCFG.this.instructions[this.start] == null) {
                        ++this.start;
                    }
                    return i;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public List<SSAInstruction> getAllInstructions() {
            ArrayList<SSAInstruction> result = new ArrayList<SSAInstruction>();
            Iterator<SSAPhiInstruction> it = this.iteratePhis();
            while (it.hasNext()) {
                result.add((SSAInstruction)it.next());
            }
            for (int i = this.getFirstInstructionIndex(); i <= this.getLastInstructionIndex(); ++i) {
                SSAInstruction s = SyntheticAbstractCFG.this.instructions[i];
                if (s == null) continue;
                result.add(s);
            }
            Iterator<SSAPiInstruction> it2 = this.iteratePis();
            while (it2.hasNext()) {
                result.add((SSAInstruction)it2.next());
            }
            return result;
        }

        public Iterator<SSAInstruction> iterator() {
            return this.getAllInstructions().iterator();
        }

        @Override
        public boolean hasPhi() {
            if (!this.localPhis.isEmpty()) {
                return false;
            }
            return this.stackSlotPhis.isEmpty();
        }

        public int getGraphNodeId() {
            return this.delegate.getGraphNodeId();
        }

        public void setGraphNodeId(int number) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "BB[SSA:" + this.getFirstInstructionIndex() + ".." + this.getLastInstructionIndex() + "]" + this.getNumber() + " - " + this.getMethod().getSignature();
        }

        private SyntheticAbstractCFG getGraph() {
            return SyntheticAbstractCFG.this;
        }

        public boolean equals(Object arg0) {
            if (arg0 instanceof BasicBlock) {
                BasicBlock b = (BasicBlock)arg0;
                if (!this.delegate.equals((Object)b.delegate)) {
                    return false;
                }
                if (this.getNumber() == b.getNumber()) {
                    if (this.getMethod().equals(b.getMethod())) {
                        return this.getGraph().equals((Object)b.getGraph());
                    }
                    return false;
                }
                return false;
            }
            return false;
        }

        public IMethod getMethod() {
            return this.delegate.getMethod();
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean isExitBlock() {
            return this == SyntheticAbstractCFG.this.exit();
        }

        public boolean isEntryBlock() {
            return this == SyntheticAbstractCFG.this.entry();
        }

        public SSAInstruction getLastInstruction() {
            return SyntheticAbstractCFG.this.instructions[this.getLastInstructionIndex()];
        }

        public Iterator<TypeReference> getCaughtExceptionTypes() {
            return EmptyIterator.instance();
        }
    }
}

