/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator;

import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractUnaryInstruction;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAFieldAccessInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSAMonitorInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.stringAnalysis.grammar.GR;
import com.ibm.wala.stringAnalysis.grammar.GRule;
import com.ibm.wala.stringAnalysis.grammar.InvocationSymbol;
import com.ibm.wala.stringAnalysis.grammar.SignatureSymbol;
import com.ibm.wala.stringAnalysis.ssa.SAInstructionVisitor;
import com.ibm.wala.stringAnalysis.ssa.SSAInstructionProcessor;
import com.ibm.wala.stringAnalysis.translator.ISSA2Rule;
import com.ibm.wala.stringAnalysis.translator.ISymbolFactory;
import com.ibm.wala.stringAnalysis.translator.ITranslatorRepository;
import com.ibm.wala.stringAnalysis.translator.TranslationContext;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class SSA2Rule<T>
implements ISSA2Rule<T> {
    private ISymbolFactory<T> symbolFactory;
    protected String symbolSeparator = ":";
    protected boolean ignoreField;
    protected boolean ignoreArrayIndex;

    public SSA2Rule(ISymbolFactory<T> symbolFactory, boolean ignoreField, boolean ignoreArrayIndex) {
        this.symbolFactory = symbolFactory;
        this.ignoreField = ignoreField;
        this.ignoreArrayIndex = ignoreArrayIndex;
    }

    public SSA2Rule(ISymbolFactory<T> symbolFactory, boolean ignoreField) {
        this(symbolFactory, ignoreField, true);
    }

    public SSA2Rule(ISymbolFactory<T> symbolFactory) {
        this(symbolFactory, false, true);
    }

    @Override
    public ISymbolFactory<T> getSymbolFactory() {
        return this.symbolFactory;
    }

    @Override
    public GRule createRule(IR ir, SSAInstruction instruction, IVariable left, ISymbol ... right) {
        if (right.length == 0) {
            Assertions.UNREACHABLE();
            return null;
        }
        return new GRule(ir, instruction, left, right);
    }

    protected Collection<GRule> createRules(IR ir, SSAInstruction instruction, Collection<? extends ISymbol> lefts, List<Collection<ISymbol>> rights) {
        HashSet<GRule> result = new HashSet<GRule>();
        for (ISymbol iSymbol : lefts) {
            for (List right : SAUtil.combination1(rights)) {
                result.add(this.createRule(ir, instruction, (IVariable)iSymbol, right.toArray(new ISymbol[right.size()])));
            }
        }
        return result;
    }

    protected Collection<GRule> createUnitRules(IR ir, SSAInstruction instruction, Collection<? extends ISymbol> lefts, Collection<ISymbol> rights) {
        return this.createRules(ir, instruction, lefts, Collections.singletonList(rights));
    }

    protected Collection<GRule> createEqualityRules(IR ir, SSAInstruction instruction, Collection<? extends ISymbol> lefts, Collection<? extends ISymbol> rights) {
        HashSet<GRule> result = new HashSet<GRule>();
        for (ISymbol iSymbol : lefts) {
            for (ISymbol iSymbol2 : rights) {
                result.add(this.createRule(ir, instruction, (IVariable)iSymbol, iSymbol2));
                if (!(iSymbol2 instanceof IVariable)) continue;
                result.add(this.createRule(ir, instruction, (IVariable)iSymbol2, iSymbol));
            }
        }
        return result;
    }

    protected abstract SAInstructionVisitor createTranslatorVisitor(TranslationContext var1, Collection<GRule> var2);

    @Override
    public Collection<GRule> translate(SSAInstruction instruction, TranslationContext ctx) {
        HashSet<GRule> rules = new HashSet<GRule>();
        SSAInstructionProcessor.eachInstruction(new SSAInstruction[]{instruction}, (SSAInstruction.IVisitor)this.createTranslatorVisitor(ctx, rules));
        return rules;
    }

    protected void translatePhiInstruction(SSAPhiInstruction instruction, TranslationContext ctx, Collection<GRule> rules) {
        int nuses = instruction.getNumberOfUses();
        for (int i = 0; i < nuses; ++i) {
            Collection<ISymbol> left = this.symbolFactory.createValueSymbol(instruction.getDef(0), (SSAInstruction)instruction, ctx);
            Collection<ISymbol> right = this.symbolFactory.createValueSymbol(instruction.getUse(i), (SSAInstruction)instruction, ctx);
            rules.addAll(this.createRules(ctx.getIR(), (SSAInstruction)instruction, left, Collections.singletonList(right)));
        }
    }

    protected void translatePiInstruction(SSAPiInstruction instruction, TranslationContext ctx, Collection<GRule> rules) {
        Collection<ISymbol> left = this.symbolFactory.createValueSymbol(instruction.getDef(0), (SSAInstruction)instruction, ctx);
        Collection<ISymbol> right = this.symbolFactory.createValueSymbol(instruction.getVal(), (SSAInstruction)instruction, ctx);
        rules.addAll(this.createRules(ctx.getIR(), (SSAInstruction)instruction, left, Collections.singletonList(right)));
        rules.addAll(this.translate(instruction.getCause(), ctx));
    }

    protected void translateNewInstruction(SSANewInstruction instruction, TranslationContext ctx, Collection<GRule> rules) {
        TypeReference ref = instruction.getConcreteType();
        if (ref.isArrayType() && this.ignoreArrayIndex) {
            Collection<ISymbol> left = this.symbolFactory.createValueSymbol(instruction.getDef(0), (SSAInstruction)instruction, ctx);
            Set<ISymbol> right = Collections.singleton(this.symbolFactory.createNullSymbol());
            rules.addAll(this.createRules(ctx.getIR(), (SSAInstruction)instruction, left, Collections.singletonList(right)));
        }
    }

    private Collection<GRule> createFieldPutRules(IR ir, SSAPutInstruction instruction, Collection<? extends ISymbol> left, Collection<ISymbol> right) {
        if (instruction.getDeclaredFieldType().isArrayType() && this.ignoreArrayIndex) {
            return this.createEqualityRules(ir, (SSAInstruction)instruction, left, right);
        }
        return this.createUnitRules(ir, (SSAInstruction)instruction, left, right);
    }

    protected void translatePut(SSAPutInstruction instruction, TranslationContext ctx, Collection<GRule> rules) {
        if (instruction.isStatic()) {
            Collection<IVariable> left1 = this.symbolFactory.createStaticMemberVariable(instruction.getDeclaredField().getDeclaringClass(), (SSAFieldAccessInstruction)instruction, ctx);
            Collection<ISymbol> right1 = this.symbolFactory.createValueSymbol(instruction.getUse(0), (SSAInstruction)instruction, ctx);
            rules.addAll(this.createFieldPutRules(ctx.getIR(), instruction, left1, right1));
        } else if (this.ignoreField) {
            Collection<ISymbol> right1 = this.symbolFactory.createValueSymbol(instruction.getUse(1), (SSAInstruction)instruction, ctx);
            Collection<ISymbol> left2 = this.symbolFactory.createValueSymbol(instruction.getRef(), (SSAInstruction)instruction, ctx);
            Collection<ISymbol> right2 = right1;
            rules.addAll(this.createFieldPutRules(ctx.getIR(), instruction, left2, right2));
        } else {
            Collection<IVariable> mems = this.symbolFactory.createMemberVariable(instruction.getRef(), (SSAFieldAccessInstruction)instruction, ctx);
            Collection<ISymbol> right = this.symbolFactory.createValueSymbol(instruction.getUse(1), (SSAInstruction)instruction, ctx);
            rules.addAll(this.createFieldPutRules(ctx.getIR(), instruction, mems, right));
        }
    }

    private Collection<GRule> createFieldGetRules(IR ir, SSAGetInstruction instruction, Collection<? extends ISymbol> left, Collection<ISymbol> right) {
        if (instruction.getDeclaredFieldType().isArrayType() && this.ignoreArrayIndex) {
            return this.createEqualityRules(ir, (SSAInstruction)instruction, left, right);
        }
        return this.createUnitRules(ir, (SSAInstruction)instruction, left, right);
    }

    protected void translateGet(SSAGetInstruction instruction, TranslationContext ctx, Collection<GRule> rules) {
        if (!instruction.hasDef()) {
            System.err.println("no lhs: (" + instruction.getClass() + ") " + instruction.toString(ctx.getIR().getSymbolTable()));
            return;
        }
        if (instruction.isStatic()) {
            Collection<ISymbol> left1 = this.symbolFactory.createValueSymbol(instruction.getDef(0), (SSAInstruction)instruction, ctx);
            try {
                Collection<ISymbol> rights1 = this.symbolFactory.createInstanceKeySymbol(instruction.getDef(0), ctx);
                rules.addAll(this.createFieldGetRules(ctx.getIR(), instruction, left1, rights1));
            }
            catch (ISymbolFactory.NoInstanceKeyException e) {
                HashSet<IVariable> right2 = new HashSet<IVariable>(this.symbolFactory.createStaticMemberVariable(instruction.getDeclaredField().getDeclaringClass(), (SSAFieldAccessInstruction)instruction, ctx));
                rules.addAll(this.createFieldGetRules(ctx.getIR(), instruction, left1, right2));
            }
        } else if (this.ignoreField) {
            Collection<ISymbol> left2 = this.symbolFactory.createValueSymbol(instruction.getDef(0), (SSAInstruction)instruction, ctx);
            try {
                Collection<ISymbol> rights2 = this.symbolFactory.createInstanceKeySymbol(instruction.getDef(0), ctx);
                rules.addAll(this.createFieldGetRules(ctx.getIR(), instruction, left2, rights2));
            }
            catch (ISymbolFactory.NoInstanceKeyException e) {
                Collection<ISymbol> right2 = this.symbolFactory.createValueSymbol(instruction.getRef(), (SSAInstruction)instruction, ctx);
                rules.addAll(this.createFieldGetRules(ctx.getIR(), instruction, left2, right2));
            }
        } else {
            Collection<ISymbol> left1 = this.symbolFactory.createValueSymbol(instruction.getDef(0), (SSAInstruction)instruction, ctx);
            try {
                Collection<ISymbol> rights1 = this.symbolFactory.createInstanceKeySymbol(instruction.getDef(0), ctx);
                rules.addAll(this.createFieldGetRules(ctx.getIR(), instruction, left1, rights1));
            }
            catch (ISymbolFactory.NoInstanceKeyException e) {
                HashSet<IVariable> mems = new HashSet<IVariable>(this.symbolFactory.createMemberVariable(instruction.getRef(), (SSAFieldAccessInstruction)instruction, ctx));
                rules.addAll(this.createFieldGetRules(ctx.getIR(), instruction, left1, mems));
            }
        }
    }

    protected void translateUnaryInstruction(SSAAbstractUnaryInstruction instruction, TranslationContext ctx, Collection<GRule> rules) {
        Collection<ISymbol> left = this.symbolFactory.createValueSymbol(instruction.getDef(0), (SSAInstruction)instruction, ctx);
        int v = instruction.getUse(0);
        Collection<ISymbol> right = this.symbolFactory.createValueSymbol(v, (SSAInstruction)instruction, ctx);
        rules.addAll(this.createRules(ctx.getIR(), (SSAInstruction)instruction, left, Collections.singletonList(right)));
    }

    protected void translateBinaryOpInstruction(SSABinaryOpInstruction instruction, TranslationContext ctx, Collection<GRule> rules) {
        Collection<ISymbol> left = this.symbolFactory.createValueSymbol(instruction.getDef(0), (SSAInstruction)instruction, ctx);
        int[] params = new int[instruction.getNumberOfUses()];
        for (int i = 0; i < params.length; ++i) {
            params[i] = instruction.getUse(i);
        }
        Collection<ISymbol> right = this.symbolFactory.createOpSymbol(instruction.getOperator(), params, instruction, ctx);
        rules.addAll(this.createRules(ctx.getIR(), (SSAInstruction)instruction, left, Collections.singletonList(right)));
    }

    protected void translateInvokeInstruction(SSAAbstractInvokeInstruction instruction, TranslationContext ctx, Collection<GRule> rules) {
        MethodReference mref = instruction.getDeclaredTarget();
        TypeReference typeRef = mref.getDeclaringClass();
        if (this.isInitInstruction(instruction, typeRef)) {
            this.createRuleOfInitInstruction(instruction, ctx, typeRef, rules);
        } else {
            Collection<GRule> c = this.translateComposedInvocation(instruction, ctx);
            if (c == null) {
                HashSet<InvocationSymbol> invokeSym = new HashSet<InvocationSymbol>(this.symbolFactory.createInvocationSymbol(instruction, ctx));
                Collection<ISymbol> left = this.symbolFactory.createValueSymbol(instruction.getDef(0), (SSAInstruction)instruction, ctx);
                rules.addAll(this.createRules(ctx.getIR(), (SSAInstruction)instruction, left, Collections.singletonList(invokeSym)));
            } else {
                rules.addAll(c);
            }
        }
    }

    private boolean isInitInstruction(SSAAbstractInvokeInstruction instruction, TypeReference typeRef) {
        if (instruction.isSpecial()) {
            String typeRefName = typeRef.getName().toString();
            if (this.getSymbolFactory().getRepository().isStringClass(typeRefName)) {
                String initSignature = this.createInitSignatureFor(typeRefName);
                String signature = instruction.getDeclaredTarget().getSignature();
                if (signature.startsWith(initSignature)) {
                    return true;
                }
            }
        }
        return false;
    }

    protected String createInitSignatureFor(String typeRefName) {
        return typeRefName.substring(1).replace('/', '.') + "." + this.symbolFactory.getRepository().getInitSignature();
    }

    private void createRuleOfInitInstruction(SSAAbstractInvokeInstruction instruction, TranslationContext ctx, TypeReference typeRef, Collection<GRule> rules) {
        int recv = instruction.getReceiver();
        int paramN = instruction.getNumberOfParameters() - 1;
        int[] params = new int[paramN];
        for (int i = 0; i < paramN; ++i) {
            params[i] = instruction.getUse(i + 1);
        }
        SignatureSymbol sig = new SignatureSymbol(instruction.getDeclaredTarget().getSignature());
        Collection<ISymbol> left = this.getSymbolFactory().createValueSymbol(recv, (SSAInstruction)instruction, ctx);
        HashSet<InvocationSymbol> invokeSyms = new HashSet<InvocationSymbol>(this.getSymbolFactory().createInvocationSymbol(sig, -1, params, (SSAInstruction)instruction, ctx));
        rules.addAll(this.createRules(ctx.getIR(), (SSAInstruction)instruction, left, Collections.singletonList(invokeSyms)));
    }

    private Collection<GRule> translateComposedInvocation(SSAAbstractInvokeInstruction instruction, TranslationContext ctx) {
        HashSet<GRule> rs = new HashSet<GRule>();
        ISymbolFactory<T> sf = this.getSymbolFactory();
        ITranslatorRepository<T> repository = sf.getRepository();
        Set<String> sigs = repository.getSignature(instruction, ctx);
        for (String sig : sigs) {
            if (repository.isComposable(sig)) {
                Collection<IVariable> lv = sf.createCDVariable(instruction.getDef(), ctx);
                Collection<InvocationSymbol> invokeSymbols = repository.getComposer(sig).compose(sig, instruction, sf, ctx);
                if (invokeSymbols == null || invokeSymbols.isEmpty()) {
                    return null;
                }
                ArrayList<Collection<ISymbol>> rparams = new ArrayList<Collection<ISymbol>>();
                rparams.add(new HashSet<InvocationSymbol>(invokeSymbols));
                rs.addAll(this.createRules(ctx.getIR(), (SSAInstruction)instruction, lv, rparams));
                continue;
            }
            return null;
        }
        return rs;
    }

    protected void translateConversionInstruction(SSAConversionInstruction instruction, TranslationContext ctx, Collection<GRule> rules) {
        Collection<ISymbol> left = this.symbolFactory.createValueSymbol(instruction.getDef(0), (SSAInstruction)instruction, ctx);
        Collection<ISymbol> right = this.symbolFactory.createValueSymbol(instruction.getUse(0), (SSAInstruction)instruction, ctx);
        rules.addAll(this.createRules(ctx.getIR(), (SSAInstruction)instruction, left, Collections.singletonList(right)));
    }

    protected void translateArrayStoreInstruction(SSAArrayStoreInstruction instruction, TranslationContext ctx, Collection<GRule> rules) {
        if (this.ignoreArrayIndex) {
            Collection<ISymbol> left2 = this.symbolFactory.createValueSymbol(instruction.getArrayRef(), (SSAInstruction)instruction, ctx);
            Collection<ISymbol> right2 = this.symbolFactory.createValueSymbol(instruction.getValue(), (SSAInstruction)instruction, ctx);
            rules.addAll(this.createRules(ctx.getIR(), (SSAInstruction)instruction, left2, Collections.singletonList(right2)));
        } else {
            Collection<IVariable> left1 = this.symbolFactory.createArrayElementVariable(instruction.getArrayRef(), instruction.getIndex(), (SSAInstruction)instruction, ctx);
            Collection<ISymbol> right1 = this.symbolFactory.createValueSymbol(instruction.getValue(), (SSAInstruction)instruction, ctx);
            rules.addAll(this.createRules(ctx.getIR(), (SSAInstruction)instruction, left1, Collections.singletonList(right1)));
        }
    }

    protected void translateArrayLoadInstruction(SSAArrayLoadInstruction instruction, TranslationContext ctx, Collection<GRule> rules) {
        if (instruction.hasDef()) {
            if (this.ignoreArrayIndex) {
                Collection<ISymbol> left2 = this.symbolFactory.createValueSymbol(instruction.getDef(0), (SSAInstruction)instruction, ctx);
                try {
                    Collection<ISymbol> right2 = this.symbolFactory.createInstanceKeySymbol(instruction.getDef(0), ctx);
                    rules.addAll(this.createRules(ctx.getIR(), (SSAInstruction)instruction, left2, Collections.singletonList(right2)));
                }
                catch (ISymbolFactory.NoInstanceKeyException e) {
                    Collection<ISymbol> right2 = this.symbolFactory.createValueSymbol(instruction.getArrayRef(), (SSAInstruction)instruction, ctx);
                    rules.addAll(this.createRules(ctx.getIR(), (SSAInstruction)instruction, left2, Collections.singletonList(right2)));
                }
            } else {
                Collection<ISymbol> left1 = this.symbolFactory.createValueSymbol(instruction.getDef(0), (SSAInstruction)instruction, ctx);
                HashSet<IVariable> right1 = new HashSet<IVariable>(this.symbolFactory.createArrayElementVariable(instruction.getArrayRef(), instruction.getIndex(), (SSAInstruction)instruction, ctx));
                rules.addAll(this.createRules(ctx.getIR(), (SSAInstruction)instruction, left1, Collections.singletonList(right1)));
            }
        } else {
            System.err.println("no lhs: (" + instruction.getClass() + ") " + instruction.toString(ctx.getIR().getSymbolTable()));
        }
    }

    protected void translateCheckCastInstruction(SSACheckCastInstruction instruction, TranslationContext ctx, Collection<GRule> rules) {
        Collection<ISymbol> left = this.symbolFactory.createValueSymbol(instruction.getDef(), (SSAInstruction)instruction, ctx);
        Collection<ISymbol> right = this.symbolFactory.createValueSymbol(instruction.getVal(), (SSAInstruction)instruction, ctx);
        rules.addAll(this.createRules(ctx.getIR(), (SSAInstruction)instruction, left, Collections.singletonList(right)));
    }

    @Override
    public GR postTranslate(GR gr) {
        return gr;
    }

    protected class BaseTranslatingProcessor
    implements SAInstructionVisitor.Processor {
        protected final TranslationContext context;
        protected final Collection<GRule> rules;

        protected BaseTranslatingProcessor(TranslationContext ctx, Collection<GRule> rules) {
            this.context = ctx;
            this.rules = rules;
        }

        @Override
        public void onSSAAbstractInvokeInstruction(SSAAbstractInvokeInstruction instruction) {
            SSA2Rule.this.translateInvokeInstruction(instruction, this.context, this.rules);
        }

        @Override
        public void onSSABinaryOpInstruction(SSABinaryOpInstruction instruction) {
            SSA2Rule.this.translateBinaryOpInstruction(instruction, this.context, this.rules);
        }

        @Override
        public void onSSAAbstractUnaryInstruction(SSAAbstractUnaryInstruction instruction) {
            SSA2Rule.this.translateUnaryInstruction(instruction, this.context, this.rules);
        }

        @Override
        public void onSSANewInstruction(SSANewInstruction instruction) {
            SSA2Rule.this.translateNewInstruction(instruction, this.context, this.rules);
        }

        @Override
        public void onSSAPhiInstruction(SSAPhiInstruction instruction) {
            SSA2Rule.this.translatePhiInstruction(instruction, this.context, this.rules);
        }

        @Override
        public void onSSAPiInstruction(SSAPiInstruction instruction) {
            SSA2Rule.this.translatePiInstruction(instruction, this.context, this.rules);
        }

        @Override
        public void onSSAGetInstruction(SSAGetInstruction instruction) {
            SSA2Rule.this.translateGet(instruction, this.context, this.rules);
        }

        @Override
        public void onSSAPutInstruction(SSAPutInstruction instruction) {
            SSA2Rule.this.translatePut(instruction, this.context, this.rules);
        }

        @Override
        public void onSSAConditionalBranchInstruction(SSAConditionalBranchInstruction instruction) {
        }

        @Override
        public void onSSASwitchInstruction(SSASwitchInstruction instruction) {
        }

        @Override
        public void onSSAReturnInstruction(SSAReturnInstruction instruction) {
        }

        @Override
        public void onSSAArrayStoreInstruction(SSAArrayStoreInstruction instruction) {
            SSA2Rule.this.translateArrayStoreInstruction(instruction, this.context, this.rules);
        }

        @Override
        public void onSSAArrayLoadInstruction(SSAArrayLoadInstruction instruction) {
            SSA2Rule.this.translateArrayLoadInstruction(instruction, this.context, this.rules);
        }

        @Override
        public void onSSAConversionInstruction(SSAConversionInstruction instruction) {
            SSA2Rule.this.translateConversionInstruction(instruction, this.context, this.rules);
        }

        @Override
        public void onArrayLengthInstruction(SSAArrayLengthInstruction instruction) {
        }

        @Override
        public void onCheckCastInstruction(SSACheckCastInstruction instruction) {
            SSA2Rule.this.translateCheckCastInstruction(instruction, this.context, this.rules);
        }

        @Override
        public void onComparisonInstruction(SSAComparisonInstruction instruction) {
        }

        @Override
        public void onGetCaughtExceptionInstruction(SSAGetCaughtExceptionInstruction instruction) {
        }

        @Override
        public void onGotoInstruction(SSAGotoInstruction instruction) {
        }

        @Override
        public void onInstanceofInstruction(SSAInstanceofInstruction instruction) {
        }

        @Override
        public void onLoadMetadataInstruction(SSALoadMetadataInstruction instruction) {
        }

        @Override
        public void onMonitorInstruction(SSAMonitorInstruction instruction) {
        }

        @Override
        public void onReturnInstruction(SSAReturnInstruction instruction) {
        }

        @Override
        public void onThrowInstruction(SSAThrowInstruction instruction) {
        }
    }
}

