/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.regular.repository;

import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.FreshStateFactory;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.Transition;
import com.ibm.wala.automaton.string.Variable;
import com.ibm.wala.stringAnalysis.translator.TranslationException;
import com.ibm.wala.stringAnalysis.translator.regular.repository.StringMap;
import com.ibm.wala.stringAnalysis.translator.regular.repository.Transducer;

public class StringMapGet
extends Transducer {
    private final int keyIndex;

    public StringMapGet(int target, int keyIndex) {
        super(target);
        this.keyIndex = keyIndex;
    }

    public StringMapGet(int keyIndex) {
        this.keyIndex = keyIndex;
    }

    @Override
    protected IAutomaton createTransducer() throws TranslationException {
        IAutomaton key = (IAutomaton)this.solveStringParameter(this.keyIndex).getLanguage();
        FreshStateFactory sf = new FreshStateFactory(key);
        IState sepEnd = sf.createState(Automatons.prefixState);
        for (IState finState : key.getFinalStates()) {
            Transition t = new Transition(finState, sepEnd, StringMap.KEY_VALUE_SEPARATOR);
            key.getTransitions().add(t);
        }
        Variable v = new Variable("v");
        Transition t = new Transition(sepEnd, sepEnd, (ISymbol)v, new ISymbol[]{v});
        key.getTransitions().add(t);
        key.getFinalStates().clear();
        key.getFinalStates().add(sepEnd);
        return key;
    }

    @Override
    public IAutomaton translate(IAutomaton fst) throws TranslationException {
        if (StringMap.isMap(fst)) {
            return super.translate(fst);
        }
        return StringMapGet.createAnyFST();
    }
}

