/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.util;

import com.ibm.wala.automaton.AUtil;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.stringAnalysis.grammar.BBVariable;
import com.ibm.wala.stringAnalysis.grammar.CDVariable;
import com.ibm.wala.stringAnalysis.grammar.GR;
import com.ibm.wala.stringAnalysis.grammar.ReturnVariable;
import com.ibm.wala.stringAnalysis.util.LocalNameTable;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.collections.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SAUtil
extends AUtil {
    private static SSAOptions.DefaultValues defaultValues = new SSAOptions.DefaultValues(){

        public int getDefaultValue(SymbolTable symtab, int valueNumber) {
            return this.getDefaultValue(symtab, valueNumber);
        }
    };

    public static CDVariable[] createCDVariables(String varName, CallGraph cg, CGNode node) {
        int[] v = Domo.findValueNumbers(cg, node, varName);
        CDVariable[] vars = new CDVariable[v.length];
        for (int i = 0; i < v.length; ++i) {
            vars[i] = new CDVariable(v[i], node);
        }
        return vars;
    }

    public static CDVariable createCDVariable(String varName, CallGraph cg, CGNode node, int lineNumber) {
        int v = Domo.findValueNumber(cg, node, varName, lineNumber);
        CDVariable var = new CDVariable(v, node);
        return var;
    }

    public static CDVariable[] createCDVariables(String varName, CallGraph cg, String signature) {
        HashSet s = new HashSet();
        for (CGNode node : Domo.findCGNodes(cg, signature)) {
            Object[] vars = SAUtil.createCDVariables(varName, cg, node);
            s.addAll(SAUtil.set((Object[])vars));
        }
        CDVariable[] result = new CDVariable[s.size()];
        s.toArray(result);
        return result;
    }

    public static CDVariable[] createCDVariables(String varName, CallGraph cg, String signature, int lineNumber) {
        HashSet<CDVariable> s = new HashSet<CDVariable>();
        for (CGNode node : Domo.findCGNodes(cg, signature)) {
            CDVariable var = SAUtil.createCDVariable(varName, cg, node, lineNumber);
            s.add(var);
        }
        CDVariable[] result = new CDVariable[s.size()];
        s.toArray(result);
        return result;
    }

    public static Collection<CDVariable> findCDVariables(GR gr, CallGraph cg, ICDVariableFinder finder) {
        HashSet<CDVariable> vars = new HashSet<CDVariable>();
        for (CGNode node : cg) {
            if (!finder.isTargetNode(node)) continue;
            for (int v : finder.getTargetValueNumbers(node)) {
                vars.add(new CDVariable(v, node));
            }
        }
        return vars;
    }

    public static Collection<BBVariable> findBBVariables(GR gr, CallGraph cg, IBBVariableFinder finder) {
        HashSet<BBVariable> vars = new HashSet<BBVariable>();
        for (CGNode node : cg) {
            if (!finder.isTargetNode(node)) continue;
            for (Pair<Integer, ISSABasicBlock> v : finder.getTargetValueNumbers(node)) {
                vars.add(new BBVariable((Integer)v.fst, node, (ISSABasicBlock)v.snd));
            }
        }
        return vars;
    }

    public static Collection<ReturnVariable> findReturnVariables(GR gr, CallGraph cg, IReturnVariableFinder finder) {
        HashSet<ReturnVariable> vars = new HashSet<ReturnVariable>();
        for (CGNode node : cg) {
            if (!finder.isTargetNode(node)) continue;
            IR ir = node.getIR();
            Iterator j = ir.iterateAllInstructions();
            while (j.hasNext()) {
                SSAInstruction inst = (SSAInstruction)j.next();
                if (!(inst instanceof SSAReturnInstruction)) continue;
                SSAReturnInstruction ret = (SSAReturnInstruction)inst;
                int n = ret.getNumberOfUses();
                for (int u = 0; u < n; ++u) {
                    int vn = ret.getUse(u);
                    vars.add(new ReturnVariable(vn, node));
                }
            }
        }
        return vars;
    }

    public static Collection<CDVariable> findReturnCDVariables(GR gr, CallGraph cg, IReturnVariableFinder finder) {
        HashSet<CDVariable> vars = new HashSet<CDVariable>();
        for (CGNode node : cg) {
            if (!finder.isTargetNode(node)) continue;
            IR ir = node.getIR();
            Iterator j = ir.iterateAllInstructions();
            while (j.hasNext()) {
                SSAInstruction inst = (SSAInstruction)j.next();
                if (!(inst instanceof SSAReturnInstruction)) continue;
                SSAReturnInstruction ret = (SSAReturnInstruction)inst;
                int n = ret.getNumberOfUses();
                for (int u = 0; u < n; ++u) {
                    int vn = ret.getUse(u);
                    vars.add(new CDVariable(vn, node));
                }
            }
        }
        return vars;
    }

    public static Collection<CDVariable> findParameters(GR gr, CallGraph cg, final Collection<String> methodSignatures) {
        return SAUtil.findCDVariables(gr, cg, new ICDVariableFinder(){

            @Override
            public Collection<Integer> getTargetValueNumbers(CGNode node) {
                ArrayList<Integer> l = new ArrayList<Integer>();
                for (int vn : node.getIR().getParameterValueNumbers()) {
                    l.add(vn);
                }
                return l;
            }

            @Override
            public boolean isTargetNode(CGNode node) {
                return methodSignatures.contains(node.getMethod().getSignature());
            }
        });
    }

    public static Collection<CDVariable> findCDVariables(GR gr, CallGraph cg, Collection<String> invokeSignatures, int n, int findType) {
        return SAUtil.findCDVariables(gr, cg, invokeSignatures, n, findType, null);
    }

    public static Collection<CDVariable> findCDVariables(GR gr, CallGraph cg, Collection<String> invokeSignatures, int n, int findType, Collection<String> methodSignatures) {
        return SAUtil.findCDVariables(gr, cg, new DefaultCDVariableFinder(invokeSignatures, methodSignatures, n, findType));
    }

    public static Collection<BBVariable> findBBVariables(GR gr, CallGraph cg, Collection<String> invokeSignatures, int n, int findType, Collection<String> methodSignatures) {
        return SAUtil.findBBVariables(gr, cg, new DefaultBBVariableFinder(invokeSignatures, methodSignatures, n, findType));
    }

    private static Collection<CDVariable> findCDVariables(GR gr, CallGraph cg, CDVariable var, Collection<GR> history) {
        return SAUtil.findCDVariables(gr, cg, new SimpleCDVariableFinder(var.getCGNode(), Collections.singleton(var.getValueNumber())));
    }

    public static Collection<CDVariable> findCDVariables(GR gr, CallGraph cg, CDVariable var) {
        return SAUtil.findCDVariables(gr, cg, var, new HashSet<GR>());
    }

    public static Collection<CDVariable> findCDVariables(GR gr, CallGraph cg, CDVariable[] vars) {
        ArrayList<CDVariable> l = new ArrayList<CDVariable>();
        for (int i = 0; i < vars.length; ++i) {
            l.addAll(SAUtil.findCDVariables(gr, cg, vars[i]));
        }
        return l;
    }

    public static Collection<CDVariable> findCDVariables(GR gr, String v, CallGraph cg, String signature) {
        return SAUtil.findCDVariables(gr, cg, SAUtil.createCDVariables(v, cg, signature));
    }

    public static Collection<CDVariable> findCDVariables(GR gr, String v, CallGraph cg, String signature, int line) {
        return SAUtil.findCDVariables(gr, cg, SAUtil.createCDVariables(v, cg, signature, line));
    }

    public static Collection<ReturnVariable> findReturnVariables(GR gr, CallGraph cg, Collection<String> methodSignatures) {
        return SAUtil.findReturnVariables(gr, cg, new DefaultReturnVariableFinder(methodSignatures));
    }

    public static Collection<IVariable> findVariables(GR gr, CallGraph cg, Collection<String> signatures, int paramNumber, int findType, Collection<String> methodSignatures) {
        Collection<CDVariable> vars = SAUtil.findBBVariables(gr, cg, signatures, paramNumber, findType, methodSignatures);
        boolean found = false;
        for (CDVariable cDVariable : vars) {
            if (gr.getRules(cDVariable).isEmpty()) continue;
            found = true;
            break;
        }
        if (!found) {
            vars = SAUtil.findCDVariables(gr, cg, signatures, paramNumber, findType, methodSignatures);
        }
        return new HashSet<IVariable>(vars);
    }

    public static int getDefaultValue(SymbolTable tbl, int vn) {
        return tbl.getDefaultValue(vn);
    }

    public static SSAOptions.DefaultValues getDefaultValues() {
        return defaultValues;
    }

    public static class DefaultReturnVariableFinder
    implements IReturnVariableFinder {
        final Collection<String> methodSignatures;

        public DefaultReturnVariableFinder(Collection<String> methodSignatures) {
            this.methodSignatures = methodSignatures;
        }

        @Override
        public boolean isTargetNode(CGNode node) {
            if (this.methodSignatures == null) {
                return true;
            }
            return this.methodSignatures.contains(node.getMethod().getSignature());
        }
    }

    public static class DefaultBBVariableFinder
    extends InstructionBasedBBVariableFinder {
        public static final int FIND_USE = 0;
        public static final int FIND_RECEIVER = 1;
        public static final int FIND_RETURN = 2;
        private Collection<String> invokeSignatures;
        private Collection<String> methodSignatures;
        private int n;
        int findType;

        public DefaultBBVariableFinder(Collection<String> invokeSignatures, Collection<String> methodSignatures, int n, int findType) {
            this.invokeSignatures = invokeSignatures;
            this.methodSignatures = methodSignatures;
            this.n = n;
            this.findType = findType;
        }

        @Override
        public Pair<Integer, ISSABasicBlock> getTargetVariable(SSAInstruction instruction, CGNode node) {
            ISSABasicBlock bb = node.getIR().getBasicBlockForInstruction(instruction);
            if (instruction instanceof SSAAbstractInvokeInstruction) {
                SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)instruction;
                int v = -1;
                switch (this.findType) {
                    case 0: {
                        if (this.n >= invoke.getNumberOfUses()) break;
                        v = invoke.getUse(this.n);
                        break;
                    }
                    case 1: {
                        v = invoke.getReceiver();
                        break;
                    }
                    case 2: {
                        if (this.n >= invoke.getNumberOfReturnValues()) break;
                        v = invoke.getReturnValue(this.n);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown parameter: " + this.findType);
                    }
                }
                return Pair.make((Object)v, (Object)bb);
            }
            if (instruction instanceof SSANewInstruction) {
                SSANewInstruction newInstr = (SSANewInstruction)instruction;
                int v = -1;
                switch (this.findType) {
                    case 0: {
                        if (this.n >= newInstr.getNumberOfUses()) break;
                        v = newInstr.getUse(this.n);
                        break;
                    }
                    case 2: {
                        if (this.n >= newInstr.getNumberOfDefs()) break;
                        v = newInstr.getDef(this.n);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown parameter: " + this.findType);
                    }
                }
                return Pair.make((Object)v, (Object)bb);
            }
            return null;
        }

        @Override
        public boolean isTargetInstruction(SSAInstruction instruction, CGNode node) {
            if (instruction instanceof SSAAbstractInvokeInstruction) {
                SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)instruction;
                MethodReference mref = invoke.getDeclaredTarget();
                return this.invokeSignatures.contains(mref.getSignature());
            }
            if (instruction instanceof SSANewInstruction) {
                SSANewInstruction newInstr = (SSANewInstruction)instruction;
                return this.invokeSignatures.contains(newInstr.getConcreteType().getName().toString());
            }
            return false;
        }

        @Override
        public boolean isTargetNode(CGNode node) {
            if (this.methodSignatures == null) {
                return true;
            }
            return this.methodSignatures.contains(node.getMethod().getSignature());
        }

        public Collection<String> getInvokeSignatures() {
            return this.invokeSignatures;
        }

        public Collection<String> getMethodSignatures() {
            return this.methodSignatures;
        }

        public int getParameterNumber() {
            return this.n;
        }

        public int getFindType() {
            return this.findType;
        }
    }

    public static class DefaultCDVariableFinder
    extends InstructionBasedVariableFinder {
        public static final int FIND_USE = 0;
        public static final int FIND_RECEIVER = 1;
        public static final int FIND_RETURN = 2;
        private Collection<String> invokeSignatures;
        private Collection<String> methodSignatures;
        private int n;
        int findType;

        public DefaultCDVariableFinder(Collection<String> invokeSignatures, Collection<String> methodSignatures, int n, int findType) {
            this.invokeSignatures = invokeSignatures;
            this.methodSignatures = methodSignatures;
            this.n = n;
            this.findType = findType;
        }

        @Override
        public int getTargetVariable(SSAInstruction instruction) {
            if (instruction instanceof SSAAbstractInvokeInstruction) {
                SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)instruction;
                int v = -1;
                switch (this.findType) {
                    case 0: {
                        if (this.n >= invoke.getNumberOfUses()) break;
                        v = invoke.getUse(this.n);
                        break;
                    }
                    case 1: {
                        v = invoke.getReceiver();
                        break;
                    }
                    case 2: {
                        if (this.n >= invoke.getNumberOfReturnValues()) break;
                        v = invoke.getReturnValue(this.n);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown parameter: " + this.findType);
                    }
                }
                return v;
            }
            if (instruction instanceof SSANewInstruction) {
                SSANewInstruction newInstr = (SSANewInstruction)instruction;
                int v = -1;
                switch (this.findType) {
                    case 0: {
                        if (this.n >= newInstr.getNumberOfUses()) break;
                        v = newInstr.getUse(this.n);
                        break;
                    }
                    case 2: {
                        if (this.n >= newInstr.getNumberOfDefs()) break;
                        v = newInstr.getDef(this.n);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown parameter: " + this.findType);
                    }
                }
                return v;
            }
            return -1;
        }

        @Override
        public boolean isTargetInstruction(SSAInstruction instruction) {
            if (instruction instanceof SSAAbstractInvokeInstruction) {
                SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)instruction;
                MethodReference mref = invoke.getDeclaredTarget();
                return this.invokeSignatures.contains(mref.getSignature());
            }
            if (instruction instanceof SSANewInstruction) {
                SSANewInstruction newInstr = (SSANewInstruction)instruction;
                return this.invokeSignatures.contains(newInstr.getConcreteType().getName().toString());
            }
            return false;
        }

        @Override
        public boolean isTargetNode(CGNode node) {
            if (this.methodSignatures == null) {
                return true;
            }
            return this.methodSignatures.contains(node.getMethod().getSignature());
        }

        public Collection<String> getInvokeSignatures() {
            return this.invokeSignatures;
        }

        public Collection<String> getMethodSignatures() {
            return this.methodSignatures;
        }

        public int getParameterNumber() {
            return this.n;
        }

        public int getFindType() {
            return this.findType;
        }
    }

    public static class SimpleCDVariableFinder
    implements ICDVariableFinder {
        private final CGNode node;
        private final Collection<Integer> valueNumbers;

        public SimpleCDVariableFinder(CGNode node, Collection<Integer> valueNumbers) {
            this.node = node;
            this.valueNumbers = valueNumbers;
        }

        @Override
        public Collection<Integer> getTargetValueNumbers(CGNode node) {
            return new HashSet<Integer>(this.valueNumbers);
        }

        @Override
        public boolean isTargetNode(CGNode node) {
            if (this.node == null) {
                return true;
            }
            return node.equals(this.node);
        }
    }

    public static abstract class InstructionBasedBBVariableFinder
    implements IBBVariableFinder {
        @Override
        public Collection<Pair<Integer, ISSABasicBlock>> getTargetValueNumbers(CGNode node) {
            IR ir = node.getIR();
            if (ir == null) {
                return Collections.emptySet();
            }
            HashSet<Pair<Integer, ISSABasicBlock>> vars = new HashSet<Pair<Integer, ISSABasicBlock>>();
            Iterator j = ir.iterateAllInstructions();
            while (j.hasNext()) {
                Pair<Integer, ISSABasicBlock> v;
                SSAInstruction instruction = (SSAInstruction)j.next();
                if (!this.isTargetInstruction(instruction, node) || (v = this.getTargetVariable(instruction, node)) == null) continue;
                vars.add(v);
            }
            return vars;
        }

        public abstract boolean isTargetInstruction(SSAInstruction var1, CGNode var2);

        public abstract Pair<Integer, ISSABasicBlock> getTargetVariable(SSAInstruction var1, CGNode var2);
    }

    public static abstract class InstructionBasedVariableFinder
    implements ICDVariableFinder {
        @Override
        public Collection<Integer> getTargetValueNumbers(CGNode node) {
            IR ir = node.getIR();
            if (ir == null) {
                return Collections.emptySet();
            }
            HashSet<Integer> vars = new HashSet<Integer>();
            Iterator j = ir.iterateAllInstructions();
            while (j.hasNext()) {
                int v;
                SSAInstruction instruction = (SSAInstruction)j.next();
                if (!this.isTargetInstruction(instruction) || (v = this.getTargetVariable(instruction)) <= 0) continue;
                vars.add(v);
            }
            return vars;
        }

        public abstract boolean isTargetInstruction(SSAInstruction var1);

        public abstract int getTargetVariable(SSAInstruction var1);
    }

    public static interface IReturnVariableFinder {
        public boolean isTargetNode(CGNode var1);
    }

    public static interface IBBVariableFinder {
        public boolean isTargetNode(CGNode var1);

        public Collection<Pair<Integer, ISSABasicBlock>> getTargetValueNumbers(CGNode var1);
    }

    public static interface ICDVariableFinder {
        public boolean isTargetNode(CGNode var1);

        public Collection<Integer> getTargetValueNumbers(CGNode var1);
    }

    public static class Domo {
        public static IR getIR(CallGraph cg, CGNode node) {
            IR ir = node.getIR();
            return ir;
        }

        public static Set<CGNode> findCGNodes(CallGraph cg, String signature) {
            HashSet<CGNode> s = new HashSet<CGNode>();
            for (CGNode node : cg) {
                String sig = node.getMethod().getSignature();
                if (!signature.equals(sig)) continue;
                s.add(node);
            }
            return s;
        }

        public static int findPC(IR ir, SSAInstruction instruction) {
            SSAInstruction[] instructions = ir.getInstructions();
            for (int i = 0; i < instructions.length; ++i) {
                if (instruction != instructions[i]) continue;
                return i;
            }
            return -1;
        }

        public static int[] findValueNumbers(CallGraph cg, CGNode node, String varName) {
            LocalNameTable ltable = new LocalNameTable(Domo.getIR(cg, node));
            return ltable.getValueNumbers(varName);
        }

        public static int findValueNumber(CallGraph cg, CGNode node, String varName, int line) {
            IR ir = Domo.getIR(cg, node);
            LocalNameTable ltable = new LocalNameTable(ir);
            int[] vals = ltable.getValueNumbers(varName);
            SSAInstruction[] instructions = ir.getInstructions();
            for (int i = 0; i < instructions.length; ++i) {
                int l = ir.getMethod().getLineNumber(i);
                if (l != line) continue;
                for (int j = 0; j < vals.length; ++j) {
                    String[] names = ir.getLocalNames(i, vals[j]);
                    if (names == null) continue;
                    for (int k = 0; k < names.length; ++k) {
                        if (!names[k].equals(varName)) continue;
                        return vals[j];
                    }
                }
            }
            return -1;
        }

        public static int[] findValueNumbers(CallGraph cg, String signature, String varName) {
            Set<CGNode> nodes = Domo.findCGNodes(cg, signature);
            HashSet<Integer> vSet = new HashSet<Integer>();
            for (CGNode node : nodes) {
                int[] vals = Domo.findValueNumbers(cg, node, varName);
                for (int j = 0; j < vals.length; ++j) {
                    vSet.add(new Integer(vals[j]));
                }
            }
            int[] v = new int[vSet.size()];
            int idx = 0;
            for (Integer ival : vSet) {
                v[idx] = ival;
                ++idx;
            }
            return v;
        }

        public static int[] findValueNumbers(CallGraph cg, String signature, String varName, int line) {
            Set<CGNode> nodes = Domo.findCGNodes(cg, signature);
            HashSet<Integer> vSet = new HashSet<Integer>();
            for (CGNode node : nodes) {
                int val = Domo.findValueNumber(cg, node, varName, line);
                vSet.add(new Integer(val));
            }
            int[] v = new int[vSet.size()];
            int idx = 0;
            for (Integer ival : vSet) {
                v[idx] = ival;
                ++idx;
            }
            return v;
        }
    }
}

