/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.common.mlservices;

import com.hcl.appscan.common.error.ComponentException;
import com.hcl.appscan.common.mlservices.IMLServiceClient;
import com.ibm.appscan.common.http.HttpClient;
import com.ibm.appscan.common.http.HttpResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public abstract class MLServiceFactory {
    public static void startFactory() {
        if (MLServiceFactory.getMLServicesDebugEndpoint().isPresent()) {
            System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        }
    }

    public static boolean areServicesAvailable() {
        return MLServiceFactory.getMLServicesNamespace().isPresent() || MLServiceFactory.getMLServicesDebugEndpoint().isPresent();
    }

    public <T, U, C extends MLService<T, U>> C build(Class<C> clazz) throws MalformedURLException, ComponentException {
        C c = this._get(clazz);
        if (MLServiceFactory.getMLServicesNamespace().isPresent()) {
            return this._build(c, ((MLService)c).m_serviceName + "." + MLServiceFactory.getMLServicesNamespace().get(), false);
        }
        if (MLServiceFactory.getMLServicesDebugEndpoint().isPresent()) {
            return this._build(c, MLServiceFactory.getMLServicesDebugEndpoint().get(), true);
        }
        throw new ComponentException("MLservices are not available");
    }

    public <T, U, C extends MLService<T, U>> C build(Class<C> clazz, String endpoint) throws MalformedURLException, ComponentException {
        return this._build(this._get(clazz), endpoint, false);
    }

    public <T, U, C extends MLService<T, U>> C build(Class<C> clazz, String endpoint, boolean hostOverride) throws MalformedURLException, ComponentException {
        return this._build(this._get(clazz), endpoint, hostOverride);
    }

    protected abstract <T, U, C extends MLService<T, U>> C _get(Class<C> var1) throws ComponentException;

    private <T, U, C extends MLService<T, U>> C _build(final C service, String urlRoot, boolean hostOverride) throws MalformedURLException {
        final HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        if (hostOverride) {
            headers.put("Host", service.m_serviceName);
        }
        final String info_url = new URL("http://" + urlRoot + service.m_path).toString();
        final String infer_url = new URL(info_url + "/infer").toString();
        final String health_url = new URL("http://" + urlRoot + "/v2/health/live").toString();
        service.m_client = new IMLServiceClient<T, U>(){
            private int m_temp_int = 0;

            @Override
            public Map<T, U> infer(Collection<T> t) throws ComponentException {
                HashMap values = new HashMap(t.size());
                HttpClient client = new HttpClient();
                ExecutorService exe_service = Executors.newFixedThreadPool(service.m_parallelRequests);
                List futures = t.stream().collect(Collectors.groupingBy(f -> this.m_temp_int++ / service2.m_batchSize)).values().stream().map(batch -> exe_service.submit(() -> this.processBatch(client, (Collection)batch))).collect(Collectors.toList());
                for (Future future : futures) {
                    try {
                        values.putAll((Map)future.get());
                    }
                    catch (ExecutionException e) {
                        throw new ComponentException(e.getCause());
                    }
                    catch (InterruptedException e) {
                        throw new ComponentException(e);
                    }
                }
                exe_service.shutdown();
                return values;
            }

            @Override
            public String getVersion() {
                String s;
                try {
                    HttpClient client = new HttpClient();
                    HttpResponse response = client.get(info_url, headers, null);
                    JSONObject o = (JSONObject)response.getResponseBodyAsJSON();
                    s = o.getJSONArray("versions").getString(0);
                }
                catch (IOException | JSONException e) {
                    s = null;
                }
                return s != null ? s : "Unknown";
            }

            @Override
            public boolean getHealth() {
                try {
                    return new HttpClient().get(health_url, headers, null).getResponseCode() == 200;
                }
                catch (IOException e) {
                    return false;
                }
            }

            private Map<T, U> processBatch(HttpClient client, Collection<T> batch) throws IOException, ComponentException, JSONException {
                HttpResponse response;
                String body = service.toJson(batch).toString();
                int tries = 0;
                while ((response = client.post(infer_url, headers, body.toCharArray())).getResponseCode() == 503 || tries++ < 10 && response.getResponseCode() != 200) {
                }
                if (response.getResponseCode() != 200) {
                    throw new IOException(service.m_serviceName + " got code: " + response.getResponseCode());
                }
                JSONObject json = (JSONObject)response.getResponseBodyAsJSON();
                return service.fromJson(batch, json);
            }
        };
        return service;
    }

    public static Optional<String> getMLServicesDebugEndpoint() {
        return Optional.ofNullable(System.getProperty("ML_SERVICES_DEBUG_ENDPOINT"));
    }

    public static Optional<String> getMLServicesNamespace() {
        return Optional.ofNullable(System.getProperty("ML_SERVICES_NAMESPACE"));
    }

    static {
        MLServiceFactory.startFactory();
    }

    public static abstract class MLService<T, U> {
        protected int m_batchSize;
        protected int m_parallelRequests;
        protected String m_path;
        protected String m_serviceName;
        protected IMLServiceClient<T, U> m_client;

        public int getBatchSize() {
            return this.m_batchSize;
        }

        public int getParallelRequests() {
            return this.m_parallelRequests;
        }

        public String getPath() {
            return this.m_path;
        }

        public String getServiceName() {
            return this.m_serviceName;
        }

        protected abstract JSONObject toJson(Collection<T> var1) throws ComponentException;

        protected abstract Map<T, U> fromJson(Collection<T> var1, JSONObject var2) throws ComponentException;
    }
}

