/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.logging.stats;

import com.ibm.appscan.common.logging.stats.PrepareStatsWriter;
import com.ibm.appscan.common.utils.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;

public class MergedStatsWriter
extends PrepareStatsWriter {
    private static final String STATS_FILE_NAME = "irgen.stats";
    private static final String regex = "(.*)slices\\" + File.separator + "Java" + "\\" + File.separator + "\\d+(.*)";

    public MergedStatsWriter(File stats_dir) {
        super(stats_dir, stats_dir);
    }

    @Override
    protected String getFileName() {
        return STATS_FILE_NAME;
    }

    @Override
    protected void processStatsFiles(File file) throws ParserConfigurationException, FileNotFoundException, IOException {
        if (!file.getPath().matches(regex)) {
            super.processStatsFiles(file);
            if (file.isFile() && FileUtil.getFileExtension(file).equals("stats") && !file.getName().equalsIgnoreCase("java.stats")) {
                file.delete();
            }
        }
    }
}

