/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.utils;

import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.security.annotation.ValidatorMethod;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ProcessRunner {
    private static String WINDOWS_ESCAPE = "^";
    private static String UNIX_ESCAPE = "\\";
    public static final int OK = 0;
    private String m_args = "";
    private ProcessBuilder m_builder;

    public ProcessRunner(String ... args) {
        this.m_builder = this.createBuilder(args);
    }

    public ProcessRunner(List<String> args) {
        this.m_builder = this.createBuilder(args.toArray(new String[args.size()]));
    }

    public ProcessRunner(boolean escape, String ... args) {
        this.m_builder = this.createBuilder(escape, args);
    }

    public ProcessRunner(boolean escape, List<String> args) {
        this.m_builder = this.createBuilder(escape, args.toArray(new String[args.size()]));
    }

    public String getCommandArgs() {
        return this.m_args;
    }

    @ValidatorMethod
    private ProcessBuilder createBuilder(boolean escape, String ... args) {
        if (escape) {
            return this.createBuilder(args);
        }
        Object[] real_args = new String[args.length];
        int i = 0;
        for (String a : args) {
            real_args[i] = a;
            ++i;
        }
        this.m_args = Arrays.toString(real_args);
        return new ProcessBuilder((String[])real_args);
    }

    @ValidatorMethod
    private ProcessBuilder createBuilder(String ... args) {
        Object[] real_args = new String[args.length];
        int i = 0;
        for (String a : args) {
            StringBuilder str = new StringBuilder();
            for (char c : a.toCharArray()) {
                if (c != '-' && this.isUnsafeCharacter(c)) {
                    str.append(this.getEscapeCharacter());
                }
                str.append(c);
            }
            real_args[i] = str.toString();
            ++i;
        }
        this.m_args = Arrays.toString(real_args);
        return new ProcessBuilder((String[])real_args);
    }

    private boolean isUnsafeCharacter(char c) {
        if (c == '&' || c == '|') {
            return true;
        }
        return !SystemUtil.isWindows() && c == ';';
    }

    private String getEscapeCharacter() {
        if (SystemUtil.isWindows()) {
            return WINDOWS_ESCAPE;
        }
        return UNIX_ESCAPE;
    }

    public void setDirectory(File directory) {
        this.m_builder.directory(directory);
    }

    public void setRedirectOutput(File file) {
        this.m_builder.redirectOutput(file);
    }

    public Map<String, String> environment() {
        return this.m_builder.environment();
    }

    public Process startAsync() throws IOException {
        return this.m_builder.start();
    }

    public int exec(StreamHandler outputHandler, StreamHandler errorHandler) throws IOException, InterruptedException {
        Thread outThread = null;
        Thread errThread = null;
        this.m_builder.redirectErrorStream(errorHandler == null);
        Process process = this.m_builder.start();
        if (outputHandler == null) {
            outputHandler = new StreamHandler();
        }
        outputHandler.setReader(new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF8")));
        outThread = new Thread(outputHandler);
        outThread.start();
        if (errorHandler != null) {
            errorHandler.setReader(new BufferedReader(new InputStreamReader(process.getErrorStream())));
            errThread = new Thread(errorHandler);
            errThread.start();
        }
        try {
            outThread.join();
            if (errThread != null) {
                errThread.join();
            }
            return process.waitFor();
        }
        catch (InterruptedException e) {
            process.destroy();
            throw e;
        }
    }

    public int run(StreamHandler outputHandler, StreamHandler errorHandler) throws IOException {
        try {
            return this.exec(outputHandler, errorHandler);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return -1;
        }
    }

    public int run(StreamHandler outputHandler) throws IOException {
        return this.run(outputHandler, null);
    }

    public static int getRCSignal(int rc) {
        int signal = 0;
        if (!SystemUtil.isWindows()) {
            int _sigExitOffset = 128;
            int _sigMaxNum = 31;
            if (rc > 128 && rc <= 159) {
                signal = rc - 128;
            }
        }
        return signal;
    }

    public static class StreamHandler
    implements Runnable {
        private BufferedReader m_reader = null;
        private IOException m_exception = null;

        private void setReader(BufferedReader reader) {
            this.m_reader = reader;
        }

        protected boolean handle(BufferedReader reader) throws IOException {
            return false;
        }

        protected void handle(String line) {
        }

        @Override
        public final void run() {
            try {
                if (!this.handle(this.m_reader)) {
                    String line = null;
                    while ((line = this.m_reader.readLine()) != null) {
                        this.handle(line);
                    }
                }
            }
            catch (IOException e) {
                this.m_exception = e;
            }
        }

        public final IOException getException() {
            return this.m_exception;
        }
    }
}

