/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.xml;

import com.ibm.appscan.common.model.ISetting;
import com.ibm.appscan.common.xml.DOMWriter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;

public final class SettingsFileWriter {
    private static final String ELEM_SETTINGS = "Settings";
    private static final String ELEM_SETTING = "Setting";
    private File m_file;
    private List<ISetting> m_settings;

    public SettingsFileWriter(File settingsFile, List<ISetting> settings) {
        this.m_file = settingsFile;
        this.m_settings = settings;
    }

    public void write() throws IOException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            DOMWriter writer = new DOMWriter(this.m_file, builder);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            writer.beginElement(ELEM_SETTINGS);
            for (ISetting setting : this.m_settings) {
                Map<String, String> attributes = setting.getProperties();
                writer.beginElement(ELEM_SETTING);
                for (String attribute : attributes.keySet()) {
                    writer.setAttribute(attribute, attributes.get(attribute));
                }
                writer.endElement();
            }
            writer.endElement();
            writer.write(transformer);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (TransformerException e) {
            throw new IOException(e);
        }
    }
}

