/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.common.model;

import com.hcl.appscan.common.scm.ScmUtil;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.utils.SystemUtil;
import java.io.File;
import java.util.regex.Pattern;

public final class ScanFile
implements IScanFile {
    private File m_file = null;
    private String m_analysisPath = null;
    private String m_sourcePath = null;
    private String m_checksum = null;
    private boolean m_excluded = false;

    public ScanFile(File f) {
        this.m_file = f;
        this.m_analysisPath = f.getPath();
    }

    public ScanFile(String filePath) {
        this.m_analysisPath = filePath;
        this.m_file = new File(filePath);
    }

    public ScanFile(File file, String checksum) {
        this(file);
        this.m_checksum = checksum;
    }

    public ScanFile(String analysisPath, String sourcePath, String checksum) {
        this.m_analysisPath = analysisPath;
        this.m_file = new File(analysisPath);
        this.m_sourcePath = sourcePath;
        this.m_checksum = checksum;
    }

    @Override
    public File getFile() {
        return this.m_file;
    }

    @Override
    public void setSourcePath(String path) {
        if (SystemUtil.isCommonEngine()) {
            this.m_sourcePath = path;
        } else {
            path = this.cleanSourcePath(path);
            this.m_sourcePath = ScmUtil.getRepositoryRelativePath(path);
        }
    }

    @Override
    public String getSourcePath() {
        return this.m_sourcePath;
    }

    @Override
    public void setChecksum(String checksum) {
        this.m_checksum = checksum;
    }

    @Override
    public String getChecksum() {
        return this.m_checksum;
    }

    public String toString() {
        return this.m_analysisPath;
    }

    @Override
    public String getAnalysisPath() {
        return this.m_analysisPath;
    }

    @Override
    public void setFile(String filename) {
        this.m_file = new File(filename);
    }

    @Override
    public void setExcluded(boolean excluded) {
        this.m_excluded = excluded;
    }

    @Override
    public boolean isExcluded() {
        return this.m_excluded;
    }

    private String cleanSourcePath(String path) {
        String root;
        String[] parts = path.split(Pattern.quote(File.separator));
        switch (root = parts[0]) {
            case "unzip": {
                if (!SystemUtil.isCloudIRGen()) break;
                path = path.substring(6);
                break;
            }
            case "fallback": {
                if (!SystemUtil.isWindows() || !path.endsWith(".c") && !path.endsWith(".cpp")) break;
                path = path.substring(9);
                break;
            }
            case "analyze": {
                if (!SystemUtil.useStagerForJavaFiles()) break;
                path = path.substring(8);
                break;
            }
            default: {
                if (!SystemUtil.isCloudIRGen() || parts.length <= 2 || !"unzip".equalsIgnoreCase(parts[1])) break;
                path = path.substring(parts[0].length() + parts[1].length() + 2);
            }
        }
        return path;
    }
}

