/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.common.model;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.Messages;
import com.ibm.appscan.common.NullProgress;
import com.ibm.appscan.common.error.IErrorManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTarget;
import com.ibm.appscan.common.model.IScanTargetCollector;
import com.ibm.appscan.common.model.IScanTargetContainerStrategy;
import com.ibm.appscan.common.model.IStagingProvider;
import com.ibm.appscan.common.model.ITransformable;
import com.ibm.appscan.common.model.SaveLocation;
import com.ibm.appscan.common.model.ScanModelVisitor;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.model.StringPattern;
import com.ibm.appscan.common.model.validation.IValidationIssue;
import com.ibm.appscan.common.utils.DirectoryUtil;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.StringUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.internal.common.model.BuildInfoManager;
import com.ibm.appscan.internal.common.model.DisposeVisitor;
import com.ibm.appscan.internal.common.model.ErrorManager;
import com.ibm.appscan.internal.common.model.Scan;
import com.ibm.appscan.internal.common.model.ScanTargetProxy;
import com.ibm.appscan.internal.common.model.ScanTargetProxy2;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ScanTarget
implements IScanTarget {
    private Scan m_scan;
    private ScanTargetStrategy m_strategy;
    String m_languageType = null;
    private boolean m_isExcluded = false;
    private boolean m_isValid = false;
    private boolean m_isDirectoryTarget = false;
    private String m_workingDirectoryName;
    private ITransformable.State m_state = ITransformable.State.CONFIGURED;
    private ScanTarget m_parent = null;
    private List<ScanTarget> m_children = new ArrayList<ScanTarget>();
    private List<IScanFile> m_files = new ArrayList<IScanFile>();
    private File m_stagingDirectory = null;
    private BuildInfoManager m_buildInfoManager;
    private ErrorManager m_error;
    private Collection<IValidationIssue> m_validationIssues;
    private Collection<String> m_namespaces;

    ScanTarget(Scan scan, ScanTargetStrategy strategy) {
        this.m_scan = scan;
        this.m_strategy = strategy;
        this.m_strategy.setStagingProvider(new IStagingProvider(){

            @Override
            public File getStagingDirectory(boolean create) {
                return ScanTarget.this.getStagingDirectory(create);
            }

            @Override
            public File getStagingDirectory(boolean create, String dir) {
                return ScanTarget.this.getStagingDirectory(create, dir);
            }
        });
        this.m_workingDirectoryName = this.createWorkingDirectoryName();
        this.m_buildInfoManager = new BuildInfoManager(this);
        this.m_error = new ErrorManager(this, scan);
        this.m_validationIssues = new ArrayList<IValidationIssue>();
        this.m_namespaces = new HashSet<String>();
    }

    @Override
    public Scan getScan() {
        return this.m_scan;
    }

    @Override
    public String getName() {
        return this.m_strategy.getName();
    }

    @Override
    public String getType() {
        return this.m_strategy.getType();
    }

    @Override
    public String getPath() {
        return this.m_strategy.getPath();
    }

    @Override
    public String getStrategyClass() {
        return this.m_strategy.getStrategyClass();
    }

    @Override
    public String getLanguageType() {
        return this.m_languageType == null ? this.m_strategy.getLanguageType() : this.m_languageType;
    }

    void setValid(boolean valid) {
        this.m_isValid = valid;
        if (!valid) {
            this.setTransformed(false);
        }
    }

    @Override
    public boolean isValid() {
        return this.m_isValid;
    }

    @Override
    public void setIsDirectoryTarget(boolean isDirectoryTarget) {
        this.m_isDirectoryTarget = isDirectoryTarget;
    }

    @Override
    public boolean isDirectoryTarget() {
        return this.m_isDirectoryTarget;
    }

    @Override
    public void setWorkingDirectoryName(String name) {
        this.m_workingDirectoryName = name;
    }

    @Override
    public String getWorkingDirectoryName() {
        return this.m_workingDirectoryName;
    }

    @Override
    public boolean isExcluded() {
        return this.m_isExcluded;
    }

    @Override
    public ScanTargetStrategy getStrategy() {
        return this.m_strategy;
    }

    File getWorkingDirectory() {
        if (this.m_parent == null) {
            SaveLocation location = this.m_scan.getSaveLocation();
            if (location != null) {
                return new File(location.getWorkLocation(), this.m_workingDirectoryName);
            }
        } else {
            File parent = this.m_parent.getWorkingDirectory();
            if (parent != null) {
                return new File(parent, this.m_workingDirectoryName);
            }
        }
        return null;
    }

    @Override
    public void setTransformed(boolean transform) {
        if (transform) {
            this.m_state = ITransformable.State.TRANSFORMED;
        } else if (this.m_state == ITransformable.State.TRANSFORMED) {
            this.m_state = ITransformable.State.CONFIGURED;
            this.m_scan.setTransformed(false);
        }
    }

    @Override
    public ITransformable.State getState() {
        return this.m_state;
    }

    ScanTarget newScanTarget(ScanTargetStrategy strategy) {
        return this.m_scan.newScanTarget(strategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ScanTarget newChildScanTarget(ScanTargetStrategy strategy, boolean isExcluded) {
        ScanTarget child = this.newScanTarget(strategy);
        child.m_isExcluded = isExcluded;
        Scan scan = this.m_scan;
        synchronized (scan) {
            if (!this.m_scan.contains(child) && !this.m_children.contains(child)) {
                this.m_children.add(child);
                child.m_parent = this;
                child.m_error.m_parent = this.m_error;
                strategy.setParent(this.m_strategy);
                return child;
            }
        }
        return null;
    }

    @Override
    public IScanTarget getParent() {
        return this.m_parent;
    }

    @Override
    public Collection<IScanTarget> getChildren() {
        ArrayList<IScanTarget> children = new ArrayList<IScanTarget>();
        for (ScanTarget target : this.m_children) {
            if (target.m_isExcluded) continue;
            children.add(target);
        }
        return children;
    }

    @Override
    public Collection<IScanTarget> getIncludedAndExcludedChildren() {
        ArrayList<IScanTarget> children = new ArrayList<IScanTarget>();
        children.addAll(this.m_children);
        return children;
    }

    boolean handlesIncludesExcludes() {
        return this.m_strategy.handlesIncludesExcludes();
    }

    StringPattern getAdjustedPattern(StringPattern pattern) {
        return this.m_strategy.getAdjustedPattern(pattern);
    }

    @Override
    public boolean findScanTargets(IScanTargetCollector collector, IProgress progress) {
        if (progress == null) {
            progress = new NullProgress();
        }
        if (this.m_strategy instanceof IScanTargetContainerStrategy) {
            ScanTargetProxy proxy = new ScanTargetProxy(this, collector);
            this.m_strategy.findScanTargets(proxy, progress);
            return proxy.getCount() == 0;
        }
        this.m_strategy.findScanTargets(new ScanTargetProxy2(this, collector), progress);
        return true;
    }

    @Override
    public void findScanFiles(IProgress progress) {
        if (progress == null) {
            progress = new NullProgress();
        }
        this.m_error.clearErrors();
        this.clearScanFiles(true, progress);
        this.m_validationIssues.clear();
        progress.resetStatus();
        Set<IScanFile> files = this.m_strategy.getScanFiles(new ScanTargetProxy2(this), progress);
        if (files != null) {
            this.m_files.addAll(files);
        }
        this.m_isValid = this.m_error.getErrors().isEmpty();
    }

    @Override
    public Collection<IScanFile> getScanFiles() {
        return Collections.unmodifiableCollection(this.m_files);
    }

    synchronized void clearScanFiles(boolean clearAll, IProgress progress) {
        if (this.m_stagingDirectory != null) {
            try {
                if (!clearAll || SystemUtil.shouldDeleteFiles()) {
                    File toDelete = this.m_stagingDirectory.getParentFile();
                    if (progress != null) {
                        progress.setStatus(new Message(1, Messages.getMessage("cleaning.up", toDelete)));
                    }
                    DirectoryUtil.delete(toDelete);
                }
                this.m_stagingDirectory = null;
            }
            catch (IOException e) {
                this.m_error.reportError(e.getMessage(), e);
            }
        }
        if (clearAll) {
            this.m_files.clear();
            this.setValid(false);
        }
    }

    @Override
    public synchronized File getStagingDirectory(boolean create) {
        return this.getStagingDirectory(create, "d");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized File getStagingDirectory(boolean create, String dir) {
        if (this.m_stagingDirectory == null && create) {
            SaveLocation location = this.m_scan.getSaveLocation();
            File parent = location == null ? new File(System.getProperty("java.io.tmpdir")) : location.getWorkLocation();
            String name = StringUtil.shortenString(this.getName(), 5, "");
            this.m_stagingDirectory = new File(parent, '_' + name + this.getPath().hashCode() + "/" + dir);
            parent = this.m_stagingDirectory.getParentFile();
            parent.mkdirs();
            try {
                try {
                    if (this.m_stagingDirectory.exists()) {
                        DirectoryUtil.delete(this.m_stagingDirectory);
                    }
                }
                finally {
                    IOUtil.write(new ByteArrayInputStream(this.getName().getBytes()), new File(parent, ".appscanstaging"));
                }
            }
            catch (IOException e) {
                this.m_scan.getLogManager().log(new Message(e));
            }
        }
        return this.m_stagingDirectory;
    }

    @Override
    public BuildInfoManager getBuildInfoManager() {
        return this.m_buildInfoManager;
    }

    @Override
    public IErrorManager getErrorManager() {
        return this.m_error;
    }

    @Override
    public void accept(ScanModelVisitor visitor) {
        if (!this.m_isExcluded || visitor.shouldVisitExcluded()) {
            visitor.internalVisit(this);
            for (ScanTarget child : this.m_children) {
                child.accept(visitor);
            }
            visitor.internalPostVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ScanTarget) {
            ScanTarget other = (ScanTarget)obj;
            if (other.getPath().equals(this.getPath()) && !other.getStrategyClass().equalsIgnoreCase(this.getStrategyClass())) {
                return false;
            }
            if (other.getLanguageType() != null) {
                return other.getPath().equals(this.getPath()) && other.getLanguageType().equals(this.getLanguageType());
            }
            if (this.getLanguageType() != null) {
                return other.getPath().equals(this.getPath()) && this.getLanguageType().equals(other.getLanguageType());
            }
            return other.getPath().equals(this.getPath());
        }
        return false;
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public String toString() {
        return this.getName() + " [" + this.m_strategy.getStrategyClass() + "]";
    }

    @Override
    public void dispose(IProgress progress) {
        this.accept(new DisposeVisitor(false, progress));
    }

    @Override
    public void inject(String path) {
    }

    @Override
    public Collection<IValidationIssue> getValidationIssues() {
        return this.m_validationIssues;
    }

    @Override
    public Collection<String> getNameSpaces() {
        return this.m_namespaces;
    }

    private String createWorkingDirectoryName() {
        String lang = this.getLanguageType() == null ? "" : this.getLanguageType();
        String trimmedName = this.getName().length() > 3 ? this.getName().substring(0, 3) : this.getName();
        for (char c : trimmedName.toCharArray()) {
            if (c >= '\u0000' && c <= '\u007f') continue;
            trimmedName = trimmedName.replace(c, 'z');
        }
        return trimmedName + lang + this.getPath().hashCode();
    }
}

